/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.collaboration.internal.ui.preference;

import com.ibm.team.collaboration.internal.ui.CollaborationMessages;
import com.ibm.team.collaboration.internal.ui.CollaborationUIPlugin;
import com.ibm.team.collaboration.ui.preference.ICollaborationPreferenceUI;
import com.ibm.team.repository.client.ITeamRepository;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.text.MessageFormat;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.swt.widgets.Shell;

public final class CollaborationPreferenceUIProxy
implements ICollaborationPreferenceUI {
    static final String ATTRIBUTE_CLASS = "class";
    static final String ATTRIBUTE_ID = "id";
    static final String ELEMENT_PREFERENCE_UI = "preferenceUI";
    private final IConfigurationElement fElement;
    private Reference<ICollaborationPreferenceUI> fReference = null;

    CollaborationPreferenceUIProxy(IConfigurationElement element) {
        Assert.isNotNull((Object)element);
        this.fElement = element;
    }

    public ITeamRepository createRepositoryConnection(Shell shell) {
        this.lazyLoadPreferenceUI();
        if (this.fReference != null) {
            ICollaborationPreferenceUI preferenceUI = this.fReference.get();
            if (preferenceUI == null) {
                this.lazyLoadPreferenceUI();
            }
            if ((preferenceUI = this.fReference.get()) != null) {
                return preferenceUI.createRepositoryConnection(shell);
            }
        }
        return null;
    }

    public String getId() {
        return this.fElement.getAttribute(ATTRIBUTE_ID);
    }

    private void lazyLoadPreferenceUI() {
        if (this.fReference == null || this.fReference.get() == null) {
            try {
                Object object = this.fElement.createExecutableExtension(ATTRIBUTE_CLASS);
                if (object instanceof ICollaborationPreferenceUI) {
                    this.fReference = new WeakReference<ICollaborationPreferenceUI>((ICollaborationPreferenceUI)object);
                }
            }
            catch (CoreException exception) {
                CollaborationUIPlugin plugin = CollaborationUIPlugin.getInstance();
                plugin.log(MessageFormat.format(CollaborationMessages.CollaborationPreferenceUIProxy_0, this.getId()));
                plugin.log(exception);
            }
        }
    }
}

