/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.collaboration.internal.ui.preference;

import com.ibm.team.collaboration.internal.ui.CollaborationMessages;
import com.ibm.team.collaboration.internal.ui.CollaborationUIPlugin;
import com.ibm.team.collaboration.ui.preference.CollaborationAccountControlConfiguration;
import com.ibm.team.collaboration.ui.preference.ICollaborationAccountControl;
import com.ibm.team.collaboration.ui.preference.ICollaborationAccountListener;
import com.ibm.team.collaboration.ui.preference.ICollaborationAccountUI;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.text.MessageFormat;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.swt.widgets.Composite;

final class CollaborationAccountUIProxy
implements ICollaborationAccountUI {
    static final String ATTRIBUTE_CLASS = "class";
    static final String ATTRIBUTE_ID = "id";
    static final String ATTRIBUTE_PROVIDER_ID = "providerId";
    static final String ELEMENT_ACCOUNT_UI = "accountUI";
    private final IConfigurationElement fElement;
    private Reference<ICollaborationAccountUI> fReference = null;

    CollaborationAccountUIProxy(IConfigurationElement element) {
        Assert.isNotNull((Object)element);
        this.fElement = element;
    }

    public ICollaborationAccountControl createControl(Composite parent, ICollaborationAccountListener listener, CollaborationAccountControlConfiguration configuration) {
        this.lazyLoadAccountUI();
        if (this.fReference != null) {
            ICollaborationAccountUI accountUI = this.fReference.get();
            if (accountUI == null) {
                this.lazyLoadAccountUI();
            }
            if ((accountUI = this.fReference.get()) != null) {
                return accountUI.createControl(parent, listener, configuration);
            }
        }
        return null;
    }

    public String getId() {
        return this.fElement.getAttribute(ATTRIBUTE_ID);
    }

    public String getProviderId() {
        return this.fElement.getAttribute(ATTRIBUTE_PROVIDER_ID);
    }

    private void lazyLoadAccountUI() {
        if (this.fReference == null || this.fReference.get() == null) {
            try {
                Object object = this.fElement.createExecutableExtension(ATTRIBUTE_CLASS);
                if (object instanceof ICollaborationAccountUI) {
                    this.fReference = new WeakReference<ICollaborationAccountUI>((ICollaborationAccountUI)object);
                }
            }
            catch (CoreException exception) {
                CollaborationUIPlugin plugin = CollaborationUIPlugin.getInstance();
                plugin.log(MessageFormat.format(CollaborationMessages.CollaborationAccountUIProxy_0, this.getId()));
                plugin.log(exception);
            }
        }
    }
}

