/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.collaboration.internal.ui.preference;

import com.ibm.team.collaboration.core.CollaborationCore;
import com.ibm.team.collaboration.core.account.CollaborationAccountInfo;
import com.ibm.team.collaboration.core.provider.CollaborationProvider;
import com.ibm.team.collaboration.core.provider.ICollaborationProvider;
import com.ibm.team.collaboration.core.session.CollaborationUser;
import com.ibm.team.collaboration.internal.core.provider.CollaborationProviderProxy;
import com.ibm.team.collaboration.internal.ui.CollaborationMessages;
import com.ibm.team.collaboration.internal.ui.preference.CollaborationAccountUIProxy;
import com.ibm.team.collaboration.internal.ui.preference.CollaborationAccountUIRegistry;
import com.ibm.team.collaboration.internal.ui.preference.MissingCollaborationAccountControl;
import com.ibm.team.collaboration.ui.preference.CollaborationAccountControlConfiguration;
import com.ibm.team.collaboration.ui.preference.ICollaborationAccountControl;
import com.ibm.team.collaboration.ui.preference.ICollaborationAccountListener;
import com.ibm.team.foundation.client.util.FoundationJob;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CollaborationAccountDialog
extends StatusDialog {
    private static final int DEFAULT_HEIGHT = 400;
    private static final int DEFAULT_WIDTH = 400;
    private Composite fAccountComposite = null;
    private final Map<String, CollaborationAccountInfo> fAccountInfos = new HashMap<String, CollaborationAccountInfo>(4);
    private final ICollaborationAccountListener fAccountListener = new ICollaborationAccountListener(){

        public void statusChanged(IStatus status) {
            Assert.isNotNull((Object)status);
            CollaborationAccountDialog.this.updateStatus(status);
        }
    };
    private CollaborationAccountUIProxy fCurrentContribution = null;
    ICollaborationAccountControl fCurrentControl = null;
    final Collection<CollaborationUser> fCurrentIdentities;
    private CollaborationAccountInfo fCurrentInfo;
    ICollaborationProvider fCurrentProvider = null;
    Composite fDialogComposite = null;
    private final String fDialogTitle;
    private Combo fProviderCombo = null;
    private final List<ICollaborationProvider> fProviderList;
    final Map<ICollaborationProvider, Boolean> fProviderMap;

    public CollaborationAccountDialog(Shell parent, String title, Map<ICollaborationProvider, Boolean> providers, CollaborationAccountInfo info, Collection<CollaborationUser> identities) {
        super(parent);
        Assert.isNotNull((Object)title);
        Assert.isNotNull(providers);
        Assert.isLegal((!providers.isEmpty() ? 1 : 0) != 0, (String)"Providers must not be empty.");
        Assert.isNotNull(identities);
        Assert.isLegal((!identities.isEmpty() ? 1 : 0) != 0, (String)"Identities must not be empty.");
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fDialogTitle = title;
        this.fCurrentInfo = info;
        this.fCurrentIdentities = identities;
        this.fProviderMap = new LinkedHashMap<ICollaborationProvider, Boolean>(providers);
        this.fProviderList = new ArrayList<ICollaborationProvider>(this.fProviderMap.keySet());
    }

    public CollaborationAccountDialog(Shell parent, String title, Map<ICollaborationProvider, Boolean> providers, Collection<CollaborationUser> identities) {
        this(parent, title, providers, null, identities);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.fDialogTitle);
        Rectangle rect = this.getParentShell().getBounds();
        shell.setBounds(Math.max(0, rect.x + (rect.width - 400) / 2), Math.max(0, rect.y + (rect.height - 400) / 2), 400, 400);
    }

    public void create() {
        super.create();
        this.getShell().pack(true);
    }

    CollaborationAccountInfo createAccountInfo() {
        if (this.fCurrentControl == null) {
            return null;
        }
        CollaborationAccountInfo info = this.fCurrentControl.getAccountInfo();
        if (info == null) {
            return null;
        }
        return info.clone();
    }

    protected Control createDialogArea(Composite parent) {
        Assert.isNotNull((Object)parent);
        this.fDialogComposite = new Composite(parent, 0);
        this.fDialogComposite.setLayoutData((Object)new GridData(4, 1, true, true));
        this.fDialogComposite.setLayout((Layout)new GridLayout(1, false));
        if (this.fProviderList.size() > 1) {
            Group group = new Group(this.fDialogComposite, 0);
            group.setLayoutData((Object)new GridData(4, 4, true, false));
            group.setText(CollaborationMessages.CollaborationAccountDialog_2);
            group.setLayout((Layout)new GridLayout(2, false));
            Label label = new Label((Composite)group, 0);
            label.setText(CollaborationMessages.CollaborationAccountDialog_3);
            label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
            this.fProviderCombo = new Combo((Composite)group, -1);
            int selected = -1;
            int index = 0;
            int firstAvailable = -1;
            for (ICollaborationProvider provider : this.fProviderList) {
                CollaborationProviderProxy proxy;
                boolean enforceSingleton;
                String id = provider.getId();
                if (this.fCurrentInfo != null && id.equals(this.fCurrentInfo.getProviderId())) {
                    selected = index;
                }
                if (selected == -1 && firstAvailable == -1 && !(enforceSingleton = this.fProviderMap.get(provider).booleanValue()) && provider instanceof CollaborationProviderProxy && (proxy = (CollaborationProviderProxy)provider).isAutoCreate()) {
                    firstAvailable = index;
                }
                this.fProviderCombo.add(provider.getDisplayName());
                ++index;
            }
            if (selected == -1) {
                if (firstAvailable == -1) {
                    firstAvailable = 0;
                }
                selected = firstAvailable;
            }
            this.fProviderCombo.select(selected);
            this.fProviderCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.fProviderCombo.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent event) {
                    CollaborationAccountDialog.this.handleProviderChanged();
                }
            });
        }
        this.fAccountComposite = new Composite(this.fDialogComposite, 0);
        this.fAccountComposite.setLayoutData((Object)new GridData(4, 1, true, true));
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.fAccountComposite.setLayout((Layout)layout);
        Link link = new Link(this.fDialogComposite, 64);
        link.setText(CollaborationMessages.CollaborationAccountDialog_0);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Control control = CollaborationAccountDialog.this.fDialogComposite.getDisplay().getFocusControl();
                while (control != null) {
                    if (control.isListening(28)) {
                        control.notifyListeners(28, new Event());
                        break;
                    }
                    control = control.getParent();
                }
            }
        });
        GridData data = new GridData(1, 1, true, false);
        data.verticalIndent = 4;
        data.horizontalIndent = 4;
        link.setLayoutData((Object)data);
        if (this.fCurrentInfo != null) {
            this.fAccountInfos.put(this.fCurrentInfo.getProviderId(), this.fCurrentInfo);
        }
        this.handleProviderChanged();
        Dialog.applyDialogFont((Control)this.fDialogComposite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.fDialogComposite, "com.ibm.team.collaboration.ui.account_dialog");
        return this.fDialogComposite;
    }

    public CollaborationAccountInfo getAccountInfo() {
        return this.fCurrentInfo;
    }

    CollaborationAccountUIProxy getAccountUI(ICollaborationProvider provider) {
        Assert.isNotNull((Object)provider);
        String id = provider.getId();
        List proxies = CollaborationAccountUIRegistry.getInstance().getDescriptors();
        for (CollaborationAccountUIProxy proxy : proxies) {
            if (!id.equals(proxy.getProviderId())) continue;
            if (this.fCurrentContribution != null && this.fCurrentContribution.getId().equals(proxy.getId())) {
                return this.fCurrentContribution;
            }
            return proxy;
        }
        return null;
    }

    void handleProviderChanged() {
        ICollaborationProvider provider = this.fProviderList.get(this.fProviderCombo.getSelectionIndex());
        if (this.fCurrentProvider != null) {
            if (provider.getId().equals(this.fCurrentProvider.getId())) {
                return;
            }
            CollaborationAccountInfo info = this.createAccountInfo();
            if (info != null) {
                this.fAccountInfos.put(this.fCurrentProvider.getId(), info);
            }
        }
        this.fCurrentProvider = provider;
        CollaborationAccountUIProxy oldContribution = this.fCurrentContribution;
        this.fCurrentContribution = this.getAccountUI(this.fCurrentProvider);
        Shell shell = this.getShell();
        try {
            shell.setRedraw(false);
            boolean change = true;
            if (this.fCurrentContribution != null) {
                final CollaborationAccountInfo info = this.fAccountInfos.get(this.fCurrentProvider.getId());
                boolean bl = change = oldContribution == null || !this.fCurrentContribution.getId().equals(oldContribution.getId());
                if (change) {
                    if (this.fCurrentControl != null) {
                        this.fCurrentControl.dispose();
                        this.fCurrentControl = null;
                    }
                    this.fCurrentControl = this.fCurrentContribution.createControl(this.fAccountComposite, this.fAccountListener, new CollaborationAccountControlConfiguration(){

                        @Override
                        public boolean enforceSingletonAccount() {
                            return CollaborationAccountDialog.this.fProviderMap.get(CollaborationAccountDialog.this.fCurrentProvider);
                        }

                        @Override
                        public Collection<CollaborationUser> getIdentities() {
                            return CollaborationAccountDialog.this.fCurrentIdentities;
                        }

                        @Override
                        public CollaborationUser getIdentity() {
                            if (info != null) {
                                return info.getUser();
                            }
                            return CollaborationAccountDialog.this.fCurrentIdentities.iterator().next();
                        }

                        @Override
                        public ICollaborationProvider getProvider() {
                            return CollaborationAccountDialog.this.fCurrentProvider;
                        }
                    });
                }
                if (info != null) {
                    this.fCurrentControl.setAccountInfo(info);
                } else {
                    if (this.fCurrentProvider != null) {
                        this.fCurrentProvider = CollaborationCore.getCollaborationService().getProvider(this.fCurrentProvider.getId());
                    }
                    if (this.fCurrentProvider instanceof CollaborationProvider) {
                        final CollaborationProvider extended = (CollaborationProvider)this.fCurrentProvider;
                        FoundationJob job = new FoundationJob(CollaborationMessages.CollaborationAccountDialog_7){

                            public IStatus runProtected(IProgressMonitor monitor) {
                                final CollaborationAccountInfo[] infos = new CollaborationAccountInfo[]{extended.createDefaultAccountInfo(CollaborationAccountDialog.this.fCurrentIdentities.iterator().next(), monitor)};
                                CollaborationAccountDialog.this.fDialogComposite.getDisplay().asyncExec(new Runnable(){

                                    public void run() {
                                        if ((this).CollaborationAccountDialog.this.fCurrentControl != null && (this).CollaborationAccountDialog.this.fCurrentControl.getControl() != null && !(this).CollaborationAccountDialog.this.fCurrentControl.getControl().isDisposed()) {
                                            if (infos[0] == null) {
                                                infos[0] = (this).CollaborationAccountDialog.this.fCurrentControl.getAccountInfo();
                                            }
                                            if (infos[0] != null) {
                                                (this).CollaborationAccountDialog.this.fCurrentControl.setAccountInfo(infos[0]);
                                            }
                                        }
                                    }
                                });
                                return Status.OK_STATUS;
                            }
                        };
                        job.setPriority(10);
                        job.setSystem(true);
                        job.schedule();
                    }
                }
            } else {
                if (this.fCurrentControl != null) {
                    this.fCurrentControl.dispose();
                    this.fCurrentControl = null;
                }
                this.fCurrentControl = new MissingCollaborationAccountControl(this.fAccountComposite, this.fCurrentProvider);
            }
            if (change && shell.isVisible()) {
                this.fDialogComposite.layout(true, true);
                Point size = shell.getSize();
                shell.pack(true);
                shell.setSize(Math.max(400, size.x), Math.max(400, size.y));
            }
            Dialog.applyDialogFont((Control)this.fDialogComposite);
        }
        finally {
            shell.setRedraw(true);
        }
    }

    protected void okPressed() {
        this.fCurrentInfo = this.createAccountInfo();
        super.okPressed();
    }

    protected void updateButtonsEnableState(IStatus status) {
        Button button = this.getButton(0);
        if (button != null && !button.isDisposed()) {
            button.setEnabled(status.isOK() && status.getCode() == 0);
        }
    }
}

