/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.collaboration.internal.ui.manager;

import com.ibm.team.collaboration.core.meeting.CollaborationData;
import com.ibm.team.collaboration.core.meeting.CollaborationMeeting;
import com.ibm.team.collaboration.core.meeting.CollaborationMeetingEvent;
import com.ibm.team.collaboration.core.meeting.ICollaborationMeetingListener;
import com.ibm.team.collaboration.core.meeting.MeetingInvitationRequest;
import com.ibm.team.collaboration.core.session.CollaborationPresence;
import com.ibm.team.collaboration.core.session.CollaborationPresenceEvent;
import com.ibm.team.collaboration.core.session.CollaborationSessionEvent;
import com.ibm.team.collaboration.core.session.CollaborationUser;
import com.ibm.team.collaboration.core.session.ICollaborationPresenceListener;
import com.ibm.team.collaboration.core.session.ICollaborationSessionListener;
import com.ibm.team.collaboration.internal.ui.CollaborationMessages;
import com.ibm.team.collaboration.internal.ui.viewer.CollaborationViewerUIProxy;
import com.ibm.team.collaboration.internal.ui.viewer.CollaborationViewerUIRegistry;
import com.ibm.team.collaboration.ui.CollaborationUI;
import com.ibm.team.foundation.client.util.FoundationJob;
import com.ibm.team.foundation.rcp.core.notification.Notification;
import com.ibm.team.foundation.rcp.core.notification.NotificationInfo;
import com.ibm.team.jface.JazzResources;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import java.net.URL;
import java.util.Collections;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public final class CollaborationMeetingViewerManager
implements ICollaborationPresenceListener,
ICollaborationSessionListener,
ICollaborationMeetingListener {
    private static CollaborationMeetingViewerManager fgInstance = null;

    public static synchronized CollaborationMeetingViewerManager getInstance() {
        if (fgInstance == null) {
            fgInstance = new CollaborationMeetingViewerManager();
        }
        return fgInstance;
    }

    static boolean isLoggedIn(CollaborationUser user) {
        Object origin;
        Assert.isNotNull((Object)user);
        IContributorHandle handle = user.getContributor();
        if (handle != null && (origin = handle.getOrigin()) instanceof ITeamRepository) {
            ITeamRepository repository = (ITeamRepository)origin;
            return handle.sameItemId((IItemHandle)repository.loggedInContributor());
        }
        return false;
    }

    private CollaborationMeetingViewerManager() {
    }

    public void meetingNotification(final CollaborationMeetingEvent event) {
        Assert.isNotNull((Object)event);
        switch (event.getType()) {
            case 2: 
            case 8: {
                FoundationJob job = new FoundationJob(CollaborationMessages.CollaborationMeetingViewerManager_1){

                    protected IStatus runProtected(IProgressMonitor monitor) {
                        return CollaborationMeetingViewerManager.this.meetingNotification(event, monitor);
                    }
                };
                job.setPriority(10);
                job.setSystem(true);
                job.schedule();
            }
        }
    }

    IStatus meetingNotification(CollaborationMeetingEvent event, IProgressMonitor monitor) {
        Assert.isNotNull((Object)event);
        CollaborationViewerUIRegistry registry = CollaborationViewerUIRegistry.getInstance();
        String providerId = event.getMeeting().getSession().getProvider().getId();
        if (!registry.hasViewerUI(providerId)) {
            return Status.OK_STATUS;
        }
        CollaborationViewerUIProxy viewer = registry.getViewerUI(providerId);
        if (viewer != null) {
            return viewer.manageMeeting(event, monitor);
        }
        return new Status(4, "com.ibm.team.collaboration.rcp.ui", CollaborationMessages.CollaborationMeetingViewerManager_0);
    }

    public void presenceNotification(final CollaborationPresenceEvent event) {
        Assert.isNotNull((Object)event);
        if (!event.isInitial() && !event.getPresence().getStatus().isUnkown()) {
            FoundationJob job = new FoundationJob(CollaborationMessages.CollaborationMeetingViewerManager_3){

                protected IStatus runProtected(IProgressMonitor monitor) {
                    CollaborationMeetingViewerManager.this.sendTeamNotification(event, monitor);
                    return Status.OK_STATUS;
                }
            };
            job.setPriority(50);
            job.setSystem(true);
            job.schedule();
        }
    }

    void sendTeamNotification(CollaborationPresenceEvent event, IProgressMonitor monitor) {
        Assert.isNotNull((Object)event);
        Assert.isNotNull((Object)monitor);
        try {
            monitor.beginTask(CollaborationMessages.CollaborationMeetingViewerManager_4, 200);
            CollaborationUser user = event.getUser();
            if (!CollaborationMeetingViewerManager.isLoggedIn(user)) {
                ImageDescriptor descriptor;
                CollaborationPresence presence = event.getPresence();
                NotificationInfo info = new NotificationInfo(presence.getText((IProgressMonitor)new SubProgressMonitor(monitor, 100, 2)), null){

                    public boolean isSameTo(NotificationInfo other) {
                        return this.getDetail().equals(other.getDetail());
                    }
                };
                final IContributorHandle handle = user.getContributor();
                if (handle != null && (descriptor = CollaborationUI.getImageDescriptor(handle, 48, 48, (IProgressMonitor)new SubProgressMonitor(monitor, 100, 2))) != null) {
                    info.setImageUrl(JazzResources.getConformingURL((URL)JazzResources.createURL((ImageDescriptor)descriptor)));
                }
                info.setDetail((Object)user.getUUID());
                if (handle != null) {
                    info.setRunnable(new Runnable(){

                        public void run() {
                            IWorkbenchPart part;
                            IWorkbenchPage page;
                            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                            if (window != null && (page = window.getActivePage()) != null && (part = page.getActivePart()) != null) {
                                FoundationJob job = new FoundationJob(CollaborationMessages.CollaborationMeetingViewerManager_5){

                                    protected IStatus runProtected(IProgressMonitor progress) {
                                        return CollaborationUI.contactContributors(part, Collections.singleton(handle), null, progress);
                                    }
                                };
                                job.setPriority(10);
                                job.setSystem(false);
                                job.schedule();
                            }
                        }
                    });
                }
                Notification.send((String)"com.ibm.team.collaboration.presence.change", (NotificationInfo)info);
            }
        }
        finally {
            monitor.done();
        }
    }

    public void sessionNotification(final CollaborationSessionEvent event) {
        Assert.isNotNull((Object)event);
        final CollaborationMeeting meeting = event.getMeeting();
        switch (event.getType()) {
            case 3: {
                meeting.addMeetingListener((ICollaborationMeetingListener)this);
                break;
            }
            case 4: {
                meeting.removeMeetingListener((ICollaborationMeetingListener)this);
                break;
            }
            case 2: {
                FoundationJob job = new FoundationJob(CollaborationMessages.CollaborationMeetingViewerManager_2){

                    protected IStatus runProtected(IProgressMonitor monitor) {
                        return CollaborationMeetingViewerManager.this.meetingNotification(new CollaborationMeetingEvent(meeting, 2, meeting.getSession().getUser(), (CollaborationData)new MeetingInvitationRequest(Collections.singleton(event.getUser()), true), null), monitor);
                    }
                };
                job.setPriority(10);
                job.setSystem(true);
                job.schedule();
            }
        }
    }
}

