/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.collaboration.internal.ui.action;

import com.ibm.team.collaboration.core.meeting.CollaborationData;
import com.ibm.team.collaboration.core.meeting.SendDataRequest;
import com.ibm.team.collaboration.core.session.CollaborationUser;
import com.ibm.team.collaboration.internal.core.service.DefaultCollaborationService;
import com.ibm.team.collaboration.internal.ui.CollaborationMessages;
import com.ibm.team.collaboration.internal.ui.action.AbstractContactActionDelegate;
import com.ibm.team.collaboration.ui.context.ICollaborationContextProvider;
import com.ibm.team.foundation.common.URIReference;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;

public final class SendFileContributorsActionDelegate
extends AbstractContactActionDelegate {
    public SendFileContributorsActionDelegate() {
        super(5);
    }

    protected boolean canEnable() {
        if (!super.canEnable()) {
            return false;
        }
        DefaultCollaborationService service = DefaultCollaborationService.getInstance();
        for (CollaborationUser user : this.fUsers) {
            if (!service.getPresenceStatus(user).isOffline()) continue;
            return false;
        }
        return !this.getAvailableAccounts(service.getProviders(5)).isEmpty();
    }

    protected String getActionDescription() {
        return CollaborationMessages.SendFileContributorsAction_0;
    }

    protected String getActionLabel() {
        return CollaborationMessages.SendFileContributorsAction_1;
    }

    protected ICollaborationContextProvider getContextProvider() {
        return new ICollaborationContextProvider(){

            @Override
            public CollaborationData getContext(final Collection<CollaborationUser> users, IProgressMonitor monitor) {
                Assert.isNotNull(users);
                final CollaborationData[] result = new CollaborationData[1];
                Display display = PlatformUI.getWorkbench().getDisplay();
                if (!display.isDisposed()) {
                    display.syncExec(new Runnable(){

                        public void run() {
                            Shell shell;
                            IWorkbenchPartSite site;
                            IWorkbenchPart part = SendFileContributorsActionDelegate.this.getWorkbenchPart();
                            if (part != null && (site = part.getSite()) != null && (shell = site.getShell()) != null && !shell.isDisposed()) {
                                FileDialog dialog = new FileDialog(shell, 4096);
                                dialog.setText(CollaborationMessages.SendFileContributorsAction_3);
                                String path = dialog.open();
                                result[0] = path != null && !"".equals(path) ? new SendDataRequest(users, new File(path)) : CANCEL_CONTEXT;
                            }
                        }
                    });
                }
                return result[0];
            }

            @Override
            public Collection<URIReference> getTopics(Collection<CollaborationUser> users, IProgressMonitor monitor) {
                Assert.isNotNull(users);
                return Collections.emptyList();
            }
        };
    }

    protected String getHelpContextId() {
        return "com.ibm.team.collaboration.ui.send_file";
    }

    protected String getJobName() {
        return CollaborationMessages.SendFileContributorsAction_2;
    }

    protected boolean isSystemJob() {
        return true;
    }
}

