/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.collaboration.internal.ui.action;

import com.ibm.team.collaboration.core.meeting.CollaborationData;
import com.ibm.team.collaboration.core.meeting.MessageComposeRequest;
import com.ibm.team.collaboration.core.session.CollaborationUser;
import com.ibm.team.collaboration.internal.ui.CollaborationMessages;
import com.ibm.team.collaboration.internal.ui.action.AbstractContactActionDelegate;
import com.ibm.team.collaboration.ui.context.ICollaborationContextProvider;
import com.ibm.team.foundation.common.URIReference;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.HTMLTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public final class SendClipboardContributorsActionDelegate
extends AbstractContactActionDelegate {
    static final CollaborationData getClipboardContents() {
        final String[] message = new String[1];
        final String[] type = new String[]{"text/html"};
        final Display display = PlatformUI.getWorkbench().getDisplay();
        if (display != null && !display.isDisposed()) {
            display.syncExec(new Runnable(){

                public void run() {
                    Clipboard clipboard = new Clipboard(display);
                    try {
                        int index;
                        message[0] = (String)clipboard.getContents((Transfer)HTMLTransfer.getInstance());
                        if (message[0] != null && (index = message[0].indexOf("</a><!-")) > 0) {
                            message[0] = message[0].substring(0, index + 4);
                        }
                        if (message[0] == null) {
                            message[0] = (String)clipboard.getContents((Transfer)TextTransfer.getInstance());
                            type[0] = "text/plain";
                        }
                    }
                    finally {
                        clipboard.dispose();
                    }
                }
            });
        }
        if (message[0] != null && type[0] != null) {
            return new MessageComposeRequest(message[0], type[0]);
        }
        return null;
    }

    public SendClipboardContributorsActionDelegate() {
        super(1);
    }

    protected String getActionDescription() {
        return CollaborationMessages.SendClipboardContributorsAction_0;
    }

    protected String getActionLabel() {
        return CollaborationMessages.SendClipboardContributorsAction_1;
    }

    protected ICollaborationContextProvider getContextProvider() {
        return new ICollaborationContextProvider(){

            @Override
            public CollaborationData getContext(Collection<CollaborationUser> users, IProgressMonitor monitor) {
                Assert.isNotNull(users);
                return SendClipboardContributorsActionDelegate.getClipboardContents();
            }

            @Override
            public Collection<URIReference> getTopics(Collection<CollaborationUser> users, IProgressMonitor monitor) {
                Assert.isNotNull(users);
                return Collections.emptyList();
            }
        };
    }

    protected String getHelpContextId() {
        return "com.ibm.team.collaboration.ui.send_clipboard";
    }

    protected String getJobName() {
        return CollaborationMessages.SendClipboardContributorsAction_2;
    }
}

