/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.collaboration.internal.ui.action;

import com.ibm.team.collaboration.core.CollaborationCore;
import com.ibm.team.collaboration.core.account.CollaborationAccountEvent;
import com.ibm.team.collaboration.core.account.ICollaborationAccountListener;
import com.ibm.team.collaboration.core.service.ICollaborationService;
import com.ibm.team.collaboration.core.session.CollaborationPresenceEvent;
import com.ibm.team.collaboration.core.session.CollaborationPresenceStatus;
import com.ibm.team.collaboration.core.session.CollaborationSessionEvent;
import com.ibm.team.collaboration.core.session.CollaborationUser;
import com.ibm.team.collaboration.core.session.ICollaborationPresenceListener;
import com.ibm.team.collaboration.core.session.ICollaborationSessionListener;
import com.ibm.team.collaboration.internal.core.service.DefaultCollaborationService;
import com.ibm.team.collaboration.internal.ui.CollaborationMessages;
import com.ibm.team.collaboration.internal.ui.util.ChangePresenceMenuCreator;
import com.ibm.team.collaboration.ui.CollaborationUI;
import com.ibm.team.foundation.client.util.FoundationJob;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import java.text.MessageFormat;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;

public final class ChangePresenceAction
extends Action {
    private final ChangePresenceMenuCreator fMenuCreator;
    private final CollaborationServiceListener fServiceListener = new CollaborationServiceListener();

    public ChangePresenceAction(ChangePresenceMenuCreator creator) {
        super(CollaborationPresenceStatus.STATUS_UNKNOWN.getText(), 4);
        Assert.isNotNull((Object)creator);
        this.fMenuCreator = creator;
        this.setId("com.ibm.team.collaboration.ui.change.presence");
        this.setDescription(CollaborationMessages.ChangePresenceAction_5);
        this.setImageDescriptor(CollaborationUI.getImageDescriptor(CollaborationPresenceStatus.STATUS_UNKNOWN, true));
        this.setToolTipText(CollaborationPresenceStatus.STATUS_UNKNOWN.getText());
        ICollaborationService service = CollaborationCore.getCollaborationService();
        service.addSessionListener((ICollaborationSessionListener)this.fServiceListener);
        service.addPresenceListener((ICollaborationPresenceListener)this.fServiceListener);
        service.getAccountManager().addAccountListener((ICollaborationAccountListener)this.fServiceListener);
        this.setMenuCreator(this.fMenuCreator);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "com.ibm.team.collaboration.ui.change_presence");
        this.updateNotification();
    }

    static boolean hasLoggedInRepositories() {
        ITeamRepository[] repositories;
        ITeamRepository[] iTeamRepositoryArray = repositories = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
        int n = repositories.length;
        int n2 = 0;
        while (n2 < n) {
            ITeamRepository repository = iTeamRepositoryArray[n2];
            if (repository.loggedIn()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void dispose() {
        this.fMenuCreator.dispose();
        ICollaborationService service = CollaborationCore.getCollaborationService();
        service.removePresenceListener((ICollaborationPresenceListener)this.fServiceListener);
        service.removeSessionListener((ICollaborationSessionListener)this.fServiceListener);
        service.getAccountManager().removeAccountListener((ICollaborationAccountListener)this.fServiceListener);
    }

    public void run() {
        Shell shell;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (shell = window.getShell()) != null) {
            PreferencesUtil.createPreferenceDialogOn((Shell)shell, (String)"com.ibm.team.collaboration.ui.imAccountsPage", null, null).open();
        }
    }

    void updateNotification() {
        FoundationJob job = new FoundationJob(CollaborationMessages.ChangePresenceAction_6){

            protected IStatus runProtected(IProgressMonitor monitor) {
                Assert.isNotNull((Object)monitor);
                DefaultCollaborationService service = DefaultCollaborationService.getInstance();
                CollaborationUser user = service.getAccountManager().getDefaultIdentity();
                CollaborationPresenceStatus status = CollaborationPresenceStatus.STATUS_OFFLINE;
                if (user != null) {
                    status = service.getPresenceStatus(user, monitor);
                }
                boolean hasLoggedInRepositories = ChangePresenceAction.hasLoggedInRepositories();
                boolean loggedIn = service.isLoggedIn(0);
                final boolean connectEnabled = hasLoggedInRepositories && service.isLoggedOut(0);
                final boolean disconnectEnabled = hasLoggedInRepositories && loggedIn;
                final CollaborationPresenceStatus finalStatus = status;
                Display display = PlatformUI.getWorkbench().getDisplay();
                if (!display.isDisposed()) {
                    display.asyncExec(new Runnable(){

                        public void run() {
                            String offlineText = CollaborationPresenceStatus.STATUS_OFFLINE.getText();
                            ChangePresenceAction.this.setText(finalStatus.isUnkown() ? offlineText : finalStatus.getText());
                            ChangePresenceAction.this.setToolTipText(!connectEnabled && !disconnectEnabled || finalStatus.isUnkown() ? MessageFormat.format(CollaborationMessages.ChangePresenceAction_8, offlineText) : finalStatus.getText());
                            ChangePresenceAction.this.setImageDescriptor(CollaborationUI.getImageDescriptor(finalStatus, true));
                        }
                    });
                }
                return Status.OK_STATUS;
            }
        };
        job.setPriority(20);
        job.setSystem(true);
        job.schedule();
    }

    private final class CollaborationServiceListener
    implements ICollaborationSessionListener,
    ICollaborationPresenceListener,
    ICollaborationAccountListener {
        CollaborationServiceListener() {
        }

        public void accountNotification(CollaborationAccountEvent event) {
            ChangePresenceAction.this.updateNotification();
        }

        public void presenceNotification(CollaborationPresenceEvent event) {
            ChangePresenceAction.this.updateNotification();
        }

        public void sessionNotification(CollaborationSessionEvent event) {
            ChangePresenceAction.this.updateNotification();
        }
    }
}

