/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.collaboration.internal.ui.action;

import com.ibm.team.collaboration.core.CollaborationCore;
import com.ibm.team.collaboration.core.account.CollaborationAccountInfo;
import com.ibm.team.collaboration.core.meeting.CollaborationData;
import com.ibm.team.collaboration.core.meeting.CollaborationMeeting;
import com.ibm.team.collaboration.core.meeting.MeetingCreationRequest;
import com.ibm.team.collaboration.core.meeting.MeetingCreationResult;
import com.ibm.team.collaboration.core.provider.ICollaborationProvider;
import com.ibm.team.collaboration.core.service.ICollaborationService;
import com.ibm.team.collaboration.core.session.CollaborationPresenceStatus;
import com.ibm.team.collaboration.core.session.CollaborationUser;
import com.ibm.team.collaboration.internal.core.service.DefaultCollaborationService;
import com.ibm.team.collaboration.internal.ui.CollaborationMessages;
import com.ibm.team.collaboration.internal.ui.util.CollaborationExceptionHandler;
import com.ibm.team.collaboration.ui.context.ICollaborationContextProvider;
import com.ibm.team.foundation.client.util.FoundationJob;
import com.ibm.team.foundation.common.URIReference;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.UUID;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.LegacyActionTools;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractContactActionDelegate
implements IObjectActionDelegate {
    protected static final CollaborationData CANCEL_CONTEXT = new CollaborationData("cancel-0", null, null, null);
    private final int fCapabilities;
    protected IWorkbenchPart fPart = null;
    protected Collection<CollaborationUser> fUsers = Collections.emptyList();

    static final boolean areActive(Collection<CollaborationUser> users, IProgressMonitor monitor) {
        Assert.isNotNull(users);
        Assert.isNotNull((Object)monitor);
        try {
            monitor.beginTask(CollaborationMessages.AbstractContributorAction_0, 100 * users.size());
            DefaultCollaborationService service = DefaultCollaborationService.getInstance();
            for (CollaborationUser user : users) {
                CollaborationPresenceStatus status = service.getPresenceStatus(user, (IProgressMonitor)new SubProgressMonitor(monitor, 100, 2));
                if (status.isActive()) continue;
                return false;
            }
            return true;
        }
        finally {
            monitor.done();
        }
    }

    /*
     * Exception decompiling
     */
    public static IStatus composeMail(Collection<CollaborationUser> users, Collection<URIReference> topics, CollaborationData context, IProgressMonitor monitor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static final String createTopicBody(Collection<URIReference> topics) {
        Assert.isNotNull(topics);
        StringBuilder builder = new StringBuilder(256);
        for (URIReference topic : topics) {
            builder.append(topic.getURI().toString());
            builder.append('\n');
        }
        if (builder.length() == 0) {
            return CollaborationMessages.AbstractContributorAction_11;
        }
        return builder.toString();
    }

    static final String createTopicSubject(Collection<URIReference> topics) {
        Assert.isNotNull(topics);
        StringBuilder builder = new StringBuilder(256);
        for (URIReference topic : topics) {
            if (builder.length() != 0) {
                builder.append(", ");
            }
            builder.append(topic.getName());
        }
        if (builder.length() == 0) {
            return CollaborationMessages.AbstractContributorAction_12;
        }
        return MessageFormat.format(CollaborationMessages.AbstractContributorAction_9, builder.toString());
    }

    static final String urlEncode(CollaborationData data) throws UnsupportedEncodingException {
        String message = data.getMessage();
        if (message != null && !"".equals(message)) {
            return URLEncoder.encode(message, "UTF-8").replaceAll("\\+", "%20");
        }
        return null;
    }

    static final String urlEncode(String string) throws UnsupportedEncodingException {
        return URLEncoder.encode(string, "UTF-8").replaceAll("\\+", "%20");
    }

    protected AbstractContactActionDelegate() {
        this.fCapabilities = -1;
    }

    protected AbstractContactActionDelegate(int capabilities) {
        Assert.isLegal((capabilities > 0 ? 1 : 0) != 0, (String)"Capabilities must be positive");
        this.fCapabilities = capabilities;
    }

    protected boolean canEnable() {
        return !this.fUsers.isEmpty();
    }

    final IStatus composeMail(Collection<CollaborationUser> users, IProgressMonitor monitor) {
        Assert.isNotNull(users);
        Assert.isNotNull((Object)monitor);
        try {
            monitor.beginTask(CollaborationMessages.AbstractContributorAction_4, 300);
            Collection<URIReference> topics = null;
            CollaborationData context = null;
            ICollaborationContextProvider provider = this.getContextProvider();
            if (provider != null) {
                topics = provider.getTopics(users, (IProgressMonitor)new SubProgressMonitor(monitor, 100, 2));
                context = provider.getContext(users, (IProgressMonitor)new SubProgressMonitor(monitor, 100, 2));
            }
            if (topics == null) {
                topics = Collections.emptySet();
            }
            IStatus iStatus = AbstractContactActionDelegate.composeMail(users, topics, context, (IProgressMonitor)new SubProgressMonitor(monitor, 100, 2));
            return iStatus;
        }
        finally {
            monitor.done();
        }
    }

    protected abstract String getActionDescription();

    protected ImageDescriptor getActionImage() {
        return null;
    }

    protected abstract String getActionLabel();

    protected Collection<CollaborationAccountInfo> getAvailableAccounts(Collection<ICollaborationProvider> providers) {
        Assert.isNotNull(providers);
        Collection accounts = CollaborationCore.getCollaborationService().getAccountManager().getAccounts();
        HashSet<CollaborationAccountInfo> result = new HashSet<CollaborationAccountInfo>(accounts.size());
        for (ICollaborationProvider provider : providers) {
            String id = provider.getId();
            for (CollaborationAccountInfo info : accounts) {
                if (!id.equals(info.getProviderId())) continue;
                result.add(info);
            }
        }
        return result;
    }

    protected Collection<ICollaborationProvider> getAvailableProviders(Collection<CollaborationUser> users) {
        Assert.isNotNull(users);
        Assert.isLegal((!users.isEmpty() ? 1 : 0) != 0, (String)"Users must not be empty.");
        int secondary = users.size() > 1 ? 512 : 0;
        ICollaborationService service = CollaborationCore.getCollaborationService();
        if (this.fCapabilities < 0) {
            return service.getProviders(secondary | 1);
        }
        if (this.fCapabilities > 0) {
            return service.getProviders(secondary | this.fCapabilities);
        }
        return Collections.emptySet();
    }

    protected ICollaborationContextProvider getContextProvider() {
        IWorkbenchPart adaptable = this.getWorkbenchPart();
        if (adaptable != null) {
            return (ICollaborationContextProvider)adaptable.getAdapter(ICollaborationContextProvider.class);
        }
        return null;
    }

    protected abstract String getHelpContextId();

    protected abstract String getJobName();

    protected IWorkbenchPart getWorkbenchPart() {
        IWorkbenchPart part;
        IWorkbenchPage page;
        IWorkbenchWindow window;
        if (this.fPart != null) {
            return this.fPart;
        }
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null && (window = workbench.getActiveWorkbenchWindow()) != null && (page = window.getActivePage()) != null && (part = page.getActivePart()) != null) {
            return part;
        }
        return null;
    }

    protected boolean isSystemJob() {
        return false;
    }

    public void run(IAction action) {
        Assert.isNotNull((Object)action);
        if (!this.fUsers.isEmpty()) {
            FoundationJob job = new FoundationJob(this.getJobName()){

                protected IStatus runProtected(IProgressMonitor monitor) {
                    Assert.isNotNull((Object)monitor);
                    return CollaborationExceptionHandler.handleErrorStatus(AbstractContactActionDelegate.this.run(monitor));
                }
            };
            job.setPriority(10);
            job.setSystem(this.isSystemJob());
            job.schedule();
        }
    }

    public IStatus run(IProgressMonitor monitor) {
        Assert.isNotNull((Object)monitor);
        try {
            Collection<CollaborationAccountInfo> infos;
            monitor.beginTask(MessageFormat.format(CollaborationMessages.AbstractContributorAction_1, this.getJobName()), 300);
            Collection<ICollaborationProvider> providers = this.getAvailableProviders(this.fUsers);
            if (!providers.isEmpty() && !(infos = this.getAvailableAccounts(providers)).isEmpty()) {
                Display display = PlatformUI.getWorkbench().getDisplay();
                if (AbstractContactActionDelegate.areActive(this.fUsers, (IProgressMonitor)new SubProgressMonitor(monitor, 100, 2))) {
                    IStatus status = this.startMeeting(this.fUsers, (IProgressMonitor)new SubProgressMonitor(monitor, 200, 2));
                    if (12 == status.getCode() && !display.isDisposed()) {
                        display.syncExec(new Runnable(){

                            public void run() {
                                Shell shell;
                                IWorkbenchPartSite site;
                                IWorkbenchPart part = AbstractContactActionDelegate.this.getWorkbenchPart();
                                if (part != null && (site = part.getSite()) != null && (shell = site.getShell()) != null && !shell.isDisposed()) {
                                    String label = LegacyActionTools.removeMnemonics((String)LegacyActionTools.removeAcceleratorText((String)AbstractContactActionDelegate.this.getActionLabel()));
                                    if (label.endsWith("...")) {
                                        label = label.substring(0, label.length() - 3);
                                    }
                                    MessageDialog.openError((Shell)shell, (String)label, (String)CollaborationMessages.AbstractContributorAction_13);
                                }
                            }
                        });
                        IStatus iStatus = Status.OK_STATUS;
                        return iStatus;
                    }
                    IStatus iStatus = status;
                    return iStatus;
                }
                final boolean[] send = new boolean[1];
                if (!display.isDisposed()) {
                    display.syncExec(new Runnable(){

                        public void run() {
                            Shell shell;
                            IWorkbenchPartSite site;
                            IWorkbenchPart part = AbstractContactActionDelegate.this.getWorkbenchPart();
                            if (part != null && (site = part.getSite()) != null && (shell = site.getShell()) != null && !shell.isDisposed()) {
                                String message = AbstractContactActionDelegate.this.fUsers.size() == 1 ? CollaborationMessages.AbstractContributorAction_14 : CollaborationMessages.AbstractContributorAction_3;
                                send[0] = MessageDialog.openQuestion((Shell)shell, (String)CollaborationMessages.AbstractContributorAction_2, (String)message);
                            }
                        }
                    });
                }
                if (send[0]) {
                    IStatus iStatus = this.composeMail(this.fUsers, (IProgressMonitor)new SubProgressMonitor(monitor, 200, 2));
                    return iStatus;
                }
                monitor.worked(200);
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            IStatus iStatus = this.composeMail(this.fUsers, (IProgressMonitor)new SubProgressMonitor(monitor, 300, 2));
            return iStatus;
        }
        finally {
            monitor.done();
        }
    }

    public final void selectionChanged(IAction action, ISelection selection) {
        Assert.isNotNull((Object)action);
        Assert.isNotNull((Object)selection);
        this.fUsers = Collections.emptyList();
        if (selection instanceof IStructuredSelection) {
            Object[] elements;
            IStructuredSelection extended = (IStructuredSelection)selection;
            this.fUsers = new ArrayList<CollaborationUser>(extended.size());
            ICollaborationService service = CollaborationCore.getCollaborationService();
            Object[] objectArray = elements = extended.toArray();
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                if (element instanceof IContributorHandle) {
                    IContributorHandle handle = (IContributorHandle)element;
                    this.fUsers.add(service.getUser(handle));
                }
                ++n2;
            }
        }
        if (this.fUsers.isEmpty()) {
            action.setEnabled(false);
        } else {
            Collection<CollaborationAccountInfo> infos = this.getAvailableAccounts(this.getAvailableProviders(this.fUsers));
            if (!infos.isEmpty()) {
                action.setEnabled(this.canEnable());
            } else {
                action.setEnabled(this.fCapabilities < 0 && this.canEnable());
            }
        }
    }

    public final void setActivePart(IAction action, IWorkbenchPart part) {
        Assert.isNotNull((Object)action);
        Assert.isNotNull((Object)part);
        action.setText(this.getActionLabel());
        action.setDescription(this.getActionDescription());
        action.setImageDescriptor(this.getActionImage());
        PlatformUI.getWorkbench().getHelpSystem().setHelp(action, this.getHelpContextId());
        this.fPart = part;
    }

    final IStatus startMeeting(Collection<CollaborationUser> users, IProgressMonitor monitor) {
        Assert.isNotNull(users);
        Assert.isNotNull((Object)monitor);
        try {
            monitor.beginTask(CollaborationMessages.AbstractContributorAction_8, 500);
            Collection<Object> topics = null;
            CollaborationData context = null;
            ICollaborationContextProvider provider = this.getContextProvider();
            if (provider != null) {
                topics = provider.getTopics(users, (IProgressMonitor)new SubProgressMonitor(monitor, 100, 2));
                context = provider.getContext(users, (IProgressMonitor)new SubProgressMonitor(monitor, 100, 2));
            }
            if (context != CANCEL_CONTEXT) {
                MeetingCreationRequest request;
                if (topics == null) {
                    topics = Collections.emptySet();
                }
                int secondary = users.size() > 1 ? 512 : 0;
                int primary = this.fCapabilities;
                if (primary <= 0) {
                    primary = 1;
                }
                int capabilities = primary | secondary;
                ICollaborationService service = CollaborationCore.getCollaborationService();
                MeetingCreationResult result = service.createMeeting(request = (capabilities & 0x200) != 0 ? new MeetingCreationRequest(users, topics, UUID.generate().getUuidValue(), capabilities) : new MeetingCreationRequest(users, topics, null, capabilities), (IProgressMonitor)new SubProgressMonitor(monitor, 100, 2));
                IStatus status = result.getStatus();
                if (status.matches(4)) {
                    IStatus iStatus = status;
                    return iStatus;
                }
                CollaborationMeeting meeting = result.getMeeting();
                if (meeting != null) {
                    MultiStatus outcome;
                    ArrayList<IStatus> collection = new ArrayList<IStatus>(2);
                    collection.add(status);
                    if (context != null && !(status = meeting.send(context, (IProgressMonitor)new SubProgressMonitor(monitor, 100, 2))).isOK()) {
                        collection.add(status);
                    }
                    if (meeting.hasUnsentTopics() && !(status = meeting.changeTopics((IProgressMonitor)new SubProgressMonitor(monitor, 100, 2))).isOK()) {
                        collection.add(status);
                    }
                    if (!(outcome = new MultiStatus("com.ibm.team.collaboration.rcp.ui", 1, collection.toArray(new IStatus[collection.size()]), CollaborationMessages.AbstractContributorAction_10, null)).isOK()) {
                        MultiStatus multiStatus = outcome;
                        return multiStatus;
                    }
                }
            }
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        finally {
            monitor.done();
        }
    }
}

