/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.collaboration.internal.ui;

import com.ibm.team.collaboration.core.CollaborationCore;
import com.ibm.team.collaboration.core.service.ICollaborationService;
import com.ibm.team.collaboration.core.service.ICollaborationServiceContext;
import com.ibm.team.collaboration.core.session.ICollaborationPresenceListener;
import com.ibm.team.collaboration.core.session.ICollaborationSessionListener;
import com.ibm.team.collaboration.internal.ui.context.DefaultCollaborationServiceContext;
import com.ibm.team.collaboration.internal.ui.manager.CollaborationMeetingViewerManager;
import com.ibm.team.collaboration.internal.ui.preference.CollaborationAccountUIRegistry;
import com.ibm.team.collaboration.internal.ui.preference.CollaborationPreferenceUIRegistry;
import com.ibm.team.collaboration.internal.ui.viewer.CollaborationViewerUIRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public final class CollaborationUIPlugin
extends AbstractUIPlugin {
    private static CollaborationUIPlugin fgPlugin;
    private static ImageRegistry fgRegistry;
    public static final String PLUGIN_ID = "com.ibm.team.collaboration.rcp.ui";
    private ICollaborationServiceContext fPreviousContext = CollaborationCore.getCollaborationService().getServiceContext();

    public static Image getImage(String path) {
        Image image;
        if (fgRegistry == null) {
            fgRegistry = new ImageRegistry(PlatformUI.getWorkbench().getDisplay());
        }
        if ((image = fgRegistry.get(path)) == null) {
            ImageDescriptor descriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
            fgRegistry.put(path, descriptor);
            image = fgRegistry.get(path);
        }
        return image;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        ImageDescriptor descriptor;
        if (fgRegistry == null) {
            fgRegistry = new ImageRegistry(PlatformUI.getWorkbench().getDisplay());
        }
        if ((descriptor = fgRegistry.getDescriptor(path)) == null) {
            descriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
            fgRegistry.put(path, descriptor);
        }
        return descriptor;
    }

    public static CollaborationUIPlugin getInstance() {
        return fgPlugin;
    }

    public CollaborationUIPlugin() {
        fgPlugin = this;
    }

    public void log(IStatus status) {
        this.getLog().log(status);
    }

    public void log(String message) {
        this.log((IStatus)new Status(4, PLUGIN_ID, 10001, message, null));
    }

    public void log(Throwable throwable) {
        this.log((IStatus)new Status(4, PLUGIN_ID, 4, "Internal Error", throwable));
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        CollaborationMeetingViewerManager manager = CollaborationMeetingViewerManager.getInstance();
        ICollaborationService service = CollaborationCore.getCollaborationService();
        service.addSessionListener((ICollaborationSessionListener)manager);
        service.addPresenceListener((ICollaborationPresenceListener)manager);
        this.fPreviousContext = service.setServiceContext((ICollaborationServiceContext)new DefaultCollaborationServiceContext());
        CollaborationAccountUIRegistry.getInstance().start();
        CollaborationPreferenceUIRegistry.getInstance().start();
        CollaborationViewerUIRegistry.getInstance().start();
    }

    public void stop(BundleContext context) throws Exception {
        CollaborationMeetingViewerManager manager = CollaborationMeetingViewerManager.getInstance();
        ICollaborationService service = CollaborationCore.getCollaborationService();
        service.removePresenceListener((ICollaborationPresenceListener)manager);
        service.removeSessionListener((ICollaborationSessionListener)manager);
        this.fPreviousContext = service.setServiceContext(this.fPreviousContext);
        CollaborationAccountUIRegistry.getInstance().stop();
        CollaborationPreferenceUIRegistry.getInstance().stop();
        CollaborationViewerUIRegistry.getInstance().stop();
        super.stop(context);
        if (fgRegistry != null) {
            fgRegistry.dispose();
        }
        fgPlugin = null;
    }
}

