/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.collaboration.internal.chat.ui.viewer;

import com.ibm.team.collaboration.core.CollaborationCore;
import com.ibm.team.collaboration.core.meeting.CollaborationMeeting;
import com.ibm.team.collaboration.core.meeting.CollaborationMeetingEvent;
import com.ibm.team.collaboration.core.meeting.ICollaborationMeetingListener;
import com.ibm.team.collaboration.core.meeting.MeetingInvitationRequest;
import com.ibm.team.collaboration.core.service.ICollaborationService;
import com.ibm.team.collaboration.core.session.CollaborationUser;
import com.ibm.team.collaboration.internal.chat.ui.ChatMessages;
import com.ibm.team.collaboration.internal.chat.ui.CollaborationChatPlugin;
import com.ibm.team.collaboration.internal.chat.ui.action.InviteContributorsAction;
import com.ibm.team.collaboration.internal.chat.ui.action.RemoveTopicAction;
import com.ibm.team.collaboration.internal.chat.ui.action.ResumeChatAction;
import com.ibm.team.foundation.client.util.FoundationJob;
import com.ibm.team.foundation.common.URIReference;
import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.foundation.rcp.core.hyperlinks.Hyperlinks;
import com.ibm.team.foundation.rcp.ui.dnd.URIReferenceTransfer;
import com.ibm.team.foundation.rcp.ui.dnd.ViewerDragSupport;
import com.ibm.team.jface.JazzResources;
import com.ibm.team.jface.labelProviders.ElementRemovedNotifierImpl;
import com.ibm.team.jface.labelProviders.IElementRemovedNotifier;
import com.ibm.team.jface.labelProviders.StandardLabelProvider;
import com.ibm.team.jface.preview.IDomainAdapter;
import com.ibm.team.jface.tooltip.TooltipSupport;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.NotLoggedInException;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.util.TransferDropTargetListener;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.IViewerLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.internal.ObjectActionContributorManager;
import org.eclipse.ui.progress.DeferredTreeContentManager;
import org.eclipse.ui.progress.IDeferredWorkbenchAdapter;
import org.eclipse.ui.progress.IElementCollector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ChatMeetingAttributePart {
    final ChatMeetingAttributeContentProvider fContentProvider;
    final ChatMeetingAttributeLabelProvider fLabelProvider;
    final CollaborationMeeting fMeeting;
    final ICollaborationMeetingListener fMeetingListener = new ChatMeetingListener();
    private final ListenerList fParticipantListeners = new ListenerList(1);
    boolean fPartSealed = false;
    private final ListenerList fTopicListeners = new ListenerList(1);
    final TreeViewer fTreeViewer;

    ChatMeetingAttributePart(Composite parent, CollaborationMeeting meeting) {
        Assert.isNotNull((Object)parent);
        Assert.isNotNull((Object)meeting);
        this.fMeeting = meeting;
        this.fTreeViewer = new TreeViewer(parent, 770);
        this.fTreeViewer.setAutoExpandLevel(-1);
        this.fContentProvider = new ChatMeetingAttributeContentProvider();
        this.fTreeViewer.setContentProvider((IContentProvider)this.fContentProvider);
        this.fLabelProvider = new ChatMeetingAttributeLabelProvider();
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)this.fLabelProvider);
        MenuManager menu = new MenuManager();
        menu.setRemoveAllWhenShown(true);
        menu.addMenuListener(new IMenuListener(){

            private boolean containsTopics(IStructuredSelection selection, IProgressMonitor monitor) {
                Assert.isNotNull((Object)selection);
                Assert.isNotNull((Object)monitor);
                try {
                    Collection topics = ChatMeetingAttributePart.this.fMeeting.getTopics();
                    monitor.beginTask(ChatMessages.ChatMeetingAttributePart_21, topics.size() * 100);
                    Iterator iterator = selection.iterator();
                    while (iterator.hasNext()) {
                        URIReference reference = Hyperlinks.create(iterator.next(), (IProgressMonitor)new SubProgressMonitor(monitor, 100, 2));
                        if (reference != null && topics.contains(reference)) continue;
                        return false;
                    }
                    return true;
                }
                finally {
                    monitor.done();
                }
            }

            public void menuAboutToShow(IMenuManager manager) {
                Assert.isNotNull((Object)manager);
                IStructuredSelection selection = (IStructuredSelection)ChatMeetingAttributePart.this.fTreeViewer.getSelection();
                if (selection.size() == 1 && selection.getFirstElement() == ChatMeetingAttributePart.this.fContentProvider.getParticipants()) {
                    Action action = null;
                    if (ChatMeetingAttributePart.this.fPartSealed && !ChatMeetingAttributePart.this.fMeeting.getInvitees().isEmpty()) {
                        action = new ResumeChatAction(ChatMeetingAttributePart.this.fMeeting);
                    } else if (ChatMeetingAttributePart.this.fMeeting.isMultiMeeting()) {
                        action = new InviteContributorsAction(ChatMeetingAttributePart.this.fMeeting);
                    }
                    if (action != null) {
                        action.setEnabled(!CollaborationCore.getCollaborationService().getAccountManager().getIdentities().isEmpty());
                        manager.add((IAction)action);
                    }
                }
                if (!ChatMeetingAttributePart.this.fPartSealed && this.containsTopics(selection, (IProgressMonitor)new NullProgressMonitor())) {
                    manager.add((IAction)new RemoveTopicAction((StructuredViewer)ChatMeetingAttributePart.this.fTreeViewer, ChatMeetingAttributePart.this.fMeeting));
                }
                ObjectActionContributorManager.getManager().contributeObjectActions(null, manager, (ISelectionProvider)ChatMeetingAttributePart.this.fTreeViewer);
            }
        });
        this.fTreeViewer.getControl().setMenu(menu.createContextMenu(this.fTreeViewer.getControl()));
        this.fTreeViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                IStructuredSelection extended;
                Assert.isNotNull((Object)event);
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection && (extended = (IStructuredSelection)selection).size() > 0) {
                    FoundationJob job = new FoundationJob(ChatMessages.ChatMeetingAttributePart_15){

                        protected IStatus runProtected(IProgressMonitor monitor) {
                            Assert.isNotNull((Object)monitor);
                            monitor.beginTask(ChatMessages.ChatMeetingAttributePart_16, 200);
                            for (Object element : extended.toList()) {
                                if (monitor.isCanceled()) {
                                    return Status.CANCEL_STATUS;
                                }
                                URIReference reference = Hyperlinks.create(element, (IProgressMonitor)new SubProgressMonitor(monitor, 100, 2));
                                if (reference == null) continue;
                                Hyperlinks.open((URI)reference.getURI(), null, (IProgressMonitor)new SubProgressMonitor(monitor, 100, 2));
                            }
                            return Status.OK_STATUS;
                        }
                    };
                    job.setPriority(10);
                    job.setSystem(true);
                    job.schedule();
                }
            }
        });
        this.addDragSupport();
        this.addDropSupport();
        new ChatMeetingAttributeTooltipSupport(this.fTreeViewer.getControl());
        this.fTreeViewer.setInput((Object)this.fMeeting);
        this.fMeeting.addMeetingListener(this.fMeetingListener);
        this.fTreeViewer.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                Assert.isNotNull((Object)event);
                ChatMeetingAttributePart.this.fMeeting.removeMeetingListener(ChatMeetingAttributePart.this.fMeetingListener);
            }
        });
    }

    private void addDragSupport() {
        new ViewerDragSupport((Viewer)this.fTreeViewer, 5);
    }

    private void addDropSupport() {
        this.fTreeViewer.addDropSupport(20, new Transfer[]{URIReferenceTransfer.getInstance()}, (DropTargetListener)new TransferDropTargetListener(){

            public void dragEnter(DropTargetEvent event) {
                Assert.isNotNull((Object)event);
                if (ChatMeetingAttributePart.this.fPartSealed) {
                    event.detail = 0;
                } else if (event.detail == 16) {
                    event.detail = (event.operations & 4) != 0 ? 4 : 0;
                }
            }

            public void dragLeave(DropTargetEvent event) {
            }

            public void dragOperationChanged(DropTargetEvent event) {
            }

            public void dragOver(DropTargetEvent event) {
                Assert.isNotNull((Object)event);
                if (!ChatMeetingAttributePart.this.fPartSealed && (event.operations & 4) != 0) {
                    Widget item = event.item;
                    if (item != null) {
                        Object element = item.getData();
                        IDeferredWorkbenchAdapter participants = ChatMeetingAttributePart.this.fContentProvider.getParticipants();
                        IDeferredWorkbenchAdapter topics = ChatMeetingAttributePart.this.fContentProvider.getTopics();
                        event.detail = element != participants && element != topics ? 0 : (ChatMeetingAttributePart.this.fMeeting.isPeerMeeting() && element == participants ? 0 : 4);
                    } else {
                        event.detail = 0;
                    }
                } else {
                    event.detail = 0;
                }
            }

            public void drop(DropTargetEvent event) {
                URIReference[] references;
                Assert.isNotNull((Object)event);
                if (!URIReferenceTransfer.getInstance().isSupportedType(event.currentDataType)) {
                    return;
                }
                Widget item = event.item;
                if (item != null && event.data instanceof URIReference[] && (references = (URIReference[])event.data).length != 0) {
                    Object element = item.getData();
                    if (element == ChatMeetingAttributePart.this.fContentProvider.getParticipants() && ChatMeetingAttributePart.this.fMeeting.isMultiMeeting()) {
                        this.inviteUsers(references);
                    } else if (element == ChatMeetingAttributePart.this.fContentProvider.getTopics()) {
                        URIReference[] uRIReferenceArray = references;
                        int n = references.length;
                        int n2 = 0;
                        while (n2 < n) {
                            URIReference reference = uRIReferenceArray[n2];
                            ChatMeetingAttributePart.this.fMeeting.addTopic(reference);
                            ChatMeetingAttributePart.this.fireTopicAdded(reference);
                            ++n2;
                        }
                    }
                }
            }

            public void dropAccept(DropTargetEvent event) {
                Assert.isNotNull((Object)event);
                Widget item = event.item;
                if (item != null && !ChatMeetingAttributePart.this.fPartSealed) {
                    Object element = item.getData();
                    IDeferredWorkbenchAdapter participants = ChatMeetingAttributePart.this.fContentProvider.getParticipants();
                    IDeferredWorkbenchAdapter topics = ChatMeetingAttributePart.this.fContentProvider.getTopics();
                    if (element != participants && element != topics) {
                        event.detail = 0;
                    } else if (ChatMeetingAttributePart.this.fMeeting.isPeerMeeting() && element == participants) {
                        event.detail = 0;
                    }
                } else {
                    event.detail = 0;
                }
            }

            public Transfer getTransfer() {
                return URIReferenceTransfer.getInstance();
            }

            private void inviteUsers(final URIReference[] references) {
                Assert.isNotNull((Object)references);
                FoundationJob job = new FoundationJob(ChatMessages.ChatMeetingAttributePart_13){

                    protected IStatus runProtected(IProgressMonitor monitor) {
                        Assert.isNotNull((Object)monitor);
                        try {
                            monitor.beginTask(ChatMessages.ChatMeetingAttributePart_19, references.length * 100 + 100);
                            ICollaborationService service = CollaborationCore.getCollaborationService();
                            ArrayList<CollaborationUser> users = new ArrayList<CollaborationUser>(references.length);
                            URIReference[] uRIReferenceArray = references;
                            int n = references.length;
                            int n2 = 0;
                            while (n2 < n) {
                                URIReference reference = uRIReferenceArray[n2];
                                if (monitor.isCanceled()) {
                                    IStatus iStatus = Status.CANCEL_STATUS;
                                    return iStatus;
                                }
                                try {
                                    Object element = Hyperlinks.resolve((URI)reference.getURI(), null, (IProgressMonitor)new SubProgressMonitor(monitor, 100, 2));
                                    if (element instanceof IContributorHandle) {
                                        IContributorHandle handle = (IContributorHandle)element;
                                        users.add(service.getUser(handle));
                                    }
                                }
                                catch (CoreException exception) {
                                    CollaborationChatPlugin.getInstance().log(exception);
                                }
                                ++n2;
                            }
                            if (monitor.isCanceled()) {
                                IStatus iStatus = Status.CANCEL_STATUS;
                                return iStatus;
                            }
                            if (!users.isEmpty()) {
                                ChatMeetingAttributePart.this.fireParticipantsInvited(users);
                                IStatus iStatus = (this).ChatMeetingAttributePart.this.fMeeting.invite(new MeetingInvitationRequest(users, false), (IProgressMonitor)new SubProgressMonitor(monitor, 100, 2));
                                return iStatus;
                            }
                            IStatus iStatus = Status.OK_STATUS;
                            return iStatus;
                        }
                        finally {
                            monitor.done();
                        }
                    }
                };
                job.setPriority(10);
                job.schedule();
            }

            public boolean isEnabled(DropTargetEvent event) {
                Assert.isNotNull((Object)event);
                URIReferenceTransfer transfer = URIReferenceTransfer.getInstance();
                TransferData[] transferDataArray = event.dataTypes;
                int n = event.dataTypes.length;
                int n2 = 0;
                while (n2 < n) {
                    TransferData data = transferDataArray[n2];
                    if (transfer.isSupportedType(data)) {
                        return !ChatMeetingAttributePart.this.fPartSealed;
                    }
                    ++n2;
                }
                return false;
            }
        });
    }

    public void addParticipantListener(IChatMeetingParticipantListener listener) {
        Assert.isNotNull((Object)listener);
        this.fParticipantListeners.add((Object)listener);
    }

    public void addTopicListener(IChatMeetingTopicListener listener) {
        Assert.isNotNull((Object)listener);
        this.fTopicListeners.add((Object)listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireParticipantsInvited(final Collection<CollaborationUser> participants) {
        Assert.isNotNull(participants);
        ListenerList listenerList = this.fParticipantListeners;
        synchronized (listenerList) {
            Object[] listeners;
            Object[] objectArray = listeners = this.fParticipantListeners.getListeners();
            int n = listeners.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                final IChatMeetingParticipantListener listener = (IChatMeetingParticipantListener)object;
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void handleException(Throwable exception) {
                        CollaborationChatPlugin.getInstance().log(exception);
                    }

                    public void run() throws Exception {
                        listener.participantsInvited(participants);
                    }
                });
                ++n2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireTopicAdded(final URIReference topic) {
        Assert.isNotNull((Object)topic);
        ListenerList listenerList = this.fTopicListeners;
        synchronized (listenerList) {
            Object[] listeners;
            Object[] objectArray = listeners = this.fTopicListeners.getListeners();
            int n = listeners.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                final IChatMeetingTopicListener listener = (IChatMeetingTopicListener)object;
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void handleException(Throwable exception) {
                        CollaborationChatPlugin.getInstance().log(exception);
                    }

                    public void run() throws Exception {
                        listener.topicAdded(topic);
                    }
                });
                ++n2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireTopicRemoved(final URIReference topic) {
        Assert.isNotNull((Object)topic);
        ListenerList listenerList = this.fTopicListeners;
        synchronized (listenerList) {
            Object[] listeners;
            Object[] objectArray = listeners = this.fTopicListeners.getListeners();
            int n = listeners.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                final IChatMeetingTopicListener listener = (IChatMeetingTopicListener)object;
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void handleException(Throwable exception) {
                        CollaborationChatPlugin.getInstance().log(exception);
                    }

                    public void run() throws Exception {
                        listener.topicRemoved(topic);
                    }
                });
                ++n2;
            }
        }
    }

    public Control getControl() {
        return this.fTreeViewer.getControl();
    }

    public boolean isSealed() {
        return this.fPartSealed;
    }

    public void removeParticipantListener(IChatMeetingParticipantListener listener) {
        Assert.isNotNull((Object)listener);
        this.fParticipantListeners.remove((Object)listener);
    }

    public void removeTopicListener(IChatMeetingTopicListener listener) {
        Assert.isNotNull((Object)listener);
        this.fTopicListeners.remove((Object)listener);
    }

    public void sealPart() {
        this.fPartSealed = true;
    }

    private final class ChatMeetingAttributeContentProvider
    implements ITreeContentProvider {
        private DeferredTreeContentManager fManager = null;
        private final IDeferredWorkbenchAdapter fParticipants = new DefaultWorkbenchAdapter(){

            public void fetchDeferredChildren(Object element, IElementCollector collector, IProgressMonitor monitor) {
                try {
                    Object origin;
                    monitor.beginTask(ChatMessages.ChatMeetingAttributePart_3, 200);
                    Collection participants = ((ChatMeetingAttributeContentProvider)ChatMeetingAttributeContentProvider.this).ChatMeetingAttributePart.this.fMeeting.getParticipants();
                    ArrayList<IContributorHandle> handles = new ArrayList<IContributorHandle>(participants.size());
                    for (CollaborationUser user : participants) {
                        IContributorHandle handle = user.getContributor();
                        if (handle == null) continue;
                        handles.add(handle);
                    }
                    IContributorHandle handle = ((ChatMeetingAttributeContentProvider)ChatMeetingAttributeContentProvider.this).ChatMeetingAttributePart.this.fMeeting.getSession().getUser().getContributor();
                    if (handle != null && (origin = handle.getOrigin()) instanceof ITeamRepository) {
                        ITeamRepository repository = (ITeamRepository)origin;
                        try {
                            ArrayList<IItem> items = new ArrayList<IItem>(handles.size());
                            List result = repository.itemManager().fetchPartialItems(handles, 0, CollaborationUser.CONTRIBUTOR_PROPERTIES, (IProgressMonitor)new SubProgressMonitor(monitor, 150, 2));
                            for (IItem item : result) {
                                if (item == null) continue;
                                items.add(item);
                            }
                            collector.add(items.toArray(), (IProgressMonitor)new SubProgressMonitor(monitor, 50, 2));
                        }
                        catch (NotLoggedInException notLoggedInException) {
                        }
                        catch (TeamRepositoryException exception) {
                            CollaborationChatPlugin.getInstance().log(exception);
                        }
                    }
                }
                finally {
                    monitor.done();
                }
            }

            public ImageDescriptor getImageDescriptor(Object element) {
                return CollaborationChatPlugin.getImageDescriptor("$nl$/icons/full/obj16/users.gif");
            }

            public String getLabel(Object element) {
                return ChatMessages.ChatMeetingAttributePart_1;
            }
        };
        private final IDeferredWorkbenchAdapter fTopics = new DefaultWorkbenchAdapter(){

            public void fetchDeferredChildren(Object object, IElementCollector collector, IProgressMonitor monitor) {
                try {
                    Object origin;
                    IContributorHandle handle;
                    monitor.beginTask(ChatMessages.ChatMeetingAttributePart_7, 200);
                    Collection topics = ((ChatMeetingAttributeContentProvider)ChatMeetingAttributeContentProvider.this).ChatMeetingAttributePart.this.fMeeting.getTopics();
                    ArrayList<IItemHandle> handles = new ArrayList<IItemHandle>(topics.size());
                    HashSet<URIReference> others = new HashSet<URIReference>(topics.size());
                    for (URIReference topic : topics) {
                        try {
                            IItemHandle handle2 = Location.location((URI)topic.getURI()).getItemHandle();
                            if (handle2 != null) {
                                handles.add(handle2);
                                continue;
                            }
                            others.add(topic);
                        }
                        catch (TeamRepositoryException teamRepositoryException) {
                            others.add(topic);
                        }
                    }
                    if (!handles.isEmpty() && (handle = ((ChatMeetingAttributeContentProvider)ChatMeetingAttributeContentProvider.this).ChatMeetingAttributePart.this.fMeeting.getSession().getUser().getContributor()) != null && (origin = handle.getOrigin()) instanceof ITeamRepository) {
                        ITeamRepository repository = (ITeamRepository)origin;
                        try {
                            ArrayList<IItem> items = new ArrayList<IItem>(handles.size());
                            List result = repository.itemManager().fetchCompleteItems(handles, 0, (IProgressMonitor)new SubProgressMonitor(monitor, 150, 2));
                            for (IItem item : result) {
                                if (item == null) continue;
                                items.add(item);
                            }
                            collector.add(items.toArray(), (IProgressMonitor)new SubProgressMonitor(monitor, 50, 2));
                        }
                        catch (NotLoggedInException notLoggedInException) {
                        }
                        catch (TeamRepositoryException exception) {
                            CollaborationChatPlugin.getInstance().log(exception);
                        }
                    }
                    for (URIReference reference : topics) {
                        try {
                            Object item = Hyperlinks.resolve((URI)reference.getURI(), null, (IProgressMonitor)monitor);
                            if (item == null) continue;
                            collector.add(item, monitor);
                        }
                        catch (CoreException coreException) {}
                    }
                }
                finally {
                    monitor.done();
                }
            }

            public ImageDescriptor getImageDescriptor(Object element) {
                return CollaborationChatPlugin.getImageDescriptor("$nl$/icons/full/obj16/topics.gif");
            }

            public String getLabel(Object element) {
                return ChatMessages.ChatMeetingAttributePart_2;
            }
        };

        ChatMeetingAttributeContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getChildren(Object element) {
            return this.fManager.getChildren(element);
        }

        public Object[] getElements(Object input) {
            ArrayList<Object> result = new ArrayList<Object>(16);
            Object[] children = this.fManager.getChildren(input);
            if (children != null) {
                Object[] objectArray = children;
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    Object child = objectArray[n2];
                    result.add(child);
                    ++n2;
                }
            }
            result.add(this.fTopics);
            result.add(this.fParticipants);
            return result.toArray();
        }

        public Object getParent(Object element) {
            return null;
        }

        IDeferredWorkbenchAdapter getParticipants() {
            return this.fParticipants;
        }

        IDeferredWorkbenchAdapter getTopics() {
            return this.fTopics;
        }

        public boolean hasChildren(Object element) {
            return this.fManager.mayHaveChildren(element);
        }

        public void inputChanged(Viewer viewer, Object predecessor, final Object successor) {
            if (viewer instanceof AbstractTreeViewer && successor instanceof CollaborationMeeting) {
                this.fManager = new DeferredTreeContentManager(this, (AbstractTreeViewer)ChatMeetingAttributePart.this.fTreeViewer){

                    protected IDeferredWorkbenchAdapter getAdapter(Object element) {
                        IDeferredWorkbenchAdapter adapter = super.getAdapter(element);
                        if (adapter == null && element == successor) {
                            return new RootWorkbenchAdapter();
                        }
                        return adapter;
                    }
                };
            }
        }

        private abstract class DefaultWorkbenchAdapter
        implements IDeferredWorkbenchAdapter {
            DefaultWorkbenchAdapter() {
            }

            public Object[] getChildren(Object element) {
                return null;
            }

            public ImageDescriptor getImageDescriptor(Object element) {
                return null;
            }

            public Object getParent(Object element) {
                return null;
            }

            public ISchedulingRule getRule(Object element) {
                return null;
            }

            public boolean isContainer() {
                return true;
            }
        }

        private final class RootWorkbenchAdapter
        extends DefaultWorkbenchAdapter {
            RootWorkbenchAdapter() {
            }

            public void fetchDeferredChildren(Object element, IElementCollector collector, IProgressMonitor monitor) {
                URIReference reference = ((ChatMeetingAttributeContentProvider)ChatMeetingAttributeContentProvider.this).ChatMeetingAttributePart.this.fMeeting.getScope();
                if (reference == null) {
                    return;
                }
                try {
                    Object item = Hyperlinks.resolve((URI)reference.getURI(), null, (IProgressMonitor)monitor);
                    if (item != null) {
                        collector.add(item, monitor);
                    }
                }
                catch (CoreException coreException) {}
            }

            public String getLabel(Object element) {
                return ChatMessages.ChatMeetingAttributePart_0;
            }
        }
    }

    private static final class ChatMeetingAttributeLabelProvider
    extends LabelProvider
    implements IViewerLabelProvider {
        private final ResourceManager fResourceManager = new LocalResourceManager(JFaceResources.getResources());
        private final StandardLabelProvider fStandardLabelProvider = new StandardLabelProvider((IElementRemovedNotifier)new ElementRemovedNotifierImpl());

        ChatMeetingAttributeLabelProvider() {
            this.fStandardLabelProvider.addListener(new ILabelProviderListener(){

                public void labelProviderChanged(LabelProviderChangedEvent event) {
                    Assert.isNotNull((Object)event);
                    ChatMeetingAttributeLabelProvider.this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)ChatMeetingAttributeLabelProvider.this));
                }
            });
        }

        public void dispose() {
            this.fResourceManager.dispose();
            this.fStandardLabelProvider.dispose();
            super.dispose();
        }

        public Image getImage(Object element) {
            Image image = this.fStandardLabelProvider.getImage(element);
            if (image != null) {
                return image;
            }
            return JazzResources.getImageWithDefault((ResourceManager)this.fResourceManager, (ImageDescriptor)CollaborationChatPlugin.getImageDescriptor("$nl$/icons/full/obj16/topic.gif"));
        }

        public String getText(Object element) {
            String string = this.fStandardLabelProvider.getText(element);
            if (string != null && !"".equals(string)) {
                return string;
            }
            return ChatMessages.ChatMeetingAttributePart_9;
        }

        public void updateLabel(ViewerLabel label, Object element) {
            if (element instanceof IDeferredWorkbenchAdapter) {
                IDeferredWorkbenchAdapter adapter = (IDeferredWorkbenchAdapter)element;
                ImageDescriptor descriptor = adapter.getImageDescriptor(element);
                if (descriptor != null) {
                    label.setImage(descriptor.createImage());
                }
                label.setText(adapter.getLabel(element));
            } else {
                Image image;
                this.fStandardLabelProvider.updateLabel(label, element);
                String text = label.getText();
                if (text == null || "".equals(text)) {
                    label.setText(ChatMessages.ChatMeetingAttributePart_9);
                }
                if ((image = label.getImage()) == null) {
                    label.setImage(JazzResources.getImageWithDefault((ResourceManager)this.fResourceManager, (ImageDescriptor)CollaborationChatPlugin.getImageDescriptor("$nl$/icons/full/obj16/topic.gif")));
                }
            }
        }
    }

    private final class ChatMeetingAttributeTooltipSupport
    extends TooltipSupport {
        ChatMeetingAttributeTooltipSupport(Control control) {
            super(control, true, true);
        }

        protected String getMarkupInBackground(IDomainAdapter adapter, Object element, IDomainAdapter.Info info, IProgressMonitor monitor) {
            if (element == ChatMeetingAttributePart.this.fContentProvider.getParticipants()) {
                try {
                    Collection participants = ChatMeetingAttributePart.this.fMeeting.getParticipants();
                    monitor.beginTask(ChatMessages.ChatMeetingAttributePart_23, 100 * participants.size());
                    StringBuilder builder = new StringBuilder(256);
                    builder.append("<b>");
                    builder.append(participants.size() == 1 ? ChatMessages.ChatMeetingAttributePart_5_SINGULAR : MessageFormat.format(ChatMessages.ChatMeetingAttributePart_5_PLURAL, participants.size()));
                    builder.append("</b>");
                    if (ChatMeetingAttributePart.this.fMeeting.isMultiMeeting() && !ChatMeetingAttributePart.this.fPartSealed) {
                        builder.append("</br></br>");
                        builder.append(ChatMessages.ChatMeetingAttributePart_4);
                    }
                    builder.append("</br><ul>");
                    for (CollaborationUser user : participants) {
                        builder.append("<li>");
                        builder.append(XMLString.createFromPlainText((String)user.getUserName((IProgressMonitor)new SubProgressMonitor(monitor, 100, 2))).getXMLText());
                        builder.append("</li>");
                    }
                    builder.append("</ul>");
                    String string = builder.toString();
                    return string;
                }
                finally {
                    monitor.done();
                }
            }
            if (element == ChatMeetingAttributePart.this.fContentProvider.getTopics()) {
                String topics = MessageFormat.format(ChatMessages.ChatMeetingAttributePart_10, ChatMeetingAttributePart.this.fMeeting.getTopics().size());
                StringBuilder builder = new StringBuilder(256);
                builder.append("<b>");
                builder.append(topics);
                builder.append("</b>");
                if (!ChatMeetingAttributePart.this.fPartSealed) {
                    builder.append("</br></br>");
                    builder.append(ChatMessages.ChatMeetingAttributePart_6);
                }
                return builder.toString();
            }
            return super.getMarkupInBackground(adapter, element, info, monitor);
        }

        protected void openRequested(final Object element) {
            FoundationJob job = new FoundationJob(ChatMessages.ChatMeetingAttributePart_15){

                protected IStatus runProtected(IProgressMonitor monitor) {
                    Assert.isNotNull((Object)monitor);
                    try {
                        monitor.beginTask(ChatMessages.ChatMeetingAttributePart_16, 200);
                        URIReference reference = Hyperlinks.create((Object)element, (IProgressMonitor)new SubProgressMonitor(monitor, 100, 2));
                        if (monitor.isCanceled()) {
                            IStatus iStatus = Status.CANCEL_STATUS;
                            return iStatus;
                        }
                        if (reference != null) {
                            IStatus iStatus = Hyperlinks.open((URI)reference.getURI(), null, (IProgressMonitor)new SubProgressMonitor(monitor, 100, 2));
                            return iStatus;
                        }
                        IStatus iStatus = Status.OK_STATUS;
                        return iStatus;
                    }
                    finally {
                        monitor.done();
                    }
                }
            };
            job.setPriority(10);
            job.schedule();
        }

        protected boolean useDomainAdapter(Object element) {
            return false;
        }
    }

    private final class ChatMeetingListener
    implements ICollaborationMeetingListener {
        ChatMeetingListener() {
        }

        public void meetingNotification(CollaborationMeetingEvent event) {
            Assert.isNotNull((Object)event);
            switch (event.getType()) {
                case 0: 
                case 1: {
                    this.refreshElement(ChatMeetingAttributePart.this.fContentProvider.getParticipants());
                    break;
                }
                case 6: 
                case 7: {
                    this.refreshElement(ChatMeetingAttributePart.this.fContentProvider.getTopics());
                }
            }
        }

        private void refreshElement(final Object element) {
            Assert.isNotNull((Object)element);
            final Control control = ChatMeetingAttributePart.this.fTreeViewer.getControl();
            control.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (!control.isDisposed()) {
                        ((ChatMeetingListener)ChatMeetingListener.this).ChatMeetingAttributePart.this.fTreeViewer.refresh(element, false);
                    }
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface IChatMeetingParticipantListener {
        public void participantsInvited(Collection<CollaborationUser> var1);
    }

    public static interface IChatMeetingTopicListener {
        public void topicAdded(URIReference var1);

        public void topicRemoved(URIReference var1);
    }
}

