/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.collaboration.internal.chat.ui.action;

import com.ibm.team.collaboration.core.CollaborationCore;
import com.ibm.team.collaboration.core.meeting.CollaborationData;
import com.ibm.team.collaboration.core.meeting.CollaborationMeeting;
import com.ibm.team.collaboration.core.service.CollaborationServiceJob;
import com.ibm.team.collaboration.core.session.CollaborationUser;
import com.ibm.team.collaboration.internal.chat.ui.ChatMessages;
import com.ibm.team.collaboration.internal.ui.util.CollaborationExceptionHandler;
import com.ibm.team.collaboration.ui.CollaborationUI;
import com.ibm.team.collaboration.ui.context.ICollaborationContextProvider;
import com.ibm.team.foundation.common.URIReference;
import com.ibm.team.repository.common.IContributorHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public final class ResumeChatAction
extends Action {
    final CollaborationMeeting fMeeting;

    public ResumeChatAction(CollaborationMeeting meeting) {
        super(ChatMessages.ResumeChatAction_0);
        Assert.isNotNull((Object)meeting);
        this.fMeeting = meeting;
        this.setDescription(ChatMessages.ResumeChatAction_1);
        this.setToolTipText(ChatMessages.ResumeChatAction_2);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "com.ibm.team.collaboration.ui.resume_chat");
    }

    public void run() {
        IWorkbenchPart part;
        IWorkbenchPage page;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null && (part = page.getActivePart()) != null) {
            Collection participants = this.fMeeting.getParticipants();
            final ArrayList<IContributorHandle> handles = new ArrayList<IContributorHandle>(participants.size());
            for (CollaborationUser participant : participants) {
                IContributorHandle handle = participant.getContributor();
                if (handle == null) continue;
                handles.add(handle);
            }
            if (!handles.isEmpty()) {
                CollaborationCore.getCollaborationService().scheduleJob(new CollaborationServiceJob(){

                    public String getName() {
                        return ChatMessages.ResumeChatAction_3;
                    }

                    public boolean isSystem() {
                        return false;
                    }

                    public boolean isUser() {
                        return true;
                    }

                    public IStatus run(IProgressMonitor monitor) {
                        return CollaborationExceptionHandler.handleErrorStatus((IStatus)CollaborationUI.contactContributors((IWorkbenchPart)part, (Collection)handles, (ICollaborationContextProvider)new ICollaborationContextProvider(){

                            public CollaborationData getContext(Collection<CollaborationUser> users, IProgressMonitor progress) {
                                Assert.isNotNull(users);
                                return null;
                            }

                            public Collection<URIReference> getTopics(Collection<CollaborationUser> users, IProgressMonitor progress) {
                                Assert.isNotNull(users);
                                return Collections.emptyList();
                            }
                        }, (IProgressMonitor)monitor));
                    }
                });
            }
        }
    }
}

