/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.collaboration.internal.chat.ui.action;

import com.ibm.team.collaboration.core.meeting.CollaborationMeeting;
import com.ibm.team.collaboration.internal.chat.ui.ChatMessages;
import com.ibm.team.foundation.client.util.FoundationJob;
import com.ibm.team.foundation.common.URIReference;
import com.ibm.team.foundation.rcp.core.hyperlinks.Hyperlinks;
import com.ibm.team.repository.common.IItem;
import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.ui.PlatformUI;

public final class RemoveTopicAction
extends Action {
    final CollaborationMeeting fMeeting;
    private final StructuredViewer fViewer;

    public RemoveTopicAction(StructuredViewer viewer, CollaborationMeeting meeting) {
        super(ChatMessages.RemoveTopicAction_0);
        Assert.isNotNull((Object)meeting);
        Assert.isNotNull((Object)viewer);
        this.fMeeting = meeting;
        this.fViewer = viewer;
        this.setDescription(ChatMessages.RemoveTopicAction_2);
        this.setToolTipText(ChatMessages.RemoveTopicAction_3);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "com.ibm.team.collaboration.ui.remove_topic");
    }

    public void run() {
        IStructuredSelection selection = (IStructuredSelection)this.fViewer.getSelection();
        final ArrayList<IItem> items = new ArrayList<IItem>(selection.size());
        for (Object element : selection) {
            if (!(element instanceof IItem)) continue;
            items.add((IItem)element);
        }
        FoundationJob job = new FoundationJob(ChatMessages.RemoveTopicAction_1){

            protected IStatus runProtected(IProgressMonitor monitor) {
                Assert.isNotNull((Object)monitor);
                try {
                    monitor.beginTask(ChatMessages.RemoveTopicAction_4, items.size() * 100);
                    for (IItem item : items) {
                        if (monitor.isCanceled()) {
                            IStatus iStatus = Status.CANCEL_STATUS;
                            return iStatus;
                        }
                        URIReference reference = Hyperlinks.create((Object)item, (IProgressMonitor)new SubProgressMonitor(monitor, 100, 2));
                        if (reference == null) continue;
                        RemoveTopicAction.this.fMeeting.removeTopic(reference);
                    }
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                finally {
                    monitor.done();
                }
            }
        };
        job.setPriority(20);
        job.setSystem(true);
        job.schedule();
    }
}

