/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.setup.client.internal.builder;

import com.ibm.team.apt.common.IIterationPlanRecord;
import com.ibm.team.apt.internal.client.IIterationPlanClient;
import com.ibm.team.apt.internal.client.IterationPlanClient;
import com.ibm.team.apt.internal.client.wiki.IWikiPageSafeRunnable;
import com.ibm.team.apt.internal.common.wiki.IWikiPage;
import com.ibm.team.apt.setup.client.builder.IterationPlanBuilder;
import com.ibm.team.apt.setup.client.internal.builder.Messages;
import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.foundation.setup.client.repository.IPredefinedArtifact;
import com.ibm.team.foundation.setup.client.repository.ISetupContext;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.process.common.IIterationHandle;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.repository.client.IContentManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContent;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IterationPlanBuilderImpl
extends IterationPlanBuilder {
    protected static final String CONTENT_TYPE = "text/xml";
    protected static final String CONTENT_ENCODING = "utf-8";
    protected String fName = null;
    protected IIterationHandle fIteration = null;
    protected IProcessAreaHandle fProcessArea = null;
    protected XMLString fOverviewPageContent = null;
    protected Map<String, AttachedPageBuilder> fAttachedPages = null;
    private String fPlanType;

    public IterationPlanBuilderImpl(ISetupContext projectSetupContext) {
        super(projectSetupContext);
    }

    @Override
    public IterationPlanBuilder predefined(IPredefinedArtifact<IIterationPlanRecord> artifact) {
        this.setPredefined(artifact);
        this.name(artifact.getName());
        return this;
    }

    @Override
    public IterationPlanBuilder name(String name) {
        this.fName = this.decorateForTVT(name);
        return this;
    }

    @Override
    public IterationPlanBuilder iteration(IIterationHandle iteration) {
        this.fIteration = iteration;
        return this;
    }

    @Override
    public IterationPlanBuilder iteration(IPredefinedArtifact<IIteration> iteration) {
        return this.iteration((IIterationHandle)this.resolve(iteration));
    }

    @Override
    public IterationPlanBuilder processArea(IProcessAreaHandle processArea) {
        this.fProcessArea = processArea;
        return this;
    }

    @Override
    public IterationPlanBuilder processArea(IPredefinedArtifact<? extends IProcessArea> processArea) {
        return this.processArea((IProcessAreaHandle)this.resolve(processArea));
    }

    @Override
    public IterationPlanBuilder planType(String planType) {
        this.fPlanType = planType;
        return this;
    }

    @Override
    public IterationPlanBuilder overviewPage(XMLString content) {
        this.fOverviewPageContent = content;
        return this;
    }

    @Override
    public IterationPlanBuilder.IAttachedPageBuilder attachedPage(String wikiId) {
        AttachedPageBuilder result;
        if (this.fAttachedPages == null) {
            this.fAttachedPages = new HashMap<String, AttachedPageBuilder>();
        }
        if ((result = this.fAttachedPages.get(wikiId)) == null) {
            result = new AttachedPageBuilder(wikiId);
            this.fAttachedPages.put(wikiId, result);
        }
        return result;
    }

    public IIterationPlanRecord doBuild(IProgressMonitor monitor) throws TeamRepositoryException {
        monitor.beginTask(Messages.IterationPlanBuilderImpl_MONITOR_BUILD_PLAN, this.fAttachedPages != null ? this.fAttachedPages.size() + 1 : 2);
        try {
            IIterationPlanRecord result = (IIterationPlanRecord)IIterationPlanRecord.ITEM_TYPE.createItem();
            Assert.isNotNull((Object)this.fProcessArea);
            if (this.fName != null) {
                result.setName(this.fName);
            }
            result.setOwner(this.fProcessArea);
            result.setIteration(this.fIteration);
            if (this.fPlanType != null) {
                result.setPlanType(this.fPlanType);
            }
            this.doApplyExtensions((IItem)result, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            IterationPlanClient iterationPlanClient = (IterationPlanClient)this.getProjectSetupContext().getClientLibrary(IIterationPlanClient.class);
            result = iterationPlanClient.create(result, this.fOverviewPageContent, monitor).getPlanRecord();
            if (this.fAttachedPages != null) {
                for (AttachedPageBuilder attachedPageBuilder : this.fAttachedPages.values()) {
                    attachedPageBuilder.doBuild(result, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                }
            }
            IIterationPlanRecord iIterationPlanRecord = result;
            return iIterationPlanRecord;
        }
        finally {
            monitor.done();
        }
    }

    private class AttachedPageBuilder
    implements IterationPlanBuilder.IAttachedPageBuilder {
        private final String fWikiId;
        private String fName;
        private IContributorHandle fCreator;
        private String fContent;

        public AttachedPageBuilder(String wikiId) {
            this.fWikiId = wikiId;
        }

        public IterationPlanBuilder.IAttachedPageBuilder name(String name) {
            this.fName = IterationPlanBuilderImpl.this.decorateForTVT(name);
            return this;
        }

        public IterationPlanBuilder.IAttachedPageBuilder creator(IContributorHandle creator) {
            this.fCreator = creator;
            return this;
        }

        public IterationPlanBuilder.IAttachedPageBuilder content(String content) {
            this.fContent = content;
            return this;
        }

        public IterationPlanBuilder done() {
            return IterationPlanBuilderImpl.this;
        }

        public void doBuild(IIterationPlanRecord plan, final IProgressMonitor monitor) throws TeamRepositoryException {
            final ITeamRepository teamRepository = IterationPlanBuilderImpl.this.getProjectSetupContext().getTeamRepository();
            final IWikiPage wikiPage = (IWikiPage)IWikiPage.ITEM_TYPE.createItem();
            if (this.fName != null) {
                wikiPage.setName(this.fName);
            }
            wikiPage.setWikiID(this.fWikiId);
            wikiPage.setCreator((IContributorHandle)(this.fCreator != null ? this.fCreator : teamRepository.loggedInContributor()));
            wikiPage.setOwner((IItemHandle)plan);
            final String pageContent = this.fContent != null ? this.fContent : "";
            IWikiPageSafeRunnable runnable = new IWikiPageSafeRunnable(){

                public IWikiPage getWikiPage() {
                    return wikiPage;
                }

                public IWikiPage preSave() throws TeamRepositoryException {
                    IContentManager manager = teamRepository.contentManager();
                    IContent content = manager.storeContent("text/plain", pageContent, monitor);
                    wikiPage.setContent(content);
                    return wikiPage;
                }

                public void handleException(TeamRepositoryException e) {
                }

                public void postSave(IWikiPage page) {
                }
            };
            try {
                IterationPlanClient client = (IterationPlanClient)IterationPlanBuilderImpl.this.getProjectSetupContext().getClientLibrary(IIterationPlanClient.class);
                client.save(true, plan, null, new WorkItemWorkingCopy[0], null, new IWikiPageSafeRunnable[]{runnable}, monitor);
            }
            catch (IOException e) {
                throw new TeamRepositoryException((Throwable)e);
            }
        }
    }
}

