/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2005, 2009. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
dojo.provide("com.ibm.team.apt.internal.ui.structure.TagGroupProvider"); //$NON-NLS-1$

dojo.require("com.ibm.team.foundation.Assert"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.client.PlanItem"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.ui.structure.GenericElement"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.ui.structure.GroupProvider"); //$NON-NLS-1$

dojo.require("com.ibm.team.apt.ui.model.PrimaryLocationTag"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.ui.model.SecondaryLocationMarker"); //$NON-NLS-1$

dojo.require("dojo.string"); //$NON-NLS-1$
dojo.require("dojo.i18n"); //$NON-NLS-1$
dojo.requireLocalization("com.ibm.team.apt.internal.ui", "GroupProviderMessages"); //$NON-NLS-1$ //$NON-NLS-2$

(function() {

var Assert						= com.ibm.team.foundation.Assert;
var PlanItem					= com.ibm.team.apt.client.PlanItem;
var GenericElement				= com.ibm.team.apt.ui.structure.GenericElement;
var GroupProvider				= com.ibm.team.apt.ui.structure.GroupProvider;

var SecondaryLocationMarker		= com.ibm.team.apt.ui.model.SecondaryLocationMarker;
var PrimaryLocationTag 			= com.ibm.team.apt.ui.model.PrimaryLocationTag.INSTANCE;

var bind= dojo.string.substitute;
var Messages= dojo.i18n.getLocalization("com.ibm.team.apt.internal.ui", "GroupProviderMessages"); //$NON-NLS-1$ //$NON-NLS-2$

var NO_TAGS= Messages['tags_noTags']; //$NON-NLS-1$

dojo.declare("com.ibm.team.apt.internal.ui.structure.TagGroupProvider", GroupProvider, { //$NON-NLS-1$

	constructor: function(funcGetPlan, options) {
	},

	// ---- api ------------------------------------------------------------------------------------------------------------

	getGroupAttributes: function() {
		return [ PlanItem.PRIMARY_TAG ];
	},

	getDefaultGroupIds: function() {
		return [ [ NO_TAGS ] ];
	},

	getGroupsIds: function(elementInfo) {
		return [ [ elementInfo.getValue(PlanItem.PRIMARY_TAG) || NO_TAGS ] ];
	},

	isPrimaryGroup: function(groupIdPath, elementInfo) {
		Assert.isTrue(groupIdPath.length == 1);
		return groupIdPath[0] == (elementInfo.getValue(PlanItem.PRIMARY_TAG) || NO_TAGS);
	},

	getGroupElement: function(groupIdPath) {
		Assert.isTrue(groupIdPath.length == 1);

		var tag= groupIdPath[0];
		
		return new GenericElement(tag, tag, tag, {
			adopt : function(planItem) {
				planItem.setAttributeValue(PlanItem.PRIMARY_TAG, tag);
				return true;
			},
			comperator : function(o1, o2) {
				return o1.getValue().localeCompare(o2.getValue());
			}
		});
	},
	
	calculateLocationMarker: function(entry, elementInfo) {
		if (!entry.hasTag(PrimaryLocationTag) && elementInfo != null && elementInfo.getPlanElement() instanceof PlanItem) {
			return new SecondaryLocationMarker(bind(Messages['tags_outplace'], [ elementInfo.getValue(PlanItem.PRIMARY_TAG) ])); //$NON-NLS-1$
		}
		return null;
	},


	__sentinel: null // terminates this class definition
});

})();



