/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2005, 2009. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
dojo.provide("com.ibm.team.apt.internal.ui.structure.PlannedTimeGroupProvider"); //$NON-NLS-1$

dojo.require("com.ibm.team.foundation.Assert"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.client.PlanElement"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.client.PlanItem"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.client.OutOfOfficeItem"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.ui.Move"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.ui.Create"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.ui.structure.OwnerElement"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.ui.structure.TimeElement"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.ui.structure.GroupProvider"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.ui.structure.TimespanDefinition"); //$NON-NLS-1$

dojo.require("com.ibm.team.apt.ui.model.PrimaryLocationTag"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.ui.model.SecondaryLocationMarker"); //$NON-NLS-1$
dojo.require("com.ibm.team.repository.common.Contributor"); //$NON-NLS-1$

dojo.require("dojo.string"); //$NON-NLS-1$
dojo.require("dojo.i18n"); //$NON-NLS-1$
dojo.requireLocalization("com.ibm.team.apt.internal.ui", "GroupProviderMessages"); //$NON-NLS-1$ //$NON-NLS-2$

(function() {

var Assert						= com.ibm.team.foundation.Assert;
var Contributor					= com.ibm.team.repository.common.Contributor;
var PlanElement					= com.ibm.team.apt.client.PlanElement;
var PlanItem					= com.ibm.team.apt.client.PlanItem;
var OutOfOfficeItem				= com.ibm.team.apt.client.OutOfOfficeItem;
var OwnerElement				= com.ibm.team.apt.ui.structure.OwnerElement;
var TimeElement					= com.ibm.team.apt.ui.structure.TimeElement;
var GroupProvider				= com.ibm.team.apt.ui.structure.GroupProvider;
var Move						= com.ibm.team.apt.ui.Move;
var Create						= com.ibm.team.apt.ui.Create;

var TimespanDefinition			= com.ibm.team.apt.ui.structure.TimespanDefinition;

var SecondaryLocationMarker		= com.ibm.team.apt.ui.model.SecondaryLocationMarker;
var PrimaryLocationTag 			= com.ibm.team.apt.ui.model.PrimaryLocationTag.INSTANCE;

var bind= dojo.string.substitute;
var Messages= dojo.i18n.getLocalization("com.ibm.team.apt.internal.ui", "GroupProviderMessages"); //$NON-NLS-1$ //$NON-NLS-2$

var TimespanUnscheduled= TimespanDefinition.UNSCHEDULED;
var TimespanPast= new TimespanDefinition.Past();


dojo.declare("com.ibm.team.apt.internal.ui.structure.PlannedTimeGroupProvider", GroupProvider, { //$NON-NLS-1$

	__timespans: null,
	
	constructor: function(funcGetPlan, options) {
		this.__context= options.context;
		
		this.__timespans= [
			{ element: TimespanUnscheduled, priority: 3 },
			{ element: TimespanPast, priority: 1000 },
			{ element: new TimespanDefinition.LaterToday(), priority: 0 },
			{ element: new TimespanDefinition.LaterThisWeek(), priority: 1 },
			{ element: new TimespanDefinition.Future(), priority: 2 }
		];
	},

	// ---- api ------------------------------------------------------------------------------------------------------------

	onBeginRebuild: function() {
		this.inherited(arguments);
		var referenceTime= this._getPlan().getReferenceTime();
		dojo.forEach(this.__timespans, function(definitionEntry) {
			definitionEntry.element.refreshTimestamps(referenceTime);
		}, this);
	},

	getGroupAttributes: function() {
		return [ PlanItem.OWNER, PlanItem.SCHEDULED_TIME, PlanItem.RESOLVED, PlanItem.SEQUENCE_VALUE ];
	},

	getDefaultGroupIds: function() {
		var result= [];
		dojo.forEach(this._getPlan().findAttribute(PlanItem.OWNER).getValueSet().values, function(teamMember) {
			if (!teamMember.archived) {
				result.push([teamMember.itemId]);
			}
			var itemSequenceManager= this._getPlan().getItemSequenceManager(teamMember);
			if (itemSequenceManager != null) {
				var timeSpanId= this.__findSpecificTimeSpanId(itemSequenceManager.getWorkStart(), false);
				if (timeSpanId != null) {
					result.push([teamMember.itemId, timeSpanId]);
				}
			}
		}, this);
		return result;
	},

	isElementIncluded: function(elementInfo) {
		return elementInfo && elementInfo.getPlanElement() instanceof OutOfOfficeItem ? true : undefined;
	},

	getEntryComparator: function() {
		var defaultComparator= this.inherited(arguments);

		return function(e1, e2, forceResort, readAccessor) {
			var i1= e1.getElement();
			var i2= e2.getElement();
			if (i1 instanceof PlanElement && i2 instanceof PlanElement) {
				var t1= i1.getAttributeValue(PlanItem.SCHEDULED_TIME);
				var t2= i2.getAttributeValue(PlanItem.SCHEDULED_TIME);
		
				var result;
				if (t1 != null && t2 != null) {
					return t1.start.compareTo(t2.start);
				} else if ((t1 == null) ^ (t2 == null)) {
					return (t1 == null ? 1 : 0) - (t2 == null ? 1 : 0);
				}
			}
			return defaultComparator(e1, e2, forceResort, readAccessor);
		};
	},

	
	getGroupsIds: function(elementInfo) {
		var nullOwner= this._getPlan().findAttribute(PlanItem.OWNER).getValueSet().nullValue;

		var owner= elementInfo.getValue(PlanItem.OWNER);
		var path= [ owner.itemId ];

		if (!nullOwner.equals(owner)) {
			path.push(this.__findTimeSpanId(elementInfo));
		}
		return [ path ];
	},

	isPrimaryGroup: function(groupIdPath, elementInfo) {
		Assert.isTrue(groupIdPath.length >= 1);
		return groupIdPath[0] == elementInfo.getValue(PlanItem.OWNER).itemId;
	},

	getGroupElement: function(groupIdPath) {
		var owner= this._getPlan().getItem(groupIdPath[0]);
		
		if (groupIdPath.length == 1) {
			return new OwnerElement(owner, this._getPlan());
		} else {
			return new TimeElement(owner, this.__timespans[parseInt(groupIdPath[1])].element);
		}
	},
	
	calculateLocationMarker: function(entry, elementInfo) {
		if (!entry.hasTag(PrimaryLocationTag) && elementInfo != null && elementInfo.getPlanElement() instanceof PlanItem) {
			return new SecondaryLocationMarker(bind(Messages['plannedtime_outplace'], [ elementInfo.getValue(PlanItem.OWNER).label ])); //$NON-NLS-1$
		}
		return null;
	},
	
	getElementsToExpandInitially: function(readAccessor) {
		var rootEntry= readAccessor.getRootEntry();
		var nullOwner= this._getPlan().findAttribute(PlanItem.OWNER).getValueSet().nullValue;

		
		var result= [];
		if (rootEntry != null) {
			var ownerEntries= readAccessor.getChildren(rootEntry);
			
			dojo.forEach(ownerEntries, function(ownerEntry) {
				var ownerElement= ownerEntry.getElement();
				if (ownerElement.getId() != nullOwner.itemId) {
					result.push(ownerEntry);
					var priority= 1000;
					var timeEntry= null;
					dojo.forEach(readAccessor.getChildren(ownerEntry), function(childEntry) {
						var element= childEntry.getElement();
						if (element instanceof TimeElement) {
							for (var i= 0; i < this.__timespans.length; i++) {
								if (this.__timespans[i].element === element.getValue()) {
									if (this.__timespans[i].priority < priority) {
										timeEntry= childEntry;
										priority= this.__timespans[i].priority;
									}
								}
							}
						}
					}, this);
					
					if (priority != 1000) {
						result.push(timeEntry);
					}
				}
			}, this);
		}
		return result;
	},
	
	canMove: function(request, readAccessor) {
		if (this.__isPastGroup(request.targetEntry, readAccessor))
			return Move.DENY;

		return this.inherited(arguments);
	},

	canCreate: function(request, readAccessor) {
		if (this.__isPastGroup(request.targetEntry, readAccessor))
			return Create.Response.DENY;

		var n= readAccessor.getEntryNavigator(true);
		var ownerElement= n.parentEntryOfType(request.targetEntry, OwnerElement).getElement();

		var setAccepted= false;
		if (ownerElement.getId() == Contributor.getAuthenticatedContributorId()) {
			setAccepted= true;
			var timeSpanEntry= n.parentEntryOfType(request.targetEntry, TimeElement);
			if (timeSpanEntry != null) {
				if (timeSpanEntry.getElement().getValue() == TimespanUnscheduled) {
					return Create.Response.DENY;
				}
			}
		}
		
		
		var superResponse= this.inherited(arguments);
		
		return new Create.Response(request.targetEntry, {
			setAccepted: setAccepted,
			superResponse: superResponse
		});
	},

	create: function(response, updateAccessor) {
		response.info.superResponse.newItem= response.newItem;
		this.inherited("create", arguments, [response.info.superResponse, updateAccessor]); //$NON-NLS-1$

		if (response.info.setAccepted) {
			response.newItem.schedule(null, null);
		}
	},

	
	// ---- implementation -------------------------------------------------------------------------------------------------

	__isPastGroup: function(targetEntry, readAccessor) {
		var n= readAccessor.getEntryNavigator(true);
		
		var groupEntry= n.parentEntryOfType(targetEntry, TimeElement);
		return groupEntry != null && groupEntry.getElement().getValue() === TimespanPast;
	},
	
	__findTimeSpanId: function(elementInfo) {
		var isResolved= elementInfo.getValue(PlanItem.RESOLVED);
		var scheduledTime= elementInfo.getValue(PlanItem.SCHEDULED_TIME);
		var startTime= scheduledTime != null ? scheduledTime.start : null;
		
		var result= this.__findSpecificTimeSpanId(startTime, isResolved);
		if (result == null) {
			result= isResolved ? String(1) : String(2);
		}

		return result;
	},

	__findSpecificTimeSpanId: function(startTime, isResolved) {
		for (var i= 0; i < this.__timespans.length; i++) {
			if (this.__timespans[i].element.includes(startTime, isResolved)) {
				return String(i);
			}
		}
		return null;
	},
	
	__sentinel: null // terminates this class definition
});

})();



