/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2005, 2009. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
dojo.provide("com.ibm.team.apt.internal.ui.structure.OwnerGroupProvider"); //$NON-NLS-1$

dojo.require("com.ibm.team.foundation.Assert"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.client.PlanItem"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.ui.structure.OwnerElement"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.ui.structure.GroupProvider"); //$NON-NLS-1$

dojo.require("com.ibm.team.apt.ui.model.PrimaryLocationTag"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.ui.model.SecondaryLocationMarker"); //$NON-NLS-1$

dojo.require("dojo.string"); //$NON-NLS-1$
dojo.require("dojo.i18n"); //$NON-NLS-1$
dojo.requireLocalization("com.ibm.team.apt.internal.ui", "GroupProviderMessages"); //$NON-NLS-1$ //$NON-NLS-2$

(function() {

var Assert						= com.ibm.team.foundation.Assert;
var PlanItem					= com.ibm.team.apt.client.PlanItem;
var OwnerElement				= com.ibm.team.apt.ui.structure.OwnerElement;
var GroupProvider				= com.ibm.team.apt.ui.structure.GroupProvider;

var SecondaryLocationMarker		= com.ibm.team.apt.ui.model.SecondaryLocationMarker;
var PrimaryLocationTag 			= com.ibm.team.apt.ui.model.PrimaryLocationTag.INSTANCE;

var bind= dojo.string.substitute;
var Messages= dojo.i18n.getLocalization("com.ibm.team.apt.internal.ui", "GroupProviderMessages"); //$NON-NLS-1$ //$NON-NLS-2$

dojo.declare("com.ibm.team.apt.internal.ui.structure.OwnerGroupProvider", GroupProvider, { //$NON-NLS-1$

	constructor: function(funcGetPlan, options) {
	},

	// ---- api ------------------------------------------------------------------------------------------------------------

	getGroupAttributes: function() {
		return [ PlanItem.OWNER ];
	},

	getDefaultGroupIds: function() {
		var result= [];
		dojo.forEach(this._getPlan().findAttribute(PlanItem.OWNER).getValueSet().values, function(teamMember) {
			if (!teamMember.archived) {
				result.push([teamMember.itemId]);
			}
		});
		return result;
	},

	getGroupsIds: function(elementInfo) {
		return [ [ elementInfo.getValue(PlanItem.OWNER).itemId ] ];
	},

	isPrimaryGroup: function(groupIdPath, elementInfo) {
		Assert.isTrue(groupIdPath.length >= 1);
		return groupIdPath[0] == elementInfo.getValue(PlanItem.OWNER).itemId;
	},

	getGroupElement: function(groupIdPath) {
		Assert.isTrue(groupIdPath.length >= 1);
		var owner= this._getPlan().getItem(groupIdPath[0]);
		return new OwnerElement(owner, this._getPlan());
	},

	calculateLocationMarker: function(entry, elementInfo) {
		if (!entry.hasTag(PrimaryLocationTag) && elementInfo != null && elementInfo.getPlanElement() instanceof PlanItem) {
			return new SecondaryLocationMarker(bind(Messages['owner_outplace'], [ elementInfo.getValue(PlanItem.OWNER).label ])); //$NON-NLS-1$
		}
		return null;
	},

	__sentinel: null // terminates this class definition
});

})();



