/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2005, 2009. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
dojo.provide("com.ibm.team.apt.internal.ui.sortmode.PlannedTimeSorter"); //$NON-NLS-1$

dojo.require("com.ibm.team.apt.client.PlanElement"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.client.PlanItem"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.client.PlanningAttributeType"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.ui.Move"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.ui.Create"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.ui.model.EntrySorter"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.ui.structure.RowElement"); //$NON-NLS-1$

(function() {

var PlanElement						= com.ibm.team.apt.client.PlanElement;
var PlanItem						= com.ibm.team.apt.client.PlanItem;
var RowElement						= com.ibm.team.apt.ui.structure.RowElement;
var PlanningAttributeType			= com.ibm.team.apt.client.PlanningAttributeType;
var Move							= com.ibm.team.apt.ui.Move;
var Create							= com.ibm.team.apt.ui.Create;

dojo.declare("com.ibm.team.apt.internal.ui.sortmode.PlannedTimeSorter", com.ibm.team.apt.ui.model.EntrySorter, { //$NON-NLS-1$

	constructor: function(options) {
	},

	// ---- api ------------------------------------------------------------------------------------------------------------

	isSorterProperty: function(property) {
		return PlanItem.SCHEDULED_TIME.getId() === property;
	},

	canMove: function(request, readAccessor) {
		var superResponse= this.inherited(arguments);

		var sourceElement= request.sourceElement;
		var targetElement= request.targetEntry.getElement();

		if (sourceElement instanceof PlanItem && (request.location == Move.After || request.location == Move.Before)) {
			var n= readAccessor.getEntryNavigator(false);
			
			if (sourceElement.isResolved())
				return Move.Response.DENY;
			
			var isSourcePlanned= sourceElement.getAttributeValue(PlanItem.SCHEDULED_TIME) != null;
			if (targetElement instanceof PlanItem) {
				var isTargetPlanned= targetElement.getAttributeValue(PlanItem.SCHEDULED_TIME) != null;
				if (isSourcePlanned && !isTargetPlanned) {
					return Move.Response.DENY;
				} else if (isTargetPlanned) {
					return new Move.Response(request.targetEntry, request.location, {
						toPlan: sourceElement, 
						predecessor: request.location == Move.After ? targetElement : null,
						successor: request.location == Move.Before ? targetElement : null
					});
				} else if (!isSourcePlanned && !isTargetPlanned) {
					return new Move.Response(request.targetEntry, request.location, {
						superResponse: superResponse
					});
				}
			}
		}
		
		return null;
	},

	move: function(response, updateAccessor) {
		if (response.info.toPlan != null) {
			response.info.toPlan.schedule(response.info.predecessor, response.info.successor);
		}

		if (response.info.superResponse != null) {
			this.inherited("move", arguments, [response.info.superResponse, updateAccessor]); //$NON-NLS-1$
		}
	},

	canCreate: function(request, readAccessor) {
		var targetElement= request.targetEntry.getElement();
		if (targetElement instanceof PlanItem && (request.location == Create.After || request.location == Create.Before)) {

			var isTargetPlanned= targetElement.getAttributeValue(PlanItem.SCHEDULED_TIME) != null;
			if (isTargetPlanned) {
				return new Create.Response(request.targetEntry, {
					doSchedule: true,
					predecessor: request.location == Create.After ? targetElement : null,
					successor: request.location == Create.Before ? targetElement : null
				});
			}
		}

		var superResponse= this.inherited(arguments);
		if (superResponse != null) {
			return new Create.Response(request.targetEntry, request.location, {
				superResponse: superResponse
			});
		}

		return null;
	},

	create: function(response, updateAccessor) {		
		if (response.info.doSchedule) {
			response.newItem.schedule(response.info.predecessor, response.info.successor);
		}

		if (response.info.superResponse != null) {
			this.inherited("create", arguments, [response.info.superResponse, updateAccessor]); //$NON-NLS-1$
		}
	},

	// ---- implementation -------------------------------------------------------------------------------------------------

	_compare: function(e1, e2, forceResort, readAccessor) {
		var i1= e1.getElement();
		var i2= e2.getElement();
		
		if (i1 instanceof RowElement) {
			i1= i1.getParent();
		}
		if (i2 instanceof RowElement) {
			i2= i2.getParent();
		}
		
		if (forceResort && i1 instanceof PlanElement && i2 instanceof PlanElement) {
			var v1= i1.getAttributeValue(PlanItem.SCHEDULED_TIME);
			var v2= i2.getAttributeValue(PlanItem.SCHEDULED_TIME);

			var result= 0;
			if (v1 === undefined || v2 === undefined) {
				result= (v1 === undefined ? 1 : 0) - (v2 === undefined ? 1 : 0);
			} else {
				result= PlanningAttributeType.TIMESPAN.compareValues(v1, v2);
			}

			if (result == 0 && i1 instanceof PlanItem && i2 instanceof PlanItem) {
				result= i2.getId() - i1.getId();
			}
			
			return result;
		} else {
			return this.inherited(arguments);
		}
	},
	
	__sentinel: null // terminates this class definition
});

})();
