/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2005, 2009. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
dojo.provide("com.ibm.team.apt.internal.ui.progress.StoryPointProgressComputer"); //$NON-NLS-1$

dojo.require("com.ibm.team.apt.internal.ui.progress.ProgressInformation"); //$NON-NLS-1$

(function() {

var ProgressInformation				= com.ibm.team.apt.internal.ui.progress.ProgressInformation;

dojo.declare("com.ibm.team.apt.internal.ui.progress.StoryPointProgressComputer", null, { //$NON-NLS-1$
	
	__itemAccessor: null,
	__progressInformation: null,
	
	constructor: function(itemAccessor, progressInformation) {
		this.__itemAccessor= itemAccessor;
		this.__progressInformation= progressInformation;
	},

	// ---- api ------------------------------------------------------------------------------------------------------------
	
	compute: function(element) {
		this.__visit(element);
		var children= this.__itemAccessor.getChildren(element);
		dojo.forEach(children, dojo.hitch(this, function(child){
			this.compute(child);
		}));
	},
	
	__visit: function(item) {
		if(!this.__itemAccessor.isPlanItem(item))
			return;
		
		if(this.__itemAccessor.isAuxiliaryPlanItem(item))
			return;
		
		if (!this.__itemAccessor.isPrimaryElement(item))
			return;
		
		var isTopLevelItem= this.__itemAccessor.isTopLevelPlanItem(item);
		var storyPts= this.__itemAccessor.getComplexity(item);
		
		if (this.__itemAccessor.isResolved(item)) {
			this.__progressInformation.deltaCloseCount(1);
			if(isTopLevelItem){
				this.__progressInformation.deltaStepsDone(storyPts);
			}
		} else {
			this.__progressInformation.deltaEstimateCount(1);
			this.__progressInformation.deltaOpenCount(1);
			if(isTopLevelItem){
				this.__progressInformation.deltaStepsLeft(storyPts);
			}
		}
	},
	
	__sentinel: null // terminates this class definition
});

})();
