/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2005, 2009. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
dojo.provide("com.ibm.team.apt.internal.ui.progress.ProgressLabelProvider"); //$NON-NLS-1$

dojo.require("dojo.number"); //$NON-NLS-1$
dojo.require("dojo.string"); //$NON-NLS-1$
dojo.require("dojo.i18n"); //$NON-NLS-1$
dojo.requireLocalization("com.ibm.team.apt.internal.ui", "ProgressMessages"); //$NON-NLS-1$ //$NON-NLS-2$

(function() {

var bind= dojo.string.substitute;
var Messages= dojo.i18n.getLocalization("com.ibm.team.apt.internal.ui", "ProgressMessages"); //$NON-NLS-1$ //$NON-NLS-2$

dojo.declare("com.ibm.team.apt.internal.ui.progress.ProgressLabelProvider", null, { //$NON-NLS-1$
	
	_showLabels: true,
	
	// ---- implementation -------------------------------------------------------------------------------------------------
	
	constructor: function(options){
		if(options && options.parameters){
			var param= options.parameters;
			this._showLabels= param.showLabels == undefined || String(param.showLabels) === "true"; //$NON-NLS-1$
		}
	},
	
	getFillLevel: function(element){
		return element ? element.getQualityOfPlanning() : 0;
	},
	
	getDoneRange: function(element){
		if(!element){
			return [0, 0];
		} else {
			var stepsProgress=element.getStepsProgress();
			return [0, stepsProgress < 1 ? stepsProgress - this.__aheadRange(element) : stepsProgress];
		}
	},
	
	getProjectionRange: function(element){
		if(element && element.isRealTimeSpecified()){
			var ratio= element.getStepsProgress() - element.getRealTimeProgress();
			if(ratio > 0 /*ahead*/){
				return [element.getStepsProgress() - this.__aheadRange(element), ratio];
			} else {
				return [element.getStepsProgress(), -ratio];
			}
		} else {
			return [-1, -1];
		}
	},
	
	__aheadRange: function(element){
		if(element && element.isRealTimeSpecified()){
			var ratio= element.getStepsProgress() - element.getRealTimeProgress();
			return Math.max(0, ratio);
		}
		return 0;
	},
	
	getDeltaDirection: function(element){
		return element && element.isRealTimeSpecified() ? (element.getStepsProgress() - element.getRealTimeProgress()): 0;
	},
	
	getMessage: function(element){
		if(!element){
			return Messages['progress_computing']; // XXX don't abuse null //$NON-NLS-1$
		} else if (element.getCount() == 0) {
			return Messages['progress_noWork']; //$NON-NLS-1$
		} else if (element.getEstimatedCount() == 0 && element.getOpenCount() > 0) {
			return Messages['progress_noWorkEstimated']; //$NON-NLS-1$
		}
		return null;
	},
	
	getProgressText: function(element){
		var result= ""; //$NON-NLS-1$
		if(element && element.getCount() != 0){
			var direction= this.getDeltaDirection(element);
			result+= this._toHours(element.getStepsDone());
			result+= "/"; //$NON-NLS-1$
			result+= this._toHours(element.getSteps());
			if(element.isRealTimeSpecified()){
				result+= " | "; //$NON-NLS-1$
				result+= "<span class=\"" + (direction > 0 ? "ahead" :  direction < 0 ? "behind" : "none") + "\">"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$
				if(direction > 0)
					result+= "+"; //$NON-NLS-1$
				result+= this._toHours(element.getStepsDoneDelta());
				result+= "</span>"; //$NON-NLS-1$
			}
			result+= Messages['progress_ProgressHours']; //$NON-NLS-1$
		} else {
			result+= Messages['progress_ProgressNone']; //$NON-NLS-1$
		}
	
		if(this._showLabels) {
			result= bind(Messages['progress_ProgressLabel'], [ result ]); //$NON-NLS-1$
		}

		return result;
	},
	
    getOpenCloseText: function(element){
		var result;
        if(element && !element.isAllWorkDone()){
        	result= bind(Messages['progress_ClosedPercentage'], [ Math.round(element.getClosedRatio() * 100) ]); //$NON-NLS-1$
        } else {
        	result= Messages['progress_ClosedDone']; //$NON-NLS-1$
        }

		if(this._showLabels) {
			result= bind(Messages['progress_ClosedLabel'], [ result ]); //$NON-NLS-1$
		}

        return result;
    },
    
	getQualityText: function(element){
		var result;
		if (element && element.getCount() != 0 && !element.isAllWorkDone()) {
        	result= bind(Messages['progress_EstimatedPercentage'], [ Math.round(element.getQualityOfPlanning() * 100) ]); //$NON-NLS-1$
		} else {
        	result= Messages['progress_EstimatedNone']; //$NON-NLS-1$
		}

		if(this._showLabels) {
			result= bind(Messages['progress_EstimatedLabel'], [ result ]); //$NON-NLS-1$
		}

		return result;
	},
	
	getTooltipText: function(element) {
		var lines= [];
		lines.push("<span class=\"header\">" + Messages['progress_tooltipTitle'] + "</span>"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
		lines.push(bind(Messages['progress_tooltipWorkHoursDone'], [ this._toHours(element.getStepsDone()), this._toHours(element.getSteps()) ])); //$NON-NLS-1$
		
		if (element.isRealTimeSpecified() && !element.isAllWorkDone()) {
			var dir= this.getDeltaDirection(element);
			var deltaMessage= dir > 0 ? 'progress_tooltipAhead' : (dir < 0 ? 'progress_tooltipBehind' : 'progress_tooltipOnTime' ); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
			var delta= bind(Messages[deltaMessage], [ this._absString(this._toHours(element.getStepsDoneDelta())) ]);

			lines.push(bind(Messages['progress_tooltipExpectedWorkHoursDone'], [ this._toHours(element.getStepsDoneExpected()), delta ])); //$NON-NLS-1$
		}
		if (!element.isAllWorkDone()) {
			lines.push(""); //$NON-NLS-1$
			lines.push(bind(Messages['progress_tooltipItemsEstimatedLabel'], [ bind(Messages['progress_tooltipItemsEstimatedPercentage'], [ Math.round(element.getQualityOfPlanning() * 100) ]) ])); //$NON-NLS-1$ //$NON-NLS-2$
			lines.push(bind(Messages['progress_tooltipItemsCompletedLabel'], [ bind(Messages['progress_tooltipItemsCompleted'], [ element.getCloseCount(), element.getCount(), Math.round(element.getClosedRatio() * 100) ]) ])); //$NON-NLS-1$ //$NON-NLS-2$
		} else {
			lines.push(bind(Messages['progress_tooltipItemsCompletedLabel'], [ Messages['progress_tooltipItemsCompletedAll'] ] )); //$NON-NLS-1$ //$NON-NLS-2$
		}

		return lines.join("<br />"); //$NON-NLS-1$
	},
	
	// ----- implementation ------------------------------------------------------------------------------------------------
	
	_toHours: function(value, n){
		n= n || 2; 
		var fac= Math.pow(10, n);
		var neg= value < 0;
		value= Math.abs(value); //negative numbers are rounded in the same way positive are
		var result= Math.round((value / (1000 * 60 * 60)) * fac) / fac;
		var fraction= result - Math.floor(result);
		result-= fraction;
		if(fraction <= 0.125){
			fraction= 0;
		} else if(fraction > 0.125 && fraction <= 0.25){
			fraction= 0.25;
		} else if(fraction > 0.25 && fraction <= 0.5){
			fraction= 0.5;
		} else if(fraction > 0.5 && fraction <= 0.75){
			fraction= 0.75;
		} else if(fraction > 0.75){
			fraction= 1;
		}
		return dojo.number.format((result + fraction) * (neg ? -1 : 1));
	},
	
	_absString: function(value){
		if(typeof value === "string"){ //$NON-NLS-1$
			if(value.charAt(0) === "-") //$NON-NLS-1$
				value= value.substring(1);
		}
		return value;
	},
	
	_hasWork: function(element) {
		return element.getCount() > 0;
	},

	_hasEstimatedWork: function(element) {
		return this._hasWork(element) && element.getEstimatedCount() > 0;
	},
	
	__sentinel: null // terminates this class definition
});

})();
