/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2005, 2009. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
dojo.provide("com.ibm.team.apt.internal.ui.progress.ProgressInformation"); //$NON-NLS-1$

(function() {

dojo.declare("com.ibm.team.apt.internal.ui.progress.ProgressInformation", null, { //$NON-NLS-1$
	
	__stepsDone: 0,
	__stepsLeft: 0,
	__realTimeDone: null,
	__realTimeLeft: null,
	__openCount: 0,
	__closeCount: 0,
	__estimatedCount: 0,
	
	constructor: function(realTimeDone, realTimeLeft) {
		this.__realTimeDone= realTimeDone || -1;
		this.__realTimeLeft= realTimeLeft || -1;
	},

	// ---- update api -----------------------------------------------------------------------------------------------------
	
	deltaStepsDone: function(delta) {
		this.__stepsDone= this.__safeDelta(this.__stepsDone, delta);
	},
	
	deltaStepsLeft: function(delta) {
		this.__stepsLeft= this.__safeDelta(this.__stepsLeft, delta);
	},
	
	deltaRealTimeDone: function(delta) {
		if(this.__realTimeDone != delta){
			this.__realTimeDone= this.__safeDelta(Math.max(0, this.__realTimeDone)/*default is -1*/, delta);
		}
	},
	
	deltaRealTimeLeft: function(delta) {
		if(this.__realTimeLeft != delta){
			this.__realTimeLeft= this.__safeDelta(Math.max(0, this.__realTimeLeft)/*default is -1*/, delta);
		}		
	},
	
	deltaOpenCount: function(delta) {
		this.__openCount= this.__safeDelta(this.__openCount, delta);
	},
	
	deltaCloseCount: function(delta) {
		this.__closeCount= this.__safeDelta(this.__closeCount, delta);
	},
	
	deltaEstimateCount: function(delta) {
		this.__estimatedCount= this.__safeDelta(this.__estimatedCount, delta);
	},
	
	__safeDelta: function(value, delta) {
		return Math.max(0, value + delta);
	},
	
	// ---- query api ------------------------------------------------------------------------------------------------------

	isAllWorkDone: function() {
		return this.__closeCount > 0 && this.__openCount == 0;
	},

	isRealTimeSpecified: function() {
		return this.__realTimeDone != -1 || this.__realTimeLeft != -1;
	},
	
	getStepsDone: function() {
		return this.__stepsDone;
	},

	getStepsLeft: function() {
		return this.__stepsLeft;
	},
	
	getSteps: function() {
		return this.__stepsDone + this.__stepsLeft;
	},

	getRealTimeDone: function() {
		return this.__realTimeDone;
	},

	getRealTimeLeft: function() {
		return this.__realTimeLeft;
	},

	getRealTime: function() {
		return this.__realTimeDone + this.__realTimeLeft;
	},

	getOpenCount: function() {
		return this.__openCount;
	},	

	getCloseCount: function() {
		return this.__closeCount;
	},

	getCount: function() {
		return this.__openCount + this.__closeCount;
	},
	
	getEstimatedCount: function() {
		return this.__estimatedCount;
	},

	getStepsDoneExpected: function() {
		return (this.__stepsDone + this.__stepsLeft) * this.getRealTimeProgress();
	},
	
	getStepsDoneDelta: function() {
		return this.__stepsDone - ((this.__stepsDone + this.__stepsLeft) * this.getRealTimeProgress());
	},

	getStepsProgress: function() {
		var divisor= this.__stepsDone + this.__stepsLeft;
		return divisor <= 0 ? 1 /* all unestimated */ : this.__stepsDone / divisor;
	},

	getRealTimeProgress: function() {
		var divisor= this.__realTimeDone + this.__realTimeLeft;
		return divisor <= 0 ? 0 : this.__realTimeDone / divisor;
	},

	getClosedRatio: function() {
		if (this.getCount() == 0) {
			return 1;
		}
		return this.__closeCount / this.getCount();
	},

	getQualityOfPlanning: function() {
		if (this.__openCount == 0) {
			return this.__closeCount == 0 ? 0 : 1;
		}
		return this.__estimatedCount / this.__openCount;
	},
	
	// ---- implementation -------------------------------------------------------------------------------------------------

	__sentinel: null // terminates this class definition
});

})();
