/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2005, 2009. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
dojo.provide("com.ibm.team.apt.internal.ui.progress.ProgressComputer"); //$NON-NLS-1$

dojo.require("com.ibm.team.apt.internal.ui.progress.ProgressInformation"); //$NON-NLS-1$

(function() {

var ProgressInformation				= com.ibm.team.apt.internal.ui.progress.ProgressInformation;

dojo.declare("com.ibm.team.apt.internal.ui.progress.ProgressComputer", null, { //$NON-NLS-1$
	
	__itemAccessor: null,
	__progressInformation: null,
	
	constructor: function(itemAccessor, progressInformation) {
		this.__itemAccessor= itemAccessor;
		this.__progressInformation= progressInformation;
	},

	// ---- api ------------------------------------------------------------------------------------------------------------
	
	//
	// NOTE: this implementation must be in-sync with com.ibm.team.apt.internal.service.progress.EstimateProgressComputer
	//
	
	compute: function(element) {
		this.__visit(element);
		var children= this.__itemAccessor.getChildren(element);
		dojo.forEach(children, dojo.hitch(this, function(child){
			this.compute(child);
		}));
	},
	
	__visit: function(item) {
		if(!this.__itemAccessor.isPlanItem(item))
			return;
		
		if(this.__itemAccessor.isAuxiliaryPlanItem(item))
			return;
		
		if (!this.__itemAccessor.isPrimaryElement(item))
			return;
		
		var duration= this.__itemAccessor.getDuration(item);
		if (this.__itemAccessor.isResolved(item)) {
			this.__progressInformation.deltaCloseCount(1);
			if(!this.__itemAccessor.isTopLevelPlanItem(item))
				this.__progressInformation.deltaStepsDone(duration.getMilliseconds());
		} else {
			this.__progressInformation.deltaOpenCount(1);
			this.__progressInformation.deltaStepsLeft(duration.getMilliseconds());
			if(duration.specified || this.__itemAccessor.isTopLevelPlanItem(item))
				this.__progressInformation.deltaEstimateCount(1);
			if(!this.__itemAccessor.isTopLevelPlanItem(item))
				this.__progressInformation.deltaStepsDone(duration.getTimeSpent().getMilliseconds());
		}
	},
	
	__sentinel: null // terminates this class definition
});

})();
