/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2005, 2009. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
dojo.provide("com.ibm.team.apt.client.plancheck.PlanCheck"); //$NON-NLS-1$

dojo.require("com.ibm.team.apt.client.PlanItem"); //$NON-NLS-1$

(function() {

var PlanElement						= com.ibm.team.apt.client.PlanElement;
var PlanItem						= com.ibm.team.apt.client.PlanItem;
	
var RUN_CONTINUE= "__continue"; //$NON-NLS-1$
var RUN_DONE= "__done"; //$NON-NLS-1$

dojo.declare("com.ibm.team.apt.client.plancheck.PlanCheck", null, { //$NON-NLS-1$

	__checkDescription: null,
	__problemIds: null,
	
	_plan: null,
	
	constructor: function(checkDescription, plan) {
		this.__checkDescription= checkDescription;
		this._plan= plan;

		this.__problemIds= [];
		for (var problemId in checkDescription.problemDefinitions) {
			this.__problemIds.push(problemId);
		}
	},

	// ---- api ------------------------------------------------------------------------------------------------------------

	getId: function() {
		return this.__checkDescription.id;
	},
	
	getCheckDescription: function() {
		return this.__checkDescription;
	},

	getName: function() {
		return this.__checkDescription.name;
	},
	
	getProblemIds: function() {
		return this.__problemIds;
	},
	
	getProblemDefinition: function(problemId) {
		return this.__checkDescription.problemDefinitions[problemId];
	},

	initialize: function(plan) {
	},

	getFullCheckElements: function() {
		var result= [];
		this._plan.accept(function(planElement) {
			if (this._includeElement(planElement)) { 
				result.push(planElement);
			}
			return true;
		}, this);
		return result;
	},

	getDeltaCheckElements: function(rootDelta) {
		var result= [];
		rootDelta.accept(function(delta) {
			var planElement= delta.getPlanElement();
			if (this._includeDelta(delta)) { 
				result.push(planElement);
			}
			return true;
		}, this);
		return result;
	},

	getCheckElements: function(planElements) {
		return dojo.filter(planElements, this._includeElement, this);
	},

	checkElement: function(planElement, progressMonitor) {
		return null;
	},

	// ---- spi ------------------------------------------------------------------------------------------------------------
	
	_includeDelta: function(delta) {
		if (!this._includeElement(delta.getPlanElement()))
			return false;
		
		if (delta.isChanged() && dojo.some(delta.getAttributeDeltas(), this._includeAttributeDelta, this))
			return true;
		
		return false;
	},

	_includeAttributeDelta: function(attributeDelta) {
		return !PlanElement.PLANCHECK_REPORT.equals(attributeDelta.getAttribute());
	},

	_includeElement: function(planElement) {
		return planElement instanceof PlanItem;
	},

	// ---- implementation -------------------------------------------------------------------------------------------------

	__sentinel: null // terminates this class definition
});

dojo.declare("com.ibm.team.apt.client.plancheck.PlanCheck.Run", null, { //$NON-NLS-1$

	_result: null,
	
	constructor: function(code) {
		this.execute= code;
		
	},

	// ---- api ------------------------------------------------------------------------------------------------------------

	execute: function() {
		return RUN_DONE;
	},

	getResult: function() {
		return this._result;
	},

	// ---- implementation -------------------------------------------------------------------------------------------------

	__sentinel: null // terminates this class definition
});

com.ibm.team.apt.client.plancheck.PlanCheck.Run.CONTINUE= RUN_CONTINUE;
com.ibm.team.apt.client.plancheck.PlanCheck.Run.DONE= RUN_DONE;

})();
