/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2005, 2009. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
dojo.provide("com.ibm.team.apt.internal.client.plancheck.SchedulingCheck"); //$NON-NLS-1$

dojo.require("com.ibm.team.foundation.Assert"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.client.PlanItem"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.client.PlanModel"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.client.plancheck.PlanCheck"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.client.plancheck.Problem"); //$NON-NLS-1$

dojo.require("dojo.string"); //$NON-NLS-1$
dojo.require("dojo.date.locale"); //$NON-NLS-1$
dojo.require("dojo.i18n"); //$NON-NLS-1$
dojo.requireLocalization("com.ibm.team.apt.internal.client", "PlanCheckMessages"); //$NON-NLS-1$ //$NON-NLS-2$

(function() {

var Assert							= com.ibm.team.foundation.Assert;
var PlanItem						= com.ibm.team.apt.client.PlanItem;
var PlanModel						= com.ibm.team.apt.client.PlanModel;
var PlanCheck						= com.ibm.team.apt.client.plancheck.PlanCheck;
var Run								= com.ibm.team.apt.client.plancheck.PlanCheck.Run;
var Problem							= com.ibm.team.apt.client.plancheck.Problem;

var bind= dojo.string.substitute;
var Messages= dojo.i18n.getLocalization("com.ibm.team.apt.internal.client", "PlanCheckMessages"); //$NON-NLS-1$ //$NON-NLS-2$

function formatInstant(instant) {
	return dojo.date.locale.format(instant.getDate(), { selector: "date", formatLength: "medium" }); //$NON-NLS-1$ //$NON-NLS-2$
}

dojo.declare("com.ibm.team.apt.internal.client.plancheck.SchedulingCheck", PlanCheck, { //$NON-NLS-1$

	constructor: function(checkDescription, plan) {
	},

	// ---- implementation -------------------------------------------------------------------------------------------------

	checkElement: function(planItem, progressMonitor) {
		var runner= new Run(dojo.hitch(this, function() {
			if (!planItem.isResolved() && !planItem.isAuxiliaryPlanItem()) {
				var problems= [];
				var message;
	
				var dueDate= planItem.getAttributeValue(PlanItem.DUE_DATE);

				if (dueDate != null && dueDate.before(planItem.getPlanModel().getAttributeValue(PlanModel.REFERENCE_TIME))) {
					message= bind(Messages['scheduling_pastDueDate'], [ formatInstant(dueDate) ]); //$NON-NLS-1$
					problems.push(Problem.forItem("com.ibm.team.apt.problem.schedule.pastDueDate", planItem, message)); //$NON-NLS-1$
				} 

				var scheduledTime= planItem.getAttributeValue(PlanItem.SCHEDULED_TIME);
				if (scheduledTime != null) {
					if (!planItem.getDuration().specified && !planItem.isTopLevelPlanItem()) {
						message= Messages['scheduling_noestimate']; //$NON-NLS-1$
						problems.push(Problem.forItem("com.ibm.team.apt.problem.schedule.noestimate", planItem, message)); //$NON-NLS-1$
					}
	
					if (dueDate != null && dueDate.before(scheduledTime.end)) {
						message= bind(Messages['scheduling_afterDueDate'], [ formatInstant(dueDate), formatInstant(scheduledTime.end) ]); //$NON-NLS-1$
						problems.push(Problem.forItem("com.ibm.team.apt.problem.schedule.afterDueDate", planItem, message)); //$NON-NLS-1$
					}
					
					var plannedFor= planItem.getAttributeValue(PlanItem.TARGET);
					if (plannedFor != null) {
						var planEnd= plannedFor.endDate;
						if (planEnd != null && planEnd.before(scheduledTime.end)) {
							message= bind(Messages['scheduling_afterIterationEnd'], [ formatInstant(scheduledTime.end), formatInstant(planEnd) ]); //$NON-NLS-1$
							problems.push(Problem.forItem("com.ibm.team.apt.problem.schedule.afterIterationEnd", planItem, message)); //$NON-NLS-1$
						}
					}
				}
	
				runner._result= problems;
			}

			return PlanCheck.Run.DONE;
		}));
		
		return runner;
	},

	__sentinel: null // terminates this class definition
});

})();
