/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2005, 2009. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
dojo.provide("com.ibm.team.apt.internal.client.plancheck.InvalidEstimateCheck"); //$NON-NLS-1$

dojo.require("com.ibm.team.foundation.Assert"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.client.PlanElement"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.client.PlanItem"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.client.PlanningAttributeIdentifier"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.client.plancheck.PlanCheck"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.client.plancheck.Problem"); //$NON-NLS-1$

dojo.require("dojo.string"); //$NON-NLS-1$
dojo.require("dojo.i18n"); //$NON-NLS-1$
dojo.requireLocalization("com.ibm.team.apt.internal.client", "PlanCheckMessages"); //$NON-NLS-1$ //$NON-NLS-2$

(function() {

var Assert							= com.ibm.team.foundation.Assert;
var PlanElement						= com.ibm.team.apt.client.PlanElement;
var PlanItem						= com.ibm.team.apt.client.PlanItem;
var PlanningAttributeIdentifier		= com.ibm.team.apt.client.PlanningAttributeIdentifier;
var PlanCheck						= com.ibm.team.apt.client.plancheck.PlanCheck;
var Run								= com.ibm.team.apt.client.plancheck.PlanCheck.Run;
var Problem							= com.ibm.team.apt.client.plancheck.Problem;

var bind= dojo.string.substitute;
var Messages= dojo.i18n.getLocalization("com.ibm.team.apt.internal.client", "PlanCheckMessages"); //$NON-NLS-1$ //$NON-NLS-2$

dojo.declare("com.ibm.team.apt.internal.client.plancheck.InvalidEstimateCheck", PlanCheck, { //$NON-NLS-1$

	__timeRemainingMode: false,
	
	constructor: function(checkDescription, plan) {
		this.__timeRemainingMode= "TimeRemaining" == plan.getEstimateMode(); //$NON-NLS-1$
	},

	// ---- implementation -------------------------------------------------------------------------------------------------

	checkElement: function(planItem, progressMonitor) {
		var runner= new Run(dojo.hitch(this, function() {
			
			if (this.__timeRemainingMode && !planItem.isResolved() && !planItem.isAuxiliaryPlanItem()) {
				var problems= [];
				var message;
	
				var timeSpent= planItem.getAttributeValue(PlanItem.TIMESPENT);

				var isInvalidTimeRemaining= com.ibm.team.apt.client.PlanDuration.isEncodedInvalidTimeRemaining(timeSpent);
				
				if (!isInvalidTimeRemaining && timeSpent.specified) {
					var estimate= planItem.getAttributeValue(PlanItem.ESTIMATE);
					isInvalidTimeRemaining= !estimate.specified || estimate.compareTo(timeSpent) < 0;
				}

				if (isInvalidTimeRemaining) {
					message= Messages['invalidEstimate_invalidTimeRemaining']; //$NON-NLS-1$
					
					if (planItem.getAttributeValue(PlanElement.DIRTY)) {
						problems.push(Problem.forItem("com.ibm.team.apt.problem.invalid.timeremaining.changed", planItem, message)); //$NON-NLS-1$
					} else {
						problems.push(Problem.forItem("com.ibm.team.apt.problem.invalid.timeremaining", planItem, message)); //$NON-NLS-1$
					}
					
				}

				runner._result= problems;
			}

			return PlanCheck.Run.DONE;
		}));
		
		return runner;
	},

	__sentinel: null // terminates this class definition
});

})();
