/******************************************************************************* 
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2005, 2009. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
dojo.provide("com.ibm.team.apt.client.ComplexityAttribute"); //$NON-NLS-1$

dojo.require("com.ibm.team.apt.client.PlanningAttributeType"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.client.PlanningAttributeValueSet"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.client.PlanningAttributeIdentifier"); //$NON-NLS-1$

(function() {

var PlanningAttributeType			= com.ibm.team.apt.client.PlanningAttributeType;
var PlanningAttributeValueSet		= com.ibm.team.apt.client.PlanningAttributeValueSet;
var PlanningAttributeIdentifier		= com.ibm.team.apt.client.PlanningAttributeIdentifier;


dojo.declare("com.ibm.team.apt.client.ComplexityAttribute", com.ibm.team.apt.client.ScriptableAttribute, { //$NON-NLS-1$
	
	__delegate: null,
	__delegateId: null,
		
	constructor: function(descriptor) {
		this.__thisAttributeId= new PlanningAttributeIdentifier(descriptor.id);
	},

	// ---- api ------------------------------------------------------------------------------------------------------------

	initialize: function(plan) {
		this.__delegateId= plan.getComplexityAttribute();
		if(this.__delegateId){
			this.__delegate= plan.findAttribute(this.__delegateId);
			if(this.__delegate){
				this.attributeType= this.__delegate.attributeType;
			}
		}
	},
	
	getDependantAttributes: function() {
		return this.__delegate ? [ this.__delegate ] : [ ];
	},
	
	changed: function(planElementDelta, deltaBuilder) {
		if(this.__delegateId){
			var delta= planElementDelta.getAttributeDelta(this.__delegateId);
			deltaBuilder.changed(planElementDelta.getPlanElement(), this.__thisAttributeId, delta.getOldValue(), delta.getNewValue());
		}
	},
	
//	attributeType: this.__delegate.attributeType,
	
	getValueSet: function() {
		return this.__delegate ? this.__delegate.getValueSet() : null;
	},
	
	getValue: function(receiver) {
		return this.__delegate ? this.__delegate.getValue(receiver) : null;
	},
	
	setValue: function(receiver, value) {
		if(this.__delegate) {
			this.__delegate.setValue(receiver, value);
		}
	},
	
	// ---- implementation -------------------------------------------------------------------------------------------------
	
	__sentinel: null // terminates this class definition
});

})();
