/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.common.util;

import com.ibm.team.apt.internal.common.util.IEventCondition;

public class TimedEventCondition
implements IEventCondition {
    final long fEndTime;

    public TimedEventCondition(long timeout) {
        this.fEndTime = System.currentTimeMillis() + timeout;
    }

    public void awaitEvent(long timeout) throws InterruptedException {
        long timeToEvent = this.fEndTime - System.currentTimeMillis();
        if (timeToEvent < 0L) {
            return;
        }
        Thread.sleep(Math.min(timeout, timeToEvent));
    }

    public boolean isEventTriggered() {
        return System.currentTimeMillis() > this.fEndTime;
    }
}

