/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.common.util;

import com.ibm.team.apt.internal.common.util.CMode;
import com.ibm.team.apt.internal.common.util.ItemArrayList;
import com.ibm.team.apt.internal.common.util.ItemHashMap;
import com.ibm.team.apt.internal.common.util.ItemList;
import com.ibm.team.apt.internal.common.util.ItemMap;
import com.ibm.team.process.common.IDevelopmentLine;
import com.ibm.team.process.common.IDevelopmentLineHandle;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.process.common.IIterationHandle;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.model.ItemProfile;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IterationHierarchy {
    private IDevelopmentLine fDevLine;
    private ItemList<IIteration> fAllPastIterations;
    private ItemList<IIteration> fPastIterations;
    private ItemList<IIteration> fAllCurrentIterations;
    private ItemList<IIteration> fAllFutureIterations;
    private ItemList<IIteration> fFutureIterations;
    private ItemMap<IIterationHandle, IIteration> fIterations;

    public static IterationHierarchy create(IDevelopmentLineHandle handle, IAuditableCommon auditableCommon, IProgressMonitor monitor) throws TeamRepositoryException {
        return new IterationHierarchy(handle, auditableCommon, monitor);
    }

    private IterationHierarchy(IDevelopmentLineHandle handle, IAuditableCommon auditableCommon, IProgressMonitor monitor) throws TeamRepositoryException {
        this.fDevLine = (IDevelopmentLine)auditableCommon.resolveAuditable((IAuditableHandle)handle, ItemProfile.DEVELOPMENT_LINE_DEFAULT, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)1));
        List iterations = auditableCommon.findCurrentIterations((IDevelopmentLineHandle)this.fDevLine, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)1));
        Collections.reverse(iterations);
        this.fIterations = new ItemHashMap<IIterationHandle, IIteration>();
        this.fAllCurrentIterations = new ItemArrayList<IIteration>(iterations, CMode.CURRENT_HANDLEONLY);
        this.fAllPastIterations = new ItemArrayList<IIteration>(CMode.CURRENT_HANDLEONLY);
        this.fPastIterations = new ItemArrayList<IIteration>(CMode.CURRENT_HANDLEONLY);
        this.fAllFutureIterations = new ItemArrayList<IIteration>(CMode.CURRENT_HANDLEONLY);
        this.fFutureIterations = new ItemArrayList<IIteration>(CMode.CURRENT_HANDLEONLY);
        List children = auditableCommon.resolveAuditables(Arrays.asList(this.fDevLine.getIterations()), ItemProfile.ITERATION_DEFAULT, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)1));
        boolean traversedCurrent = false;
        for (IIteration iteration : children) {
            this.processIteration(iteration, traversedCurrent, auditableCommon, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor));
            boolean bl = traversedCurrent = traversedCurrent || this.fAllCurrentIterations.contains(iteration);
        }
        this.cleanupIterations(this.fAllCurrentIterations);
        this.cleanupIterations(this.fAllPastIterations);
        this.cleanupIterations(this.fPastIterations);
        this.cleanupIterations(this.fAllFutureIterations);
        this.cleanupIterations(this.fFutureIterations);
    }

    private boolean processIteration(IIteration iteration, boolean traversedCurrent, IAuditableCommon auditableCommon, IProgressMonitor monitor) throws TeamRepositoryException {
        this.fIterations.put((IIterationHandle)iteration.getItemHandle(), iteration);
        IIterationHandle[] childHandles = iteration.getChildren();
        int processedChildren = 0;
        if (childHandles.length > 0) {
            List children = auditableCommon.resolveAuditables(Arrays.asList(childHandles), ItemProfile.ITERATION_DEFAULT, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            boolean childTraversal = traversedCurrent;
            for (IItem child : children) {
                if (!this.processIteration((IIteration)child, childTraversal, auditableCommon, (IProgressMonitor)new SubProgressMonitor(monitor, 1))) continue;
                ++processedChildren;
                boolean bl = childTraversal = childTraversal || this.fAllCurrentIterations.contains(child);
            }
        }
        boolean isRelevantLeaf = processedChildren == 0 && iteration.hasDeliverable() && !iteration.isArchived();
        boolean isCurrent = this.fAllCurrentIterations.contains(iteration);
        if (traversedCurrent) {
            this.fAllFutureIterations.add(iteration);
            if (isRelevantLeaf) {
                this.fFutureIterations.add(iteration);
            }
        } else if (!isCurrent) {
            this.fAllPastIterations.add(iteration);
            if (isRelevantLeaf) {
                this.fPastIterations.add(iteration);
            }
        }
        return processedChildren > 0 || iteration.hasDeliverable() && !iteration.isArchived();
    }

    private void cleanupIterations(ItemList<IIteration> list) {
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            IIteration iteration = (IIteration)iter.next();
            if (!iteration.isArchived() && iteration.hasDeliverable()) continue;
            iter.remove();
        }
    }

    public IIteration getIteration(IIterationHandle handle) {
        return this.fIterations.get((IItemHandle)handle);
    }

    public ItemList<IIteration> getAllIterations() {
        ItemArrayList<IIteration> result = new ItemArrayList<IIteration>(this.fAllPastIterations.size() + this.fAllCurrentIterations.size() + this.fAllFutureIterations.size());
        result.addAll(this.fAllPastIterations);
        result.addAll(this.fAllCurrentIterations);
        result.addAll(this.fAllFutureIterations);
        return result;
    }

    public ItemList<IIteration> getPastIterations() {
        return this.fPastIterations;
    }

    public ItemList<IIteration> getAllPastIterations() {
        return this.fAllPastIterations;
    }

    public IIteration getCurrentIteration() {
        if (this.fAllCurrentIterations.isEmpty()) {
            return null;
        }
        return this.fAllCurrentIterations.get(0);
    }

    public ItemList<IIteration> getAllCurrentIterations() {
        return this.fAllCurrentIterations;
    }

    public ItemList<IIteration> getFutureIterations() {
        return this.fFutureIterations;
    }

    public ItemList<IIteration> getAllFutureIterations() {
        return this.fAllFutureIterations;
    }
}

