/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.common.util;

import java.util.ArrayList;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeIterator<E>
implements Iterator<E> {
    private Iterator<E> fCurrent;
    private Iterator<Iterator<E>> fDelegate;

    public CompositeIterator(Iterator<E> first, Iterator<E> ... rest) {
        ArrayList<Iterator<E>> list = new ArrayList<Iterator<E>>();
        list.add(first);
        Iterator<E>[] iteratorArray = rest;
        int n = rest.length;
        int n2 = 0;
        while (n2 < n) {
            Iterator<E> iterator = iteratorArray[n2];
            list.add(iterator);
            ++n2;
        }
        this.fDelegate = list.iterator();
    }

    private void ensureCurrent() {
        if (this.fCurrent == null || !this.fCurrent.hasNext()) {
            this.fCurrent = this.fDelegate.hasNext() ? this.fDelegate.next() : null;
        }
    }

    @Override
    public boolean hasNext() {
        this.ensureCurrent();
        return this.fCurrent != null && this.fCurrent.hasNext();
    }

    @Override
    public E next() {
        if (!this.hasNext()) {
            return null;
        }
        return this.fCurrent.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

