/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.common.scripting.util;

import com.ibm.team.apt.internal.common.scripting.IScriptEnvironment;
import com.ibm.team.apt.internal.common.scripting.IScriptObjectProxy;
import com.ibm.team.apt.internal.common.scripting.IScriptRunnable;
import com.ibm.team.apt.internal.common.scripting.impl.JavaScriptTypes;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaScriptObjectProxy {
    public static <T> T newInstance(IScriptEnvironment environment, Class<T> type, Scriptable object) {
        ScriptInvocationHandler invocationHandler = new ScriptInvocationHandler(environment, object);
        Object result = Proxy.newProxyInstance(type.getClassLoader(), new Class[]{type}, (InvocationHandler)invocationHandler);
        return (T)result;
    }

    private static class ScriptInvocationHandler
    implements InvocationHandler,
    IScriptObjectProxy {
        private Scriptable fTarget;
        private IScriptEnvironment fScriptEnvironment;

        private ScriptInvocationHandler(IScriptEnvironment scriptEnvironment, Scriptable target) {
            this.fScriptEnvironment = scriptEnvironment;
            this.fTarget = target;
        }

        public Object invoke(Object proxy, final Method method, final Object[] args) throws Throwable {
            return this.fScriptEnvironment.execute(new IScriptRunnable<Object, RuntimeException>(){

                @Override
                public Object run(Context cx, Scriptable scope) throws RuntimeException {
                    Class<?>[] parameterTypes = method.getParameterTypes();
                    int i = 0;
                    while (i < parameterTypes.length) {
                        args[i] = JavaScriptTypes.getType(parameterTypes[i]).convertToScript(cx, scope, args[i], parameterTypes[i]);
                        ++i;
                    }
                    Object result = ScriptableObject.callMethod((Scriptable)ScriptInvocationHandler.this.fTarget, (String)method.getName(), (Object[])(args != null ? args : ScriptRuntime.emptyArgs));
                    return JavaScriptTypes.getType(method.getReturnType()).convertToJava(cx, scope, result, method.getReturnType());
                }
            });
        }

        public Scriptable getScriptable() {
            return this.fTarget;
        }
    }
}

