/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.common.scripting.util;

import com.ibm.team.apt.internal.common.plantype.IAttributeDefinitionDescriptor;
import com.ibm.team.apt.internal.common.plantype.IParameter;
import com.ibm.team.apt.internal.common.scripting.AbstractScriptType;
import com.ibm.team.apt.internal.common.scripting.IScriptEnvironment;
import com.ibm.team.apt.internal.common.scripting.IScriptRunnable;
import com.ibm.team.apt.internal.common.scripting.ScriptException;
import com.ibm.team.apt.internal.common.scripting.annotation.ScriptType;
import com.ibm.team.apt.internal.common.scripting.impl.ScriptTypeConstructor;
import com.ibm.team.apt.internal.common.scripting.util.WrappableScriptableObject;
import com.ibm.team.apt.internal.common.util.ItemCollection;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Assert;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Wrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSUtils {
    public static <T, C extends Collection<? extends T>> T[] toArray(C collection, Class<T> type) {
        return collection != null ? collection.toArray((Object[])((Object[])Array.newInstance(type, collection.size()))) : null;
    }

    public static <T, C extends ItemCollection<? extends T>> T[] toArray(C collection, Class<T> type) {
        return collection != null ? collection.toArray((Object[])((Object[])Array.newInstance(type, collection.size()))) : null;
    }

    public static <T> T[] getArrayElements(Context cx, Scriptable object, Class<T> type) {
        long length = 0L;
        length = object instanceof NativeArray ? ((NativeArray)object).getLength() : ScriptRuntime.toUint32((Object)ScriptRuntime.getObjectProp((Scriptable)object, (String)"length", (Context)cx));
        if (length > Integer.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        int len = (int)length;
        Object[] result = (Object[])Array.newInstance(type, len);
        int i = 0;
        while (i < len) {
            T elem;
            Object element = ScriptableObject.getProperty((Scriptable)object, (int)i);
            if (element instanceof Wrapper) {
                element = ((Wrapper)element).unwrap();
            }
            if ((elem = type.cast(element)) != Scriptable.NOT_FOUND) {
                result[i] = elem;
            }
            ++i;
        }
        return result;
    }

    public static Object callMethod(Context cx, Scriptable obj, String methodName, Object ... args) {
        return ScriptableObject.callMethod((Context)cx, (Scriptable)obj, (String)methodName, (Object[])JSUtils.convertArgsToJS(obj, args));
    }

    public static Object getObject(Context cx, Scriptable scope, String name) {
        return JSUtils.getObject(cx, scope, name, false);
    }

    public static Object getObject(Context cx, Scriptable scope, String name, boolean create) {
        StringTokenizer nameTokenizer = new StringTokenizer(name, String.valueOf('.'));
        Scriptable current = scope;
        while (current != null && nameTokenizer.hasMoreTokens()) {
            String propertyName = nameTokenizer.nextToken();
            Object value = ScriptableObject.getProperty((Scriptable)current, (String)propertyName);
            if (value == null && create) {
                value = cx.newObject(scope);
                ScriptableObject.putProperty((Scriptable)current, (String)propertyName, (Object)value);
            }
            Scriptable scriptable = current = value instanceof Scriptable ? (Scriptable)value : null;
        }
        return !nameTokenizer.hasMoreTokens() ? current : null;
    }

    public static void setObject(Context cx, Scriptable scope, String name, Object value) {
        StringTokenizer nameTokenizer = new StringTokenizer(name, String.valueOf('.'));
        Object current = scope;
        while (nameTokenizer.hasMoreTokens()) {
            String propertyName = nameTokenizer.nextToken();
            if (nameTokenizer.hasMoreTokens()) {
                current = ScriptableObject.getProperty((Scriptable)current, (String)propertyName);
                if (value instanceof Scriptable) continue;
                current = cx.newObject(scope);
                ScriptableObject.putProperty((Scriptable)current, (String)propertyName, (Object)current);
                continue;
            }
            ScriptableObject.putProperty((Scriptable)current, (String)propertyName, (Object)value);
        }
    }

    public static void dojoProvide(Context cx, Scriptable scope, String namespace) {
        ScriptableObject.callMethod((Context)cx, (Scriptable)JSUtils.getDojo(scope), (String)"provide", (Object[])new Object[]{namespace});
    }

    public static Scriptable create(Context cx, Scriptable scope, String name, Object ... args) {
        Object ctorVal = JSUtils.getObject(cx, scope, name);
        if (ctorVal == Scriptable.NOT_FOUND) {
            throw new ScriptException(String.format("%s: %s", name, "constructor not found"));
        }
        if (!(ctorVal instanceof Function)) {
            throw new ScriptException(String.format("%s: %s", name, "Is not a constructor"));
        }
        return ((Function)ctorVal).construct(cx, scope, JSUtils.convertArgsToJS(scope, args));
    }

    public static WrappableScriptableObject createWrappable(Context cx, Scriptable scope, String name, Object ... args) {
        Object ctorVal = JSUtils.getObject(cx, scope, name);
        if (ctorVal == Scriptable.NOT_FOUND) {
            throw new ScriptException(String.format("%s: %s", name, "constructor not found"));
        }
        if (!(ctorVal instanceof Function)) {
            throw new ScriptException(String.format("%s: %s", name, "Is not a constructor"));
        }
        WrappableScriptableObject result = new WrappableScriptableObject();
        result.setPrototype((Scriptable)ScriptableObject.getProperty((Scriptable)((Scriptable)ctorVal), (String)"prototype"));
        result.setParentScope(scope);
        ((Function)ctorVal).call(cx, scope, (Scriptable)result, JSUtils.convertArgsToJS(scope, args));
        return result;
    }

    private static Object[] convertArgsToJS(Scriptable scope, Object ... args) {
        int i = 0;
        while (i < args.length) {
            args[i] = Context.javaToJS((Object)args[i], (Scriptable)scope);
            ++i;
        }
        return args;
    }

    public static ScriptTypeConstructor getScriptTypeConstructor(Context cx, Scriptable scope, Class<? extends AbstractScriptType> scriptTypeClass) {
        Assert.isNotNull((Object)scriptTypeClass.getAnnotation(ScriptType.class), (String)String.format("Missing ScriptType annotation for class '%s'", scriptTypeClass.getName()));
        String typeName = scriptTypeClass.getAnnotation(ScriptType.class).value();
        Object ctor = JSUtils.getObject(cx, ScriptableObject.getTopLevelScope((Scriptable)scope), typeName);
        Assert.isTrue((boolean)(ctor instanceof ScriptTypeConstructor), (String)String.format("ScriptType '%s' was not registered with the current scope", typeName));
        return (ScriptTypeConstructor)((Object)ctor);
    }

    private static Scriptable getDojo(Scriptable scope) {
        return (Scriptable)ScriptableObject.getProperty((Scriptable)scope, (String)"dojo");
    }

    public static Scriptable createOptions(final IScriptEnvironment scriptEnvironment, final IParameter[] parameters, final IAttributeDefinitionDescriptor[] columns) {
        return scriptEnvironment.execute(new IScriptRunnable<Scriptable, RuntimeException>(){

            @Override
            public Scriptable run(Context cx, Scriptable scope) throws RuntimeException {
                Scriptable result = cx.newObject(scope);
                ScriptableObject.putProperty((Scriptable)result, (String)"context", (Object)Context.javaToJS((Object)scriptEnvironment.getEnvironmentContext(), (Scriptable)scope));
                ScriptableObject.putProperty((Scriptable)result, (String)"parameters", (Object)JSUtils.createParameters(cx, scope, parameters));
                if (columns != null) {
                    ScriptableObject.putProperty((Scriptable)result, (String)"columns", (Object)JSUtils.createColumns(cx, scope, columns));
                }
                return result;
            }
        });
    }

    public static Scriptable createColumns(Context cx, Scriptable scope, IAttributeDefinitionDescriptor[] parameters) {
        Scriptable result = cx.newArray(scope, parameters.length);
        int i = 0;
        while (i < parameters.length) {
            ScriptableObject.putProperty((Scriptable)result, (int)i, (Object)parameters[i].getId());
            ++i;
        }
        return result;
    }

    public static Scriptable createParameters(Context cx, Scriptable scope, IParameter[] parameters) {
        Scriptable result = cx.newObject(scope);
        HashMap<String, ArrayList<String>> paramMap = new HashMap<String, ArrayList<String>>();
        IParameter[] iParameterArray = parameters;
        int n = parameters.length;
        int n2 = 0;
        while (n2 < n) {
            IParameter parameter = iParameterArray[n2];
            ArrayList<String> values = (ArrayList<String>)paramMap.get(parameter.getKey());
            if (values == null) {
                values = new ArrayList<String>();
                paramMap.put(parameter.getKey(), values);
            }
            values.add(parameter.getValue());
            ++n2;
        }
        for (Map.Entry entry : paramMap.entrySet()) {
            Object value = ((List)entry.getValue()).size() == 1 ? ((List)entry.getValue()).get(0) : ((List)entry.getValue()).toArray();
            ScriptableObject.putProperty((Scriptable)result, (String)((String)entry.getKey()), (Object)Context.javaToJS((Object)value, (Scriptable)scope));
        }
        return result;
    }
}

