/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.common.scripting.util;

import com.ibm.team.apt.internal.common.scripting.environment.AbstractScriptFeature;
import com.ibm.team.apt.internal.common.scripting.environment.FileLocalizationFeature;
import com.ibm.team.apt.internal.common.scripting.environment.FileScriptFeature;
import com.ibm.team.repository.common.util.ExtensionRegistryReader;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionScriptSourceRegistry
extends ExtensionRegistryReader<AbstractScriptFeature> {
    private static final ExtensionScriptSourceRegistry fgInstance = new ExtensionScriptSourceRegistry();
    private final List<AbstractScriptFeature> fAPTScripts = new ArrayList<AbstractScriptFeature>();
    private final List<AbstractScriptFeature> fAdditionalScripts = new ArrayList<AbstractScriptFeature>();

    public static ExtensionScriptSourceRegistry getInstance() {
        return fgInstance;
    }

    private ExtensionScriptSourceRegistry() {
        super("com.ibm.team.apt.common", "scriptSource");
    }

    public List<AbstractScriptFeature> getDescriptors() {
        ArrayList<AbstractScriptFeature> result = new ArrayList<AbstractScriptFeature>();
        result.addAll(this.fAPTScripts);
        result.addAll(this.fAdditionalScripts);
        return result;
    }

    protected AbstractScriptFeature handleExtensionAdded(IConfigurationElement element) throws Exception {
        AbstractScriptFeature result = null;
        if ("scriptSource".equals(element.getName())) {
            result = new FileScriptFeature(element.getNamespaceIdentifier(), (IPath)new Path(element.getAttribute("file")));
        } else if ("localization".equals(element.getName())) {
            result = new FileLocalizationFeature(element.getAttribute("bundle"), element.getAttribute("name"), element.getNamespaceIdentifier(), (IPath)new Path(element.getAttribute("path")));
        }
        if (result != null) {
            String namespace = element.getNamespaceIdentifier();
            if (namespace.indexOf("com.ibm.team.apt.scripts") != -1) {
                this.fAPTScripts.add(result);
            } else {
                this.fAdditionalScripts.add(result);
            }
        }
        return result;
    }
}

