/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.common.scripting.impl;

import com.ibm.team.apt.common.APTCommonPlugin;
import com.ibm.team.apt.internal.common.scripting.AbstractWrapperScriptType;
import com.ibm.team.apt.internal.common.scripting.IScriptObjectProxy;
import com.ibm.team.apt.internal.common.scripting.annotation.WrapType;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.eclipse.core.runtime.Assert;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.WrapFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptEnvironmentWrapFactory
extends WrapFactory {
    private final Map<IdentityKey<Object>, Scriptable> fWrapperCache = new WeakHashMap<IdentityKey<Object>, Scriptable>();
    private final Map<Class<?>, Constructor<? extends AbstractWrapperScriptType<?>>> fWrapperConstructors = new HashMap();

    public <T> void registerWrapper(Class<? extends AbstractWrapperScriptType<T>> wrapperType) {
        WrapType wrapType = wrapperType.getAnnotation(WrapType.class);
        if (wrapType != null) {
            this.fWrapperConstructors.put(wrapType.value(), this.findConstructor(wrapType.value(), wrapperType));
        }
    }

    public Scriptable wrapAsJavaObject(Context cx, Scriptable scope, Object javaObject, Class staticType) {
        InvocationHandler invocationHandler;
        if (javaObject instanceof IScriptObjectProxy) {
            return ((IScriptObjectProxy)javaObject).getScriptable();
        }
        if (Proxy.isProxyClass(javaObject.getClass()) && (invocationHandler = Proxy.getInvocationHandler(javaObject)) instanceof IScriptObjectProxy) {
            return ((IScriptObjectProxy)((Object)invocationHandler)).getScriptable();
        }
        IdentityKey<Object> key = new IdentityKey<Object>(javaObject);
        Scriptable result = this.fWrapperCache.get(key);
        if (result != null) {
            return result;
        }
        Class<?> sourceClass = javaObject.getClass();
        Constructor<AbstractWrapperScriptType<?>> wrapperConstructor = this.fWrapperConstructors.get(sourceClass);
        if (wrapperConstructor == null && !this.fWrapperConstructors.containsKey(sourceClass)) {
            ArrayList candidateClasses = new ArrayList();
            this.computeClassOrder(javaObject.getClass(), candidateClasses);
            for (Class clazz : candidateClasses) {
                wrapperConstructor = this.fWrapperConstructors.get(clazz);
                if (wrapperConstructor != null) break;
            }
            this.fWrapperConstructors.put(sourceClass, wrapperConstructor);
        }
        if (wrapperConstructor != null) {
            try {
                result = wrapperConstructor.newInstance(cx, scope, javaObject);
            }
            catch (Exception e) {
                Context.throwAsScriptRuntimeEx((Throwable)e);
            }
        }
        if (result == null) {
            if (APTCommonPlugin.DEBUG_SCRIPTING && sourceClass.getName().startsWith("com.ibm.team")) {
                APTCommonPlugin.log(String.format("Object of type %s wrapped in a generic way!", sourceClass.getName()), (Exception)new EvaluatorException(""));
            }
            result = super.wrapAsJavaObject(cx, scope, javaObject, staticType);
        }
        this.fWrapperCache.put(key, result);
        return result;
    }

    private Constructor<? extends AbstractWrapperScriptType<?>> findConstructor(Class<?> sourceType, Class<? extends AbstractWrapperScriptType<?>> wrapperType) {
        try {
            return wrapperType.getConstructor(Context.class, Scriptable.class, sourceType);
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {}
        Assert.isTrue((boolean)false, (String)"Constructor with the parameters [Context, Scriptable, Object] is expected");
        return null;
    }

    private void computeClassOrder(Class<?> sourceClass, Collection<Class<?>> classes) {
        Class<?> clazz = sourceClass;
        HashSet seen = new HashSet(4);
        while (clazz != null) {
            classes.add(clazz);
            this.computeInterfaceOrder(clazz.getInterfaces(), classes, seen);
            clazz = clazz.getSuperclass();
        }
    }

    private void computeInterfaceOrder(Class[] interfaces, Collection<Class<?>> classes, Set<Class<?>> seen) {
        ArrayList<Class> newInterfaces = new ArrayList<Class>(interfaces.length);
        int i = 0;
        while (i < interfaces.length) {
            Class interfac = interfaces[i];
            if (seen.add(interfac)) {
                classes.add(interfac);
                newInterfaces.add(interfac);
            }
            ++i;
        }
        Iterator it = newInterfaces.iterator();
        while (it.hasNext()) {
            this.computeInterfaceOrder(((Class)it.next()).getInterfaces(), classes, seen);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IdentityKey<T> {
        private final T fKey;

        IdentityKey(T key) {
            this.fKey = key;
        }

        public int hashCode() {
            return System.identityHashCode(this.fKey);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            IdentityKey other = (IdentityKey)obj;
            return this.fKey == other.fKey;
        }
    }
}

