/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.common.scripting.environment;

import com.ibm.team.apt.common.APTCommonPlugin;
import com.ibm.team.apt.internal.common.scripting.environment.AbstractScriptFeature;
import com.ibm.team.repository.common.FileLocator;
import com.ibm.team.repository.common.util.NLS;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.sql.Timestamp;
import java.util.Locale;
import org.eclipse.core.runtime.IPath;

public class FileScriptFeature
extends AbstractScriptFeature {
    private URL fUrl;
    private String fFileName;

    public FileScriptFeature(String bundleSymbolicName, IPath path) {
        this.fFileName = path.lastSegment();
        this.fUrl = FileLocator.find((String)bundleSymbolicName, (IPath)path, null);
        if (this.fUrl == null) {
            APTCommonPlugin.log(NLS.bind((String)"Missing script file (Bundle: ''{0}'', Path: ''{1}'')", (Object)bundleSymbolicName, (Object[])new Object[]{path.toString()}), new Exception());
        }
    }

    public FileScriptFeature(URL fileUrl) {
        this.fFileName = fileUrl.getFile();
        this.fUrl = fileUrl;
    }

    protected Reader getInputReader() throws IOException {
        URLConnection connection = this.fUrl.openConnection();
        String encoding = connection.getContentEncoding();
        return new InputStreamReader(connection.getInputStream(), encoding != null ? encoding : "UTF-8");
    }

    public int getLineNumber() {
        return 1;
    }

    public String getSourceName() {
        return this.fFileName;
    }

    public Timestamp getLastModifiedTime(Locale locale) throws IOException {
        URLConnection connection = this.fUrl.openConnection();
        return new Timestamp(connection.getLastModified());
    }
}

