/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.common.scripting.environment;

import com.ibm.team.apt.common.APTCommonPlugin;
import com.ibm.team.apt.internal.common.scripting.IScriptEnvironment;
import com.ibm.team.apt.internal.common.scripting.environment.IScriptEnvironmentFeature;
import com.ibm.team.repository.common.util.NLS;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.sql.Timestamp;
import java.util.Locale;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;

public abstract class AbstractScriptFeature
implements IScriptEnvironmentFeature {
    private Script fPrecompiledScript;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void define(Context cx, Scriptable scope, IScriptEnvironment scriptEnvironment) {
        Script script = null;
        AbstractScriptFeature abstractScriptFeature = this;
        synchronized (abstractScriptFeature) {
            try {
                if (this.isOudated() || this.fPrecompiledScript == null) {
                    this.fPrecompiledScript = cx.compileReader(this.getInputReader(), this.getSourceName(), this.getLineNumber(), null);
                }
                script = this.fPrecompiledScript;
            }
            catch (IOException e) {
                APTCommonPlugin.log(NLS.bind((String)"Unable to load file {0}", (Object)this.getSourceName(), (Object[])new Object[0]), e);
            }
        }
        if (script != null) {
            script.exec(cx, scope);
        }
    }

    public abstract String getSourceName();

    public abstract int getLineNumber();

    public String getSource(Locale locale) throws IOException {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(this.getInputReader());
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)output, "UTF-8");
            int ch = reader.read();
            while (ch != -1) {
                writer.write(ch);
                ch = reader.read();
            }
            writer.flush();
            writer.close();
            String string = new String(output.toByteArray(), "UTF-8");
            return string;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    public abstract Timestamp getLastModifiedTime(Locale var1) throws IOException;

    protected boolean isOudated() throws IOException {
        return APTCommonPlugin.ALWAYS_RECOMPILE_SCRIPTS;
    }

    protected abstract Reader getInputReader() throws IOException;

    protected static String createStringFromInputStream(InputStream input, String contentEncoding) throws IOException {
        try {
            if (contentEncoding == null) {
                contentEncoding = "UTF-8";
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(input, contentEncoding));
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)output, "UTF-8");
            int ch = reader.read();
            while (ch != -1) {
                writer.write(ch);
                ch = reader.read();
            }
            writer.flush();
            writer.close();
            String string = new String(output.toByteArray(), "UTF-8");
            return string;
        }
        finally {
            if (input != null) {
                input.close();
            }
        }
    }
}

