/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.common.process;

import com.ibm.team.apt.internal.common.process.ConfigurationElementFactory;
import com.ibm.team.apt.internal.common.process.ConfigurationElementInvocationHandler;
import com.ibm.team.apt.internal.common.process.ConfigurationElements;
import com.ibm.team.apt.internal.common.process.ElementPath;
import com.ibm.team.apt.internal.common.process.Path;
import com.ibm.team.apt.internal.common.util.Empty;
import com.ibm.team.foundation.common.util.IMemento;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ConfigurationElementSerializer {
    private int fMode = 0;

    public ConfigurationElementSerializer(int flags) {
        this.fMode = flags;
    }

    public void serialize(Object object, Class<?> type, IMemento root) {
        ConfigurationElementInvocationHandler handler = ConfigurationElements.getHandler(object);
        HashMap<String, Object> values = handler.getValues();
        this.serializeType(type, values, root);
    }

    private void serializeType(Class type, Map<String, Object> values, IMemento typeMemento) {
        Method[] methods;
        Assert.isLegal((boolean)ConfigurationElements.isConfigurationDataType(type));
        IMemento methodMemento = (this.fMode & 2) != 0 ? typeMemento : ConfigurationElementSerializer.createChildrenForPath(typeMemento, type);
        Method[] methodArray = methods = type.getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (ConfigurationElements.isGetter(method)) {
                this.serializeMethod(method, values, methodMemento);
            }
            ++n2;
        }
    }

    private void serializeMethod(Method method, Map<String, Object> values, IMemento methodMemento) {
        Path annotation = method.getAnnotation(Path.class);
        if (annotation == null) {
            return;
        }
        Object value = values.get(ConfigurationElements.key(annotation));
        if (value != null) {
            Class<?> returnType = method.getReturnType();
            if (returnType.isArray()) {
                returnType = returnType.getComponentType();
                int len = Array.getLength(value);
                int i = 0;
                while (i < len) {
                    Object nValue = Array.get(value, i);
                    if (this.shouldSerialize(nValue, returnType)) {
                        this.serializeValue(returnType, annotation, nValue, ConfigurationElementSerializer.createChildrenForPath(methodMemento, method));
                    }
                    ++i;
                }
            } else if (this.shouldSerialize(value, returnType)) {
                this.serializeValue(returnType, annotation, value, ConfigurationElementSerializer.createChildrenForPath(methodMemento, method));
            }
        }
    }

    private boolean shouldSerialize(Object value, Class<?> type) {
        if (value == null) {
            return false;
        }
        if ((this.fMode & 2) == 0) {
            return true;
        }
        if (ConfigurationElements.isConfigurationDataType(type)) {
            return !ConfigurationElements.hasFlag(value, 2);
        }
        return false;
    }

    private void serializeValue(Class returnType, Path annotation, Object value, IMemento methodMemento) {
        if (ConfigurationElements.isConfigurationDataType(returnType)) {
            if (!Proxy.isProxyClass(value.getClass())) {
                value = ConfigurationElementFactory.copy(value);
            }
            Assert.isLegal((boolean)Proxy.isProxyClass(value.getClass()));
            Assert.isLegal((boolean)(Proxy.getInvocationHandler(value) instanceof ConfigurationElementInvocationHandler));
            HashMap<String, Object> values = ConfigurationElements.getHandler(value).getValues();
            if (Empty.is(annotation.to())) {
                new ConfigurationElementSerializer(0).serialize(value, returnType, methodMemento);
                return;
            }
            if (annotation.refines()) {
                new ConfigurationElementSerializer(2).serialize(value, returnType, methodMemento);
            }
            value = values.get(annotation.to());
        }
        String key = ConfigurationElements.key(annotation);
        ElementPath path = ElementPath.valueOf(key);
        methodMemento.putString(path.getAttribute(), String.valueOf(value));
    }

    private static IMemento createChildrenForPath(IMemento memento, AnnotatedElement element) {
        Path annotation = element.getAnnotation(Path.class);
        String key = ConfigurationElements.key(annotation);
        ElementPath path = ElementPath.valueOf(key);
        memento = ConfigurationElementSerializer.createChildrenForPath(memento, path);
        return memento;
    }

    private static IMemento createChildrenForPath(IMemento memento, ElementPath path) {
        Iterator<String> iter = path.getSegments().iterator();
        while (iter.hasNext()) {
            String segment = iter.next();
            IMemento[] children = memento.getChildren(segment);
            IMemento iMemento = memento = iter.hasNext() && children != null && children.length != 0 ? children[0] : memento.createChild(segment);
        }
        return memento;
    }
}

