/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.common.process;

import com.ibm.team.apt.common.APTCommonPlugin;
import com.ibm.team.apt.internal.common.plantype.IConfigurationElement;
import com.ibm.team.apt.internal.common.process.CloningValueComputer;
import com.ibm.team.apt.internal.common.process.ConfigurationData;
import com.ibm.team.apt.internal.common.process.ConfigurationElementInvocationHandler;
import com.ibm.team.apt.internal.common.process.ConfigurationElementSerializer;
import com.ibm.team.apt.internal.common.process.ConfigurationElements;
import com.ibm.team.apt.internal.common.process.ElementPath;
import com.ibm.team.apt.internal.common.process.EmptyValueComputer;
import com.ibm.team.apt.internal.common.process.ICacheEntryState;
import com.ibm.team.apt.internal.common.process.ICachingSupport;
import com.ibm.team.apt.internal.common.process.ICompositeNodeProvider;
import com.ibm.team.apt.internal.common.process.IConfigurationElementMassage;
import com.ibm.team.apt.internal.common.process.INode;
import com.ibm.team.apt.internal.common.process.INodeProvider;
import com.ibm.team.apt.internal.common.process.NodeBasedValueComputer;
import com.ibm.team.apt.internal.common.process.Path;
import com.ibm.team.apt.internal.common.util.IFilter;
import com.ibm.team.foundation.common.util.IMemento;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationElementFactory {
    public static final IFilter<INode> nullFilter = new IFilter<INode>(){

        @Override
        public boolean accept(INode element) {
            return true;
        }
    };
    public static final List<IConfigurationElementMassage<?>> emptyMassages = Collections.emptyList();
    static final String ID = "id";
    static final String CONFIGURATION_DATA = "configuration-data";

    public static <T> T singleInstance(Class<T> type, INodeProvider provider, IProgressMonitor monitor) throws TeamRepositoryException {
        return ConfigurationElementFactory.singleInstance(type, nullFilter, provider, monitor);
    }

    public static <T> T singleInstance(Class<T> type, IFilter<? super INode> filter, INodeProvider provider, IProgressMonitor monitor) throws TeamRepositoryException {
        return ConfigurationElementFactory.singleInstance(type, filter, provider, emptyMassages, monitor);
    }

    public static <T> T singleInstance(Class<T> type, IFilter<? super INode> filter, INodeProvider provider, List<IConfigurationElementMassage<?>> massages, IProgressMonitor monitor) throws TeamRepositoryException {
        return ConfigurationElementFactory.singleInstance(type, filter, provider, massages, 8, monitor);
    }

    static <T> T singleInstance(Class<T> type, IFilter<? super INode> filter, INodeProvider provider, List<IConfigurationElementMassage<?>> massages, int flags, IProgressMonitor monitor) throws TeamRepositoryException {
        Assert.isLegal((boolean)ConfigurationElements.isConfigurationDataType(type));
        List<INode> elements = ConfigurationElementFactory.selectConfigurationElement(type, provider, monitor);
        for (INode element : elements) {
            if (!filter.accept(element)) continue;
            return ConfigurationElementFactory.newInstance(type, element, provider, massages, flags, monitor);
        }
        return null;
    }

    public static <T> List<T> allInstances(Class<T> type, INodeProvider provider, IProgressMonitor monitor) throws TeamRepositoryException {
        return ConfigurationElementFactory.allInstances(type, nullFilter, provider, monitor);
    }

    public static <T> List<T> allInstances(Class<T> type, IFilter<? super INode> filter, INodeProvider provider, IProgressMonitor monitor) throws TeamRepositoryException {
        return ConfigurationElementFactory.allInstances(type, filter, provider, emptyMassages, monitor);
    }

    public static <T> List<T> allInstances(Class<T> type, IFilter<? super INode> filter, INodeProvider provider, List<IConfigurationElementMassage<?>> massages, IProgressMonitor monitor) throws TeamRepositoryException {
        return ConfigurationElementFactory.allInstances(type, filter, provider, massages, 8, monitor);
    }

    static <T> List<T> allInstances(Class<T> type, IFilter<? super INode> filter, INodeProvider provider, List<IConfigurationElementMassage<?>> massages, int flags, IProgressMonitor monitor) throws TeamRepositoryException {
        Assert.isLegal((boolean)ConfigurationElements.isConfigurationDataType(type));
        List<INode> elements = ConfigurationElementFactory.selectConfigurationElement(type, provider, monitor);
        ArrayList<T> result = new ArrayList<T>(elements.size());
        for (INode element : elements) {
            if (!filter.accept(element)) continue;
            T instance = ConfigurationElementFactory.newInstance(type, element, provider, massages, flags, monitor);
            result.add(instance);
        }
        return result;
    }

    public static <T> T singleInstance(Class<T> type, INode element) {
        Assert.isLegal((boolean)ConfigurationElements.isConfigurationDataType(type));
        Assert.isLegal((boolean)ConfigurationElements.isSingleConfigurationDataPoint(type));
        List<INode> elements = ConfigurationElementFactory.select(type, element);
        Iterator<INode> iterator = elements.iterator();
        if (iterator.hasNext()) {
            INode node = iterator.next();
            try {
                return ConfigurationElementFactory.newInstance(type, node, null, emptyMassages, 8, null);
            }
            catch (TeamRepositoryException teamRepositoryException) {
                return null;
            }
        }
        return null;
    }

    public static <T> List<T> allInstances(Class<T> type, INode element) {
        Assert.isLegal((boolean)ConfigurationElements.isConfigurationDataType(type));
        Assert.isLegal((boolean)ConfigurationElements.isSingleConfigurationDataPoint(type));
        List<INode> elements = ConfigurationElementFactory.select(type, element);
        ArrayList<T> result = new ArrayList<T>(elements.size());
        for (INode node : elements) {
            try {
                result.add(ConfigurationElementFactory.newInstance(type, node, null, emptyMassages, 8, null));
            }
            catch (TeamRepositoryException teamRepositoryException) {}
        }
        return result;
    }

    public static <T> T emptyInstance(Class<T> type) {
        Assert.isLegal((boolean)ConfigurationElements.isConfigurationDataType(type));
        Assert.isLegal((boolean)ConfigurationElements.isCircularDependencyFree(type));
        try {
            ConfigurationElementInvocationHandler handler = new ConfigurationElementInvocationHandler(type, EmptyValueComputer.Instance);
            return (T)Proxy.newProxyInstance(type.getClassLoader(), new Class[]{type}, (InvocationHandler)handler);
        }
        catch (TeamRepositoryException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T copy(T object) {
        Class<?> type = ConfigurationElements.getConfigurationDataType(object);
        Assert.isNotNull(type);
        try {
            ConfigurationElementInvocationHandler handler = new ConfigurationElementInvocationHandler(type, new CloningValueComputer(object));
            return (T)Proxy.newProxyInstance(object.getClass().getClassLoader(), new Class[]{type}, (InvocationHandler)handler);
        }
        catch (TeamRepositoryException e) {
            throw new RuntimeException(e);
        }
    }

    static <T> T newInstance(final Class<T> type, final INode element, final INodeProvider provider, List<IConfigurationElementMassage<?>> massages, int flags, final IProgressMonitor monitor) throws TeamRepositoryException {
        String identifier;
        Assert.isLegal((boolean)ConfigurationElements.isCircularDependencyFree(type));
        Class<?> providerType = element.getNodeProvider() != null ? element.getNodeProvider().getClass() : null;
        ConfigurationElementInvocationHandler handler = new ConfigurationElementInvocationHandler(type, new NodeBasedValueComputer(element, provider, massages, flags, monitor), providerType, flags);
        final Object result = Proxy.newProxyInstance(type.getClassLoader(), new Class[]{type}, (InvocationHandler)handler);
        final Iterator<IConfigurationElementMassage<?>> iter = massages.iterator();
        while (iter.hasNext()) {
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    IConfigurationElementMassage next = (IConfigurationElementMassage)iter.next();
                    if (next.getType().isAssignableFrom(type)) {
                        next.massage(result, element, provider, monitor);
                    }
                }

                public void handleException(Throwable e) {
                    APTCommonPlugin.log(e.getLocalizedMessage(), new Exception(e));
                }
            });
        }
        if ((flags & 0x10) == 0 && element instanceof ICacheEntryState && provider instanceof ICachingSupport && IConfigurationElement.class.isAssignableFrom(type) && (identifier = ((IConfigurationElement)IConfigurationElement.class.cast(result)).getId()) != null) {
            ((ICachingSupport)provider).add((ICacheEntryState)((Object)element), identifier, result);
        }
        return (T)result;
    }

    private static <T> List<INode> selectConfigurationElement(Class<T> type, INodeProvider provider, IProgressMonitor monitor) throws TeamRepositoryException {
        ConfigurationData configurationData = type.getAnnotation(ConfigurationData.class);
        String[] values = configurationData.value();
        ArrayList<INode> result = new ArrayList<INode>();
        String[] stringArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            if (provider instanceof ICompositeNodeProvider) {
                INodeProvider[] delegates;
                INodeProvider[] iNodeProviderArray = delegates = ((ICompositeNodeProvider)provider).getDelegates();
                int n3 = delegates.length;
                int n4 = 0;
                while (n4 < n3) {
                    INodeProvider deletage = iNodeProviderArray[n4];
                    List<INode> subResult = ConfigurationElementFactory.selectConfigurationElement(type, deletage, monitor);
                    result.addAll(subResult);
                    ++n4;
                }
            } else {
                INode data = provider.getNode(value, monitor);
                result.addAll(ConfigurationElementFactory.select(type, data));
            }
            ++n2;
        }
        return result;
    }

    private static <T> List<INode> select(Class<T> type, INode data) {
        Path path = type.getAnnotation(Path.class);
        if (data != null) {
            return ConfigurationElements.select(data, ElementPath.valueOf(path.value()).getSegments());
        }
        return Collections.emptyList();
    }

    public static void serializeIntoRoot(Object object, IMemento root) {
        Assert.isLegal((boolean)Proxy.isProxyClass(object.getClass()));
        Assert.isLegal((boolean)(Proxy.getInvocationHandler(object) instanceof ConfigurationElementInvocationHandler));
        Class<?> type = object.getClass().getInterfaces()[0];
        ConfigurationData data = type.getAnnotation(ConfigurationData.class);
        root.putString(ID, data.value()[0]);
        new ConfigurationElementSerializer(0).serialize(object, type, root);
    }

    public static void serializeIntoConfigData(Object object, IMemento root) {
        IMemento[] children;
        Assert.isLegal((boolean)Proxy.isProxyClass(object.getClass()));
        Assert.isLegal((boolean)(Proxy.getInvocationHandler(object) instanceof ConfigurationElementInvocationHandler));
        Class<?> type = ConfigurationElements.getConfigurationDataType(object);
        ConfigurationData data = type.getAnnotation(ConfigurationData.class);
        String configurationData = data.value()[0];
        Class<?> type1 = ConfigurationElements.getConfigurationDataType(object);
        IMemento typeRoot = null;
        IMemento[] iMementoArray = children = root.getChildren(CONFIGURATION_DATA);
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento child = iMementoArray[n2];
            if (child.getString(ID).equals(configurationData)) {
                typeRoot = child;
                break;
            }
            ++n2;
        }
        if (typeRoot == null) {
            typeRoot = root.createChild(CONFIGURATION_DATA);
            typeRoot.putString(ID, configurationData);
        }
        new ConfigurationElementSerializer(0).serialize(object, type1, typeRoot);
    }

    public static void serializeIntoConfigData(Object object, IMemento root, String configurationData) {
        IMemento[] children;
        Assert.isLegal((boolean)Proxy.isProxyClass(object.getClass()));
        Assert.isLegal((boolean)(Proxy.getInvocationHandler(object) instanceof ConfigurationElementInvocationHandler));
        Class<?> type = ConfigurationElements.getConfigurationDataType(object);
        ConfigurationData data = type.getAnnotation(ConfigurationData.class);
        boolean found = false;
        String[] stringArray = data.value();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            if (configurationData.equals(value)) {
                found |= true;
            }
            ++n2;
        }
        if (!found) {
            throw new IllegalArgumentException();
        }
        IMemento typeRoot = null;
        IMemento[] iMementoArray = children = root.getChildren(CONFIGURATION_DATA);
        int n3 = children.length;
        int n4 = 0;
        while (n4 < n3) {
            IMemento child = iMementoArray[n4];
            if (child.getString(ID).equals(configurationData)) {
                typeRoot = child;
                break;
            }
            ++n4;
        }
        if (typeRoot == null) {
            typeRoot = root.createChild(CONFIGURATION_DATA);
            typeRoot.putString(ID, configurationData);
        }
        new ConfigurationElementSerializer(0).serialize(object, type, typeRoot);
    }
}

