/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.common.process;

import com.ibm.team.apt.internal.common.process.ICacheEntryState;
import com.ibm.team.apt.internal.common.process.ICachingSupport;
import com.ibm.team.apt.internal.common.process.ICompositeNodeProvider;
import com.ibm.team.apt.internal.common.process.INode;
import com.ibm.team.apt.internal.common.process.INodeProvider;
import com.ibm.team.repository.common.TeamRepositoryException;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeNodeProvider
implements INodeProvider,
ICachingSupport,
ICompositeNodeProvider {
    private INodeProvider[] fDelegates;
    private ICachingSupport fCachingSupport;

    public CompositeNodeProvider(INodeProvider[] delegates) {
        this.fDelegates = delegates;
        this.initCachingSupport();
    }

    public CompositeNodeProvider(INodeProvider first, INodeProvider ... rest) {
        int len = rest.length;
        this.fDelegates = new INodeProvider[1 + len];
        if (len > 0) {
            this.fDelegates[0] = first;
            System.arraycopy(rest, 0, this.fDelegates, 1, len);
        }
        this.initCachingSupport();
    }

    private void initCachingSupport() {
        INodeProvider[] iNodeProviderArray = this.fDelegates;
        int n = this.fDelegates.length;
        int n2 = 0;
        while (n2 < n) {
            INodeProvider delegate = iNodeProviderArray[n2];
            if (delegate instanceof ICachingSupport) {
                if (this.fCachingSupport == null) {
                    this.fCachingSupport = (ICachingSupport)delegate;
                } else {
                    throw new IllegalArgumentException();
                }
            }
            ++n2;
        }
    }

    @Override
    public INode getNode(String identifier, IProgressMonitor monitor) throws TeamRepositoryException {
        INodeProvider[] iNodeProviderArray = this.fDelegates;
        int n = this.fDelegates.length;
        int n2 = 0;
        while (n2 < n) {
            INodeProvider delegate = iNodeProviderArray[n2];
            INode node = delegate.getNode(identifier, monitor);
            if (node != null) {
                return node;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public INodeProvider[] getDelegates() {
        return this.fDelegates;
    }

    @Override
    public <T> T get(String identifier, Class<T> type) {
        if (this.fCachingSupport == null) {
            return null;
        }
        return this.fCachingSupport.get(identifier, type);
    }

    @Override
    public void add(ICacheEntryState node, String identifier, Object value) {
        if (this.fCachingSupport == null) {
            return;
        }
        this.fCachingSupport.add(node, identifier, value);
    }
}

