/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.common.process;

import com.ibm.team.apt.internal.common.PlanItemAttributes;
import com.ibm.team.apt.internal.common.plantype.IAttributeDefinitionDescriptor;
import com.ibm.team.apt.internal.common.plantype.PlanningAttributeType;
import com.ibm.team.apt.internal.common.process.INode;
import com.ibm.team.apt.internal.common.process.INodeProvider;
import com.ibm.team.apt.internal.common.process.ProjectAreaBasedMassage;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.common.IWorkItemCommon;
import com.ibm.team.workitem.common.model.AttributeTypes;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.Identifier;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeDefinitionMassage
extends ProjectAreaBasedMassage<IAttributeDefinitionDescriptor> {
    private IWorkItemCommon fWorkItemCommon;

    public AttributeDefinitionMassage(IWorkItemCommon workItemCommon) {
        this.fWorkItemCommon = workItemCommon;
    }

    @Override
    public void massage(IProjectAreaHandle projectArea, IAttributeDefinitionDescriptor attribute, INode element, INodeProvider provider, IProgressMonitor monitor) throws TeamRepositoryException {
        IAttribute resolvedAttribute;
        Identifier<IAttribute> identifier = PlanItemAttributes.getAttributeId(attribute);
        if (identifier != null && (resolvedAttribute = this.fWorkItemCommon.findAttribute(projectArea, identifier.getStringIdentifier(), monitor)) != null) {
            if (attribute.getDisplayName() == null) {
                attribute.setDisplayName(resolvedAttribute.getDisplayName());
            }
            if (attribute.getType() == null) {
                PlanningAttributeType type = AttributeTypes.isEnumerationAttributeType((String)resolvedAttribute.getAttributeType()) ? PlanningAttributeType.ENUMERATION : PlanItemAttributes.getPlanningAttributeType(resolvedAttribute.getAttributeType());
                attribute.setType(type);
            }
        }
    }

    @Override
    public Class<IAttributeDefinitionDescriptor> getType() {
        return IAttributeDefinitionDescriptor.class;
    }
}

