/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.common.plantype;

import com.ibm.icu.text.Collator;
import com.ibm.team.apt.internal.common.Timespan;
import com.ibm.team.apt.internal.common.util.Dates;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.workitem.common.model.Duration;
import com.ibm.team.workitem.common.model.ILiteral;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum PlanningAttributeType {
    STRING(new StringType()),
    HTML(new StringType()),
    INTEGER(new ComparableType()),
    FLOAT(new ComparableType()),
    BOOLEAN(new ComparableType()),
    INSTANT(new ComparableType()),
    DURATION(new DurationType()),
    TIMESPAN(new TimespanType()),
    SEQUENCEVALUE(new ComparableType()),
    RANKING(new DefaultType()),
    TAGS(new DefaultType()),
    CHECKERREPORT(new DefaultType()),
    UUID(new DefaultType()),
    WORKITEM_TYPE(new DefaultType()),
    WORKFLOW_STATE(new DefaultType()),
    ITEM(new ItemType()),
    ENUMERATION(new EnumType()),
    VOID(new VoidType());

    private final DefaultType fTypeDelegate;

    private PlanningAttributeType(DefaultType typeDelegate) {
        this.fTypeDelegate = typeDelegate;
    }

    public int compareValues(Object v1, Object v2) {
        if (v1 == null || v2 == null) {
            return (v1 == null ? 1 : 0) - (v2 == null ? 1 : 0);
        }
        return this.fTypeDelegate.compareValues(v1, v2);
    }

    public boolean equalValues(Object v1, Object v2) {
        if (v1 == null || v2 == null) {
            return v1 == v2;
        }
        return this.fTypeDelegate.equalValues(v1, v2);
    }

    private static class ComparableType
    extends DefaultType {
        private ComparableType() {
            super(null, null);
        }

        public int compareValues(Object v1, Object v2) {
            return ((Comparable)v1).compareTo(v2);
        }
    }

    private static class DefaultType {
        private DefaultType() {
        }

        public boolean equalValues(Object v1, Object v2) {
            return v1.equals(v2);
        }

        public int compareValues(Object v1, Object v2) {
            throw new UnsupportedOperationException();
        }

        /* synthetic */ DefaultType(DefaultType defaultType, DefaultType defaultType2) {
            this();
        }
    }

    private static class DurationType
    extends DefaultType {
        private DurationType() {
            super(null, null);
        }

        public int compareValues(Object v1, Object v2) {
            Duration d1 = (Duration)v1;
            Duration d2 = (Duration)v2;
            if (!d1.isSpecified() || !d2.isSpecified()) {
                return (d1.isSpecified() ? 1 : 0) - (d2.isSpecified() ? 1 : 0);
            }
            if (d1.longValue() < d2.longValue()) {
                return -1;
            }
            if (d1.longValue() > d2.longValue()) {
                return 1;
            }
            return 0;
        }
    }

    private static class EnumType
    extends DefaultType {
        private EnumType() {
            super(null, null);
        }

        public int compareValues(Object v1, Object v2) {
            return ((ILiteral)v1).compareTo((Object)((ILiteral)v2));
        }
    }

    private static class ItemType
    extends DefaultType {
        private ItemType() {
            super(null, null);
        }

        public boolean equalValues(Object v1, Object v2) {
            return ((IItemHandle)v1).sameItemId((IItemHandle)v2);
        }
    }

    private static class StringType
    extends DefaultType {
        private StringType() {
            super(null, null);
        }

        public int compareValues(Object v1, Object v2) {
            return Collator.getInstance().compare(v1, v2);
        }
    }

    private static class TimespanType
    extends DefaultType {
        private TimespanType() {
            super(null, null);
        }

        public int compareValues(Object v1, Object v2) {
            return Dates.compareTo(((Timespan)v1).getStart(), ((Timespan)v2).getStart());
        }
    }

    private static class VoidType
    extends DefaultType {
        private VoidType() {
            super(null, null);
        }

        public int compareValues(Object v1, Object v2) {
            throw new UnsupportedOperationException();
        }
    }
}

