/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.common.resource;

import com.ibm.team.apt.common.resource.IWorkDayDefinition;
import com.ibm.team.apt.common.resource.IWorkLocationDefinition;
import com.ibm.team.apt.internal.common.resource.model.ResourceFactory;
import com.ibm.team.apt.internal.common.resource.model.WeekDay;
import com.ibm.team.apt.internal.common.resource.model.WorkDayDefinition;
import com.ibm.team.apt.internal.common.resource.model.WorkLocationDefinition;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.eclipse.core.runtime.Assert;

public final class ResourcePlanningUtils {
    private static final String EMPTY_STRING = "";

    public static synchronized IWorkLocationDefinition createWorkLocation(int weekDays, long workDayMillis, Locale locale) {
        String variant;
        Assert.isNotNull((Object)locale);
        ResourceFactory factory = ResourceFactory.eINSTANCE;
        WorkLocationDefinition result = factory.createWorkLocationDefinition();
        result.setCustomized(false);
        result.setUniversal(false);
        result.setLanguage(locale.getLanguage());
        String country = locale.getCountry();
        if (country != null && !EMPTY_STRING.equals(country)) {
            result.setCountry(country);
        }
        if ((variant = locale.getVariant()) != null && !EMPTY_STRING.equals(variant)) {
            result.setVariant(variant);
        }
        TimeZone zone = TimeZone.getDefault();
        result.setTimeZone(zone.getID());
        result.setZoneOffset(zone.getOffset(System.currentTimeMillis()));
        List days = result.getWorkDays();
        long workingTime = workDayMillis;
        long endTime = 32400000L + workingTime;
        WorkDayDefinition day = factory.createWorkDayDefinition();
        day.setDay(WeekDay.get(2));
        if (weekDays > 0) {
            day.setWorkingTime(workingTime);
            day.setEndTime(endTime);
        } else {
            day.setWorkingTime(0L);
            day.setEndTime(0L);
        }
        days.add(day);
        day = factory.createWorkDayDefinition();
        day.setDay(WeekDay.get(3));
        if (weekDays > 1) {
            day.setWorkingTime(workingTime);
            day.setEndTime(endTime);
        } else {
            day.setWorkingTime(0L);
            day.setEndTime(0L);
        }
        days.add(day);
        day = factory.createWorkDayDefinition();
        day.setDay(WeekDay.get(4));
        if (weekDays > 2) {
            day.setWorkingTime(workingTime);
            day.setEndTime(endTime);
        } else {
            day.setWorkingTime(0L);
            day.setEndTime(0L);
        }
        days.add(day);
        day = factory.createWorkDayDefinition();
        day.setDay(WeekDay.get(5));
        if (weekDays > 3) {
            day.setWorkingTime(workingTime);
            day.setEndTime(endTime);
        } else {
            day.setWorkingTime(0L);
            day.setEndTime(0L);
        }
        days.add(day);
        day = factory.createWorkDayDefinition();
        day.setDay(WeekDay.get(6));
        if (weekDays > 4) {
            day.setWorkingTime(workingTime);
            day.setEndTime(endTime);
        } else {
            day.setWorkingTime(0L);
            day.setEndTime(0L);
        }
        days.add(day);
        day = factory.createWorkDayDefinition();
        day.setDay(WeekDay.get(7));
        if (weekDays > 5) {
            day.setWorkingTime(workingTime);
            day.setEndTime(endTime);
        } else {
            day.setWorkingTime(0L);
            day.setEndTime(0L);
        }
        days.add(day);
        day = factory.createWorkDayDefinition();
        day.setDay(WeekDay.get(1));
        if (weekDays > 6) {
            day.setWorkingTime(workingTime);
            day.setEndTime(endTime);
        } else {
            day.setWorkingTime(0L);
            day.setEndTime(0L);
        }
        days.add(day);
        return result;
    }

    public static Locale getLocale(IWorkLocationDefinition definition) {
        String variant;
        String country;
        Assert.isNotNull((Object)definition);
        String language = definition.getLanguage();
        if (language == null) {
            language = EMPTY_STRING;
        }
        if ((country = definition.getCountry()) == null) {
            country = EMPTY_STRING;
        }
        if ((variant = definition.getVariant()) == null) {
            variant = EMPTY_STRING;
        }
        return new Locale(language, country, variant);
    }

    public static TimeZone getTimeZone(IWorkLocationDefinition definition) {
        String id = definition.getTimeZone();
        if (id != null && !EMPTY_STRING.equals(id)) {
            return TimeZone.getTimeZone(id);
        }
        return TimeZone.getDefault();
    }

    public static long getWorkDayMillis(IWorkLocationDefinition definition) {
        Assert.isNotNull((Object)definition);
        Collection<IWorkDayDefinition> days = definition.getWorkDays();
        int result = 0;
        int count = 0;
        for (IWorkDayDefinition day : days) {
            long time = day.getWorkingTime();
            if (time <= 0L) continue;
            result = (int)((long)result + time);
            ++count;
        }
        return result / count;
    }

    public static int getWorkWeekDays(IWorkLocationDefinition definition) {
        Assert.isNotNull((Object)definition);
        Collection<IWorkDayDefinition> days = definition.getWorkDays();
        int result = 0;
        for (IWorkDayDefinition day : days) {
            if (day.getWorkingTime() <= 0L) continue;
            ++result;
        }
        return result;
    }

    public static int[] convertWorkDayMillis(long millis) {
        int hours = (int)(millis / 3600000L);
        int rest = (int)(millis % 3600000L);
        int minutes = (int)((long)rest / 60000L);
        rest = (int)((long)rest % 60000L);
        int seconds = (int)((long)rest / 1000L);
        rest = (int)((long)rest % 1000L);
        return new int[]{hours, minutes, seconds, rest};
    }
}

