/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.client.wiki;

import com.ibm.icu.text.Collator;
import com.ibm.team.apt.internal.client.wiki.IResolvedWikiPageListener;
import com.ibm.team.apt.internal.client.wiki.ResolvedWikiPageAttachment;
import com.ibm.team.apt.internal.client.wiki.WikiClient;
import com.ibm.team.apt.internal.client.wiki.WikiManager;
import com.ibm.team.apt.internal.client.wiki.WikiPageSaveResult;
import com.ibm.team.apt.internal.common.wiki.IWikiPage;
import com.ibm.team.apt.internal.common.wiki.WikiPath;
import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ListenerList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResolvedWikiPage {
    private IWikiPage fWikiPage;
    private IContributor fModifiedBy;
    private IItem fOwner;
    private WikiPath fWikiPath;
    private XMLString fContent;
    private List<ResolvedWikiPageAttachment> fAttachments;
    private boolean fAllowsEmbeddedHtml;
    private boolean fIsDirty;
    private ListenerList fListeners;

    public ResolvedWikiPage(IWikiPage page, IItem owner, XMLString content, IContributor modifiedBy, WikiPath wikiPath, List<ResolvedWikiPageAttachment> attachments, boolean allowsEmbeddedXhtml) {
        this.fWikiPage = page;
        this.fOwner = owner;
        this.fContent = content;
        this.fModifiedBy = modifiedBy;
        this.fWikiPath = wikiPath;
        this.fAttachments = new ArrayList<ResolvedWikiPageAttachment>(attachments);
        Collections.sort(this.fAttachments, new Comparator<ResolvedWikiPageAttachment>(){
            private Collator fCollator = Collator.getInstance();

            @Override
            public int compare(ResolvedWikiPageAttachment o1, ResolvedWikiPageAttachment o2) {
                return this.fCollator.compare(o1.getAttachment().getName(), o2.getAttachment().getName());
            }
        });
        this.fAllowsEmbeddedHtml = allowsEmbeddedXhtml;
        this.fListeners = new ListenerList(1);
    }

    public IWikiPage getWikiPage() {
        return this.fWikiPage;
    }

    public WikiPath getWikiPath() {
        return this.fWikiPath;
    }

    public IContributor lastModifiedBy() {
        return this.fModifiedBy;
    }

    public Date lastModified() {
        return this.fWikiPage.modified();
    }

    public IItem getOwner() {
        return this.fOwner;
    }

    @Deprecated
    public XMLString getContent() {
        return this.fContent;
    }

    public String getContent2() {
        return this.fContent.getXMLText();
    }

    @Deprecated
    public void setContent(XMLString content) {
        this.fContent = content;
        boolean oldValue = this.fIsDirty;
        this.fIsDirty = true;
        this.fireDirtyStateChanged(oldValue);
    }

    public void setContent2(String content) {
        this.fContent = XMLString.createFromXMLText((String)content);
        boolean oldValue = this.fIsDirty;
        this.fIsDirty = true;
        this.fireDirtyStateChanged(oldValue);
    }

    public String getWikiName() {
        return this.fWikiPage.getWikiID();
    }

    public List<ResolvedWikiPageAttachment> getAttachments() {
        return this.fAttachments;
    }

    public void addAttachment(ResolvedWikiPageAttachment attachment) {
        if (this.fAttachments.contains(attachment)) {
            return;
        }
        this.fAttachments.add(attachment);
        this.fireAttachmentAdded(attachment);
    }

    public void removeAttachment(ResolvedWikiPageAttachment attachment) {
        if (this.fAttachments.remove(attachment)) {
            this.fireAttachmentRemoved(attachment);
        }
    }

    public boolean isAllowsEmbeddedHtml() {
        return this.fAllowsEmbeddedHtml;
    }

    public void addListener(IResolvedWikiPageListener listener) {
        this.fListeners.add((Object)listener);
    }

    public void removeListener(IResolvedWikiPageListener listener) {
        this.fListeners.remove((Object)listener);
    }

    public void markAsDirty() {
        boolean oldValue = this.fIsDirty;
        this.fIsDirty = true;
        this.fireDirtyStateChanged(oldValue);
    }

    public boolean isDirty() {
        return this.fIsDirty;
    }

    public WikiPageSaveResult save(IProgressMonitor monitor) throws TeamRepositoryException, IOException {
        WikiManager wikiManager = WikiClient.getWikiManager((IItem)this.fWikiPage);
        WikiPageSaveResult result = wikiManager.savePage(this.fWikiPage, this.fContent, monitor);
        if (result.getStatus().getSeverity() == 0) {
            this.postSave(result.getWikiPage(), true);
        }
        return result;
    }

    public void postSave(IWikiPage page, boolean contentSaved) {
        Assert.isTrue((boolean)this.fWikiPage.getItemId().equals((Object)page.getItemId()));
        this.fWikiPage = page;
        if (contentSaved) {
            this.fIsDirty = false;
            this.fireDirtyStateChanged(true);
        }
    }

    private void fireDirtyStateChanged(boolean oldValue) {
        Object[] listeners;
        if (oldValue == this.fIsDirty) {
            return;
        }
        Object[] objectArray = listeners = this.fListeners.getListeners();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IResolvedWikiPageListener)listener).dirtyStateChanged(oldValue, this.fIsDirty);
            ++n2;
        }
    }

    private void fireAttachmentAdded(ResolvedWikiPageAttachment attachment) {
        Object[] listeners;
        Object[] objectArray = listeners = this.fListeners.getListeners();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IResolvedWikiPageListener)listener).attachmentAdded(attachment);
            ++n2;
        }
    }

    private void fireAttachmentRemoved(ResolvedWikiPageAttachment attachment) {
        Object[] listeners;
        Object[] objectArray = listeners = this.fListeners.getListeners();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IResolvedWikiPageListener)listener).attachmentRemoved(attachment);
            ++n2;
        }
    }
}

