/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.client.scripting.facades;

import com.ibm.team.apt.internal.client.IPlanningAttribute;
import com.ibm.team.apt.internal.client.IPlanningAttributeIdentifier;
import com.ibm.team.apt.internal.client.ItemSequenceManager;
import com.ibm.team.apt.internal.client.OutOfOfficeItem;
import com.ibm.team.apt.internal.client.PlanDeltaBuilder;
import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.client.PlanningAttributeIdentifier;
import com.ibm.team.apt.internal.client.ResolvedIterationPlan;
import com.ibm.team.apt.internal.client.ResolvedPersonalPlan;
import com.ibm.team.apt.internal.client.ResolvedPlan;
import com.ibm.team.apt.internal.client.planchecker.PlanCheck;
import com.ibm.team.apt.internal.client.scripting.facades.PlanElementScriptType;
import com.ibm.team.apt.internal.common.Instant;
import com.ibm.team.apt.internal.common.duration.IComplexityAttribute;
import com.ibm.team.apt.internal.common.plantype.IPlanCheckDescription;
import com.ibm.team.apt.internal.common.scripting.IScriptEnvironment;
import com.ibm.team.apt.internal.common.scripting.IScriptRunnable;
import com.ibm.team.apt.internal.common.scripting.annotation.Constant;
import com.ibm.team.apt.internal.common.scripting.annotation.Function;
import com.ibm.team.apt.internal.common.scripting.annotation.ScriptType;
import com.ibm.team.apt.internal.common.scripting.annotation.WrapType;
import com.ibm.team.apt.internal.common.scripting.util.JSUtils;
import com.ibm.team.apt.internal.common.util.ItemCollection;
import com.ibm.team.apt.internal.common.util.Node;
import com.ibm.team.process.common.IDevelopmentLine;
import com.ibm.team.process.common.IDevelopmentLineHandle;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.process.common.IIterationHandle;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.workitem.common.model.ICategory;
import com.ibm.team.workitem.common.model.ICategoryHandle;
import com.ibm.team.workitem.common.model.IWorkItemType;
import com.ibm.team.workitem.common.workflow.IWorkflowInfo;
import java.util.ArrayList;
import java.util.Collection;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScriptType(value="com.ibm.team.apt.client.PlanModel")
@WrapType(value=ResolvedPlan.class)
public class PlanModelScriptType
extends PlanElementScriptType<ResolvedPlan> {
    @Constant
    public static final IPlanningAttributeIdentifier RESOURCE_PLANNING = ResolvedPlan.RESOURCE_PLANNING;
    @Constant
    public static final IPlanningAttributeIdentifier REFERENCE_TIME = ResolvedPlan.REFERENCE_TIME;

    public PlanModelScriptType(Context cx, Scriptable scope, ResolvedPlan plan) {
        super(cx, scope, plan);
    }

    @Function
    public PlanItem getPlanItem(String itemIdString) {
        return ((ResolvedPlan)((Object)this.getSubject())).getPlanItem(UUID.valueOf((String)itemIdString));
    }

    @Function
    public IItem getItem(String itemIdString) {
        UUID itemId = UUID.valueOf((String)itemIdString);
        ICategory result = null;
        ResolvedPlan subject = (ResolvedPlan)((Object)this.getSubject());
        result = subject.getResolvedCategory((ICategoryHandle)ICategory.ITEM_TYPE.createItemHandle(itemId, null));
        if (result != null) {
            return result;
        }
        result = subject.getResolvedContributor((IContributorHandle)IContributor.ITEM_TYPE.createItemHandle(itemId, null));
        if (result != null) {
            return result;
        }
        result = subject.getResolvedDevelopmentLine((IDevelopmentLineHandle)IDevelopmentLine.ITEM_TYPE.createItemHandle(itemId, null));
        if (result != null) {
            return result;
        }
        result = subject.getResolvedIteration((IIterationHandle)IIteration.ITEM_TYPE.createItemHandle(itemId, null));
        if (result != null) {
            return result;
        }
        IProcessAreaHandle handle = null;
        handle = subject.getProjectArea().getItemHandle().getItemId().equals((Object)itemId) ? (IProcessAreaHandle)IProjectArea.ITEM_TYPE.createItemHandle(itemId, null) : (IProcessAreaHandle)ITeamArea.ITEM_TYPE.createItemHandle(itemId, null);
        result = subject.getResolvedProcessArea(handle);
        if (result != null) {
            return result;
        }
        return null;
    }

    @Function
    public Instant getReferenceTime() {
        return new Instant(((ResolvedPlan)((Object)this.getSubject())).getReferenceTime());
    }

    @Function
    public IPlanningAttribute<?, ?> findAttribute(IPlanningAttributeIdentifier attributeId) {
        return ((ResolvedPlan)((Object)this.getSubject())).findAttribute(attributeId);
    }

    @Function
    public IPlanningAttribute[] getAllAttributes() {
        return (IPlanningAttribute[])JSUtils.toArray(((ResolvedPlan)((Object)this.getSubject())).getAllAttributes(), IPlanningAttribute.class);
    }

    @Function
    public IPlanCheckDescription[] getPlanChecks() {
        ArrayList<IPlanCheckDescription> result = new ArrayList<IPlanCheckDescription>();
        for (PlanCheck planCheck : ((ResolvedPlan)((Object)this.getSubject())).getPlanChecker().getChecks()) {
            result.add(planCheck.getCheckDescription());
        }
        return (IPlanCheckDescription[])JSUtils.toArray(result, IPlanCheckDescription.class);
    }

    @Function
    public IPlanningAttributeIdentifier getComplexityAttribute() {
        IComplexityAttribute complexityAttribute;
        if (this.getSubject() instanceof ResolvedIterationPlan && (complexityAttribute = ((ResolvedIterationPlan)((Object)this.getSubject())).getComplexityAttribute()) != null) {
            return PlanningAttributeIdentifier.create(complexityAttribute.getAttributeId());
        }
        return null;
    }

    @Function
    public boolean useComplexity() {
        if (this.getSubject() instanceof ResolvedIterationPlan) {
            return ((ResolvedIterationPlan)((Object)this.getSubject())).getPlanType().getPlanItems().isReleasePlan();
        }
        return false;
    }

    @Function
    public String getEstimateMode() {
        return ((ResolvedPlan)((Object)this.getSubject())).getDurationSupport().getEstimateMode().name();
    }

    @Function
    public IContributor[] getTeamMembers() {
        return (IContributor[])JSUtils.toArray(((ResolvedPlan)((Object)this.getSubject())).getOwners(), IContributor.class);
    }

    @Function
    public ICategory[] getPlanCategories() {
        return (ICategory[])JSUtils.toArray(((ResolvedPlan)((Object)this.getSubject())).getCategories(), ICategory.class);
    }

    @Function
    public IIteration[] getIterations() {
        return (IIteration[])JSUtils.toArray(((ResolvedPlan)((Object)this.getSubject())).getIntervals(), IIteration.class);
    }

    @Function
    public Node getIterationHierarchy() {
        return ((ResolvedIterationPlan)((Object)this.getSubject())).getIterationHierarchy();
    }

    @Function
    public boolean isPrimaryCategory(ICategoryHandle category) {
        return ((ResolvedIterationPlan)((Object)this.getSubject())).isPrimaryCategory(category);
    }

    @Function
    public boolean isPrimaryIteration(IIterationHandle iteration) {
        return ((ResolvedIterationPlan)((Object)this.getSubject())).isPrimaryIteration(iteration);
    }

    @Function
    public boolean canAddToIteration(IWorkItemType workItemType, IIterationHandle iteration) {
        return ((ResolvedIterationPlan)((Object)this.getSubject())).canAdd(workItemType, iteration);
    }

    @Function
    public boolean canAddToCategory(IWorkItemType workItemType, ICategoryHandle category) {
        return ((ResolvedIterationPlan)((Object)this.getSubject())).canAdd(workItemType, category);
    }

    @Function
    public IProcessArea getRootTeamMemberArea() {
        if (this.getSubject() instanceof ResolvedIterationPlan) {
            return ((ResolvedIterationPlan)((Object)this.getSubject())).getTeamMemberArea();
        }
        return null;
    }

    @Function
    public IProcessArea[] getTeamMemberAreas() {
        ItemCollection<IProcessArea> result = ((ResolvedPlan)((Object)this.getSubject())).getTeamMemberAreas();
        return (IProcessArea[])result.toArray((Object[])new IProcessArea[result.size()]);
    }

    @Function
    public IProcessArea getTeamMemberArea(ICategoryHandle category) {
        return ((ResolvedPlan)((Object)this.getSubject())).getTeamMemberArea(category);
    }

    @Function
    public ICategoryHandle getPrimaryCategoryFor(IProcessArea area) {
        return ((ResolvedPlan)((Object)this.getSubject())).getPrimaryCategoryFor(area);
    }

    @Function
    public PlanItem[] getAllPlanItems() {
        Collection<PlanItem> result = ((ResolvedPlan)((Object)this.getSubject())).getAllPlanItems();
        return result.toArray(new PlanItem[result.size()]);
    }

    @Function
    public OutOfOfficeItem[] getAbsences() {
        Collection<OutOfOfficeItem> result = ((ResolvedPlan)((Object)this.getSubject())).getAbsences();
        return result.toArray(new OutOfOfficeItem[result.size()]);
    }

    @Function
    public IWorkflowInfo getWorkflowInfo(String workflowId) {
        return ((ResolvedPlan)((Object)this.getSubject())).getWorkflowInfo(workflowId);
    }

    @Function
    public Object compoundChange(final org.mozilla.javascript.Function code, final Scriptable thisObj) {
        final PlanDeltaBuilder deltaBuilder = ((ResolvedPlan)((Object)this.getSubject())).connectDeltaBuilder();
        try {
            IScriptEnvironment scriptEnvironment = IScriptEnvironment.CURRENT.getScriptEnvironment();
            Object object = scriptEnvironment.execute((IScriptRunnable)new IScriptRunnable<Object, RuntimeException>(){

                public Object run(Context cx, Scriptable scope) throws RuntimeException {
                    return code.call(cx, scope, thisObj, new Object[]{Context.javaToJS((Object)deltaBuilder, (Scriptable)scope)});
                }
            });
            return object;
        }
        finally {
            ((ResolvedPlan)((Object)this.getSubject())).disconnectDeltaBuilder();
        }
    }

    @Function
    public ItemSequenceManager getItemSequenceManager(IContributor owner) {
        ResolvedPlan plan = (ResolvedPlan)((Object)this.getSubject());
        if (plan instanceof ResolvedIterationPlan) {
            return ((ResolvedIterationPlan)plan).getItemSequenceManager((IContributorHandle)owner);
        }
        if (plan instanceof ResolvedPersonalPlan && ((ResolvedPersonalPlan)plan).getPlanOwner().sameItemId((IItemHandle)owner)) {
            return ((ResolvedPersonalPlan)plan).getItemSequenceManager();
        }
        return null;
    }
}

