/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.client.progress;

import com.ibm.team.apt.internal.client.progress.ProgressScriptEnvironment;
import com.ibm.team.apt.internal.common.duration.IProgressInformation;
import com.ibm.team.apt.internal.common.duration.IQueryableProgressInformation;
import com.ibm.team.apt.internal.common.rcp.dto.DTO_IterationPlanProgress2;
import com.ibm.team.apt.internal.common.rcp.dto.DTO_WorkItemProgress;
import com.ibm.team.apt.internal.common.scripting.IScriptEnvironment;

public final class ProgressClient {
    public static IQueryableProgressInformation convert(DTO_IterationPlanProgress2 from, ProgressScriptEnvironment environment) {
        IQueryableProgressInformation to = (IQueryableProgressInformation)IQueryableProgressInformation.FACTORY.newInstance((IScriptEnvironment)environment, new Object[0]);
        to.deltaCloseCount(from.getCloseCount());
        to.deltaOpenCount(from.getOpenCount());
        to.deltaEstimateCount(from.getEstimatedCount());
        to.deltaStepsDone(from.getWorkHoursDone());
        to.deltaStepsLeft(from.getWorkHoursLeft());
        to.deltaRealTimeDone(from.getRealTimeDone());
        to.deltaRealTimeLeft(from.getRealTimeLeft());
        return to;
    }

    public static IQueryableProgressInformation convert(DTO_WorkItemProgress from, ProgressScriptEnvironment environment) {
        IQueryableProgressInformation to = (IQueryableProgressInformation)IQueryableProgressInformation.FACTORY.newInstance((IScriptEnvironment)environment, new Object[0]);
        to.deltaCloseCount(from.getCloseCount());
        to.deltaOpenCount(from.getOpenCount());
        to.deltaEstimateCount(from.getEstimatedCount());
        to.deltaStepsDone(from.getWorkHoursDone());
        to.deltaStepsLeft(from.getWorkHoursLeft());
        return to;
    }

    public static void delta(IProgressInformation receiver, IProgressInformation delta) {
        ProgressClient.addSubract(true, receiver, delta);
    }

    public static void add(IProgressInformation receiver, IProgressInformation delta) {
        ProgressClient.addSubract(true, receiver, delta);
    }

    public static void subtract(IProgressInformation receiver, IProgressInformation delta) {
        ProgressClient.addSubract(false, receiver, delta);
    }

    private static void addSubract(boolean add, IProgressInformation receiver, IProgressInformation delta) {
        receiver.deltaOpenCount(delta.getOpenCount() * (add ? 1 : -1));
        receiver.deltaCloseCount(delta.getCloseCount() * (add ? 1 : -1));
        receiver.deltaEstimateCount(delta.getEstimatedCount() * (add ? 1 : -1));
        receiver.deltaStepsDone(delta.getStepsDone() * (long)(add ? 1 : -1));
        receiver.deltaStepsLeft(delta.getStepsLeft() * (long)(add ? 1 : -1));
        receiver.deltaRealTimeLeft(delta.getRealTimeLeft() * (long)(add || delta.getRealTimeLeft() == -1L ? 1 : -1));
        receiver.deltaRealTimeDone(delta.getRealTimeDone() * (long)(add || delta.getRealTimeDone() == -1L ? 1 : -1));
    }
}

