/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.client.planchecker;

import com.ibm.team.apt.internal.client.IPlanAttributeDelta;
import com.ibm.team.apt.internal.client.IPlanElementDelta;
import com.ibm.team.apt.internal.client.IPlanElementDeltaVisitor;
import com.ibm.team.apt.internal.client.IPlanningAttribute;
import com.ibm.team.apt.internal.client.IPlanningAttributeIdentifier;
import com.ibm.team.apt.internal.client.PlanElement;
import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.apt.internal.client.planchecker.AttributeProblem;
import com.ibm.team.apt.internal.client.planchecker.Messages;
import com.ibm.team.apt.internal.client.planchecker.PlanCheck;
import com.ibm.team.apt.internal.client.planchecker.PlanCheckReport;
import com.ibm.team.apt.internal.client.planchecker.PlanItemPlanCheckReport;
import com.ibm.team.apt.internal.client.planchecker.Problem;
import com.ibm.team.apt.internal.client.util.WorkItemAttributesHelper;
import com.ibm.team.apt.internal.common.Severity;
import com.ibm.team.apt.internal.common.plantype.IPlanCheckDescription;
import com.ibm.team.apt.internal.common.plantype.IProblemDescription;
import com.ibm.team.apt.internal.common.util.ItemHashMap;
import com.ibm.team.apt.internal.common.util.ItemMap;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequiredAttributeCheck
extends PlanCheck {
    private static final IProblemDescription PROBLEM_DEFINITION = IProblemDescription.FACTORY.create("com.ibm.team.apt.problem.requiredAttribute", "missingAttribute", Severity.FATAL_ERROR);
    static final List<IPlanningAttributeIdentifier> sIgnoredAttributes = Arrays.asList(PlanItem.MARKED_READ, PlanItem.SCHEDULED_TIME);

    public RequiredAttributeCheck(IPlanCheckDescription checkDescriptor) {
        super(checkDescriptor);
    }

    @Override
    public void runDeltaCheck(PlanCheckReport report, IPlanElementDelta delta, IProgressMonitor monitor) throws TeamRepositoryException {
        final HashSet itemsToCheck = new HashSet();
        delta.accept(new IPlanElementDeltaVisitor(){

            public boolean visit(IPlanElementDelta delta) {
                PlanElement element = delta.getPlanElement();
                if (element instanceof PlanItem) {
                    itemsToCheck.addAll(RequiredAttributeCheck.this.computeItemsToCheck((PlanItem)element, delta));
                }
                return true;
            }
        });
        this.run(report, itemsToCheck, monitor);
    }

    @Override
    public void runElementCheck(PlanCheckReport report, Collection<? extends PlanElement> elementsToCheck, IProgressMonitor monitor) throws TeamRepositoryException {
        this.run(report, elementsToCheck, monitor);
    }

    @Override
    public void runFullCheck(PlanCheckReport report, IProgressMonitor monitor) throws TeamRepositoryException {
    }

    private Collection<PlanItem> computeItemsToCheck(PlanItem item, IPlanElementDelta delta) {
        if (!delta.isChanged()) {
            return Collections.emptyList();
        }
        IPlanAttributeDelta[] deltas = delta.getAttributeDeltas();
        int length = deltas.length;
        if (length == 0 || length == 1 && sIgnoredAttributes.contains(deltas[0].getAttribute())) {
            return Collections.emptyList();
        }
        return Collections.singletonList(item);
    }

    private void run(PlanCheckReport report, Collection<? extends PlanElement> planItems, IProgressMonitor monitor) throws TeamRepositoryException {
        if (planItems.isEmpty() || !this.isEnabled()) {
            return;
        }
        this.checkCanceled(monitor);
        monitor.beginTask("", planItems.size() * 4);
        HashMap<String, IAttribute> property2Attribute = new HashMap<String, IAttribute>();
        ITeamRepository teamRepository = report.getPlan().getTeamRepository();
        IAuditableClient auditableClient = PlanningClientPlugin.getAuditableClient(teamRepository);
        IWorkItemClient workItemClient = PlanningClientPlugin.getWorkItemClient(teamRepository);
        RequiredPropertiesCache requiredProperties = new RequiredPropertiesCache(workItemClient);
        for (PlanElement planElement : planItems) {
            if (!(planElement instanceof PlanItem)) continue;
            PlanItem planItem = (PlanItem)planElement;
            this.checkCanceled(monitor);
            if (!planItem.isConnected()) continue;
            PlanItemPlanCheckReport planItemReport = report.createReport(planItem);
            planItemReport.clearProblems(Collections.singletonList(PROBLEM_DEFINITION.getId()));
            monitor.setTaskName(NLS.bind((String)Messages.RequiredAttributeCheck_MONITOR_CHECKING_WORK_ITEM, (Object)String.valueOf(planItem.getId()), (Object[])new Object[0]));
            RequiredPropertiesInfo info = requiredProperties.get(planItem, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            int i = 0;
            while (i < info.properties.size()) {
                Object nullValue;
                Object value;
                String property = info.properties.get(i);
                IAttribute attribute = RequiredAttributeCheck.getAttribute(property2Attribute, workItemClient, (IProjectAreaHandle)planItem.getPlan().getProjectArea(), property, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                if (WorkItemAttributesHelper.isAttributeSet(planItem, attribute) && RequiredAttributeCheck.equals(value = WorkItemAttributesHelper.getAttributeValue(planItem, attribute), nullValue = attribute.getNullValue((IAuditableCommon)auditableClient, (IProgressMonitor)new SubProgressMonitor(monitor, 1)))) {
                    IPlanningAttribute planAttribute = planItem.getPlanningAttribute(property);
                    String message = NLS.bind((String)Messages.RequiredAttributeCheck_MESSAGE, (Object)attribute.getDisplayName(), (Object[])new Object[0]);
                    if (planAttribute != null) {
                        planItemReport.addProblem(new AttributeProblem(PROBLEM_DEFINITION, planItem, planAttribute, message));
                    } else {
                        planItemReport.addProblem(new Problem(PROBLEM_DEFINITION, planItem, message));
                    }
                }
                ++i;
            }
        }
        monitor.done();
    }

    private void checkCanceled(IProgressMonitor monitor) {
        if (monitor != null && monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    private static final boolean equals(Object left, Object right) {
        return left == null ? right == null : right != null && left.equals(right);
    }

    private static IAttribute getAttribute(Map<String, IAttribute> cache, IWorkItemClient client, IProjectAreaHandle projectArea, String property, IProgressMonitor monitor) throws TeamRepositoryException {
        IAttribute result = cache.get(property);
        if (result != null) {
            return result;
        }
        result = client.findAttribute(projectArea, property, monitor);
        cache.put(property, result);
        return result;
    }

    private static class RequiredPropertiesCache {
        private IWorkItemClient fWorkItemClient;
        private ItemMap<IProcessAreaHandle, Map<String, RequiredPropertiesInfo>> fCache = new ItemHashMap();

        public RequiredPropertiesCache(IWorkItemClient workItemClient) {
            this.fWorkItemClient = workItemClient;
        }

        public RequiredPropertiesInfo get(PlanItem planItem, IProgressMonitor monitor) throws TeamRepositoryException {
            String workItemType;
            RequiredPropertiesInfo result;
            monitor.beginTask("", 2);
            IProcessAreaHandle processArea = this.fWorkItemClient.findProcessArea((IWorkItemHandle)planItem.getWorkItem(false), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            HashMap<String, RequiredPropertiesInfo> map = (HashMap<String, RequiredPropertiesInfo>)this.fCache.get((IItemHandle)processArea);
            if (map == null) {
                map = new HashMap<String, RequiredPropertiesInfo>();
                this.fCache.put((IItemHandle)processArea, map);
            }
            if ((result = (RequiredPropertiesInfo)map.get(workItemType = planItem.getItemType().getIdentifier())) == null) {
                result = new RequiredPropertiesInfo(WorkItemAttributesHelper.findRequiredProperties(planItem, (IProgressMonitor)new SubProgressMonitor(monitor, 1)));
                map.put(workItemType, result);
            }
            monitor.done();
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RequiredPropertiesInfo {
        public List<String> properties;

        public RequiredPropertiesInfo(List<String> p) {
            this.properties = p;
        }
    }
}

