/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.client;

import com.ibm.team.apt.internal.common.ProcessAreaInfo;
import com.ibm.team.apt.internal.common.util.ItemHashMap;
import com.ibm.team.apt.internal.common.util.ItemMap;
import com.ibm.team.apt.internal.common.util.Node;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.repository.common.IItemHandle;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessAreaHierarchyBuilder {
    private Node<IProcessArea> fRoot;
    private ItemMap<IProcessAreaHandle, ProcessAreaInfo> fProcessArea2Info = new ItemHashMap();
    private Map<ProcessAreaInfo, Node<IProcessArea>> fProcessArea2Node = new HashMap<ProcessAreaInfo, Node<IProcessArea>>();

    public ProcessAreaHierarchyBuilder(List<ProcessAreaInfo> infos) {
        for (ProcessAreaInfo info : infos) {
            this.fProcessArea2Info.put((IItemHandle)info.getProcessArea(), (Object)info);
        }
        for (ProcessAreaInfo info : infos) {
            this.makeNode(info);
        }
    }

    public Node<IProcessArea> getRoot() {
        return this.fRoot;
    }

    private Node<IProcessArea> makeNode(ProcessAreaInfo info) {
        Node result = this.fProcessArea2Node.get(info);
        if (result != null) {
            return result;
        }
        Node<IProcessArea> parentNode = this.getParentNode(info);
        if (parentNode == null) {
            this.fRoot = result = new Node(null, (Object)info.getProcessArea());
        } else {
            result = new Node(parentNode, (Object)info.getProcessArea());
            parentNode.getChildren().add(result);
        }
        this.fProcessArea2Node.put(info, (Node<IProcessArea>)result);
        return result;
    }

    private Node<IProcessArea> getParentNode(ProcessAreaInfo info) {
        if (info.getParent() == null) {
            return null;
        }
        ProcessAreaInfo parentInfo = (ProcessAreaInfo)this.fProcessArea2Info.get((IItemHandle)info.getParent());
        if (parentInfo == null) {
            return null;
        }
        Node<IProcessArea> result = this.fProcessArea2Node.get(parentInfo);
        if (result != null) {
            return result;
        }
        return this.makeNode(parentInfo);
    }
}

