/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.client;

import com.ibm.icu.util.Calendar;
import com.ibm.team.apt.common.resource.IWorkLocationDefinition;
import com.ibm.team.apt.internal.client.IScheduleItem;
import com.ibm.team.apt.internal.client.OutOfOfficeItem;
import com.ibm.team.apt.internal.client.PlanDeltaBuilder;
import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.client.ResolvedPlan;
import com.ibm.team.apt.internal.client.testing.IItemSequenceManagerTestingAccessor;
import com.ibm.team.apt.internal.client.util.WorkItems;
import com.ibm.team.apt.internal.common.BookedTimeType;
import com.ibm.team.apt.internal.common.IBookedTime;
import com.ibm.team.apt.internal.common.IWorkHoursDefinition;
import com.ibm.team.apt.internal.common.Timespan;
import com.ibm.team.apt.internal.common.WorktimeScheduler;
import com.ibm.team.apt.internal.common.util.Dates;
import com.ibm.team.apt.internal.common.util.ItemSet;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.process.common.IIterationHandle;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.IWorkItemWorkingCopyManager;
import com.ibm.team.workitem.client.WorkItemChangeEvent;
import com.ibm.team.workitem.client.WorkflowUtilities;
import com.ibm.team.workitem.client.internal.WorkItemWorkingCopyImpl;
import com.ibm.team.workitem.client.internal.WorkingCopyRunnable;
import com.ibm.team.workitem.common.internal.model.WorkItem;
import com.ibm.team.workitem.common.internal.util.SequenceValue;
import com.ibm.team.workitem.common.model.ChangeDetails;
import com.ibm.team.workitem.common.model.IState;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.Identifier;
import com.ibm.team.workitem.common.workflow.IWorkflowInfo;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ItemSequenceManager {
    private static final Set<BookedTimeType> OUTOFOFFICE = Collections.singleton(BookedTimeType.OUT_OF_OFFICE);
    private ResolvedPlan fPlan;
    private List<PlanItem> fResolvedItems = new ArrayList<PlanItem>();
    private List<PlanItem> fScheduledItems = new ArrayList<PlanItem>();
    private Set<PlanItem> fInboxItems = new HashSet<PlanItem>();
    private ItemSet<IIteration> fPlannedIterations;
    private Map<PlanItem, Timespan> fSchedulingCache = new HashMap<PlanItem, Timespan>();
    private final ReadWriteLock fManagerLock = new ReentrantReadWriteLock();
    protected final Lock fReadLock = this.fManagerLock.readLock();
    protected final Lock fWriteLock = this.fManagerLock.writeLock();
    private WorktimeScheduler fWorktimeScheduler;
    private double fWorkAssignment;
    private Comparator<PlanItem> fUnresolvedSequenceComparator = new Comparator<PlanItem>(){

        @Override
        public int compare(PlanItem o1, PlanItem o2) {
            return o1.getSequenceValue().compareTo(o2.getSequenceValue());
        }
    };

    public ItemSequenceManager(ResolvedPlan plan) {
        this.fPlan = plan;
        this.fPlannedIterations = plan.getPlannedIterations();
    }

    public void initialize(final IWorkLocationDefinition workLocation, final int workAssignment, final IProgressMonitor monitor) throws TeamRepositoryException {
        Assert.isNotNull((Object)workLocation);
        this.runWriteLocked(null, new ModificationRequestRunnable(){

            @Override
            public List<Runnable> run() {
                monitor.beginTask("", 1);
                try {
                    ItemSequenceManager.this.updateWorkTime(workLocation, workAssignment);
                    for (PlanItem planItem : ItemSequenceManager.this.fetchPlanItems()) {
                        if (!ItemSequenceManager.this.isItemIncluded(planItem)) continue;
                        if (planItem.isResolved()) {
                            ItemSequenceManager.this.fResolvedItems.add(planItem);
                            continue;
                        }
                        if (!planItem.getSequenceValue().isNew()) {
                            ItemSequenceManager.this.fScheduledItems.add(planItem);
                            continue;
                        }
                        ItemSequenceManager.this.fInboxItems.add(planItem);
                    }
                    Collections.sort(ItemSequenceManager.this.fScheduledItems, ItemSequenceManager.this.fUnresolvedSequenceComparator);
                    ItemSequenceManager.this.updateSchedulingCache(null);
                    ItemSequenceManager.this.updateResolvedCache();
                }
                finally {
                    monitor.done();
                }
                return null;
            }
        });
    }

    private static Collection<OutOfOfficeItem> filterAbsences(Collection<OutOfOfficeItem> absences, Timespan span) {
        ArrayList<OutOfOfficeItem> result = new ArrayList<OutOfOfficeItem>(absences.size());
        for (OutOfOfficeItem absence : absences) {
            if (!span.contains(absence.getEnd()) && !span.contains(absence.getStart())) continue;
            result.add(absence);
        }
        return result;
    }

    public void dispose() {
        this.fWriteLock.lock();
        try {
            this.fPlan = null;
            this.fResolvedItems = null;
            this.fScheduledItems = null;
            this.fSchedulingCache = null;
            this.fWorktimeScheduler = null;
        }
        finally {
            this.fWriteLock.unlock();
        }
    }

    public abstract IContributorHandle getOwner();

    public IWorkHoursDefinition getWorkHourDefinition() {
        return this.fWorktimeScheduler;
    }

    public Date getWorkStart() {
        this.fReadLock.lock();
        try {
            Date date = this.isDisposed() ? null : this.fWorktimeScheduler.calculateWorkStart(this.fPlan.getReferenceTime(), OUTOFOFFICE);
            return date;
        }
        finally {
            this.fReadLock.unlock();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long calculateWorkTime(Date startDate, Date endDate) {
        this.fReadLock.lock();
        try {
            if (this.isDisposed()) {
                return 0L;
            }
            if (startDate == null) return 0L;
            if (endDate == null) return 0L;
            if (endDate.before(startDate)) {
                return 0L;
            }
            long l = this.fWorktimeScheduler.calcutateWorkingTime(new Timespan(startDate, endDate));
            return l;
        }
        finally {
            this.fReadLock.unlock();
        }
    }

    public long calculateRemainingWorkTime(IIteration targetIteration, boolean considerAssignment) {
        Date endDate = null;
        if (targetIteration != null && this.fPlannedIterations.contains((Object)targetIteration)) {
            endDate = targetIteration.getEndDate();
        }
        if (endDate == null) {
            this.fPlan.getEndDate();
        }
        long result = this.calculateRemainingWorkTime(endDate);
        if (considerAssignment) {
            result = (long)((double)result * this.fWorkAssignment);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long calculateRemainingWorkTime(Date endDate) {
        this.fReadLock.lock();
        try {
            if (this.isDisposed()) {
                return 0L;
            }
            Date startDate = this.fPlan.getStartDate();
            Date referenceTime = this.fPlan.getReferenceTime();
            if (startDate == null || startDate.before(referenceTime)) {
                startDate = referenceTime;
            }
            if (endDate == null) return 0L;
            if (endDate.before(startDate)) {
                return 0L;
            }
            long l = this.fWorktimeScheduler.calcutateWorkingTime(new Timespan(startDate, endDate));
            return l;
        }
        finally {
            this.fReadLock.unlock();
        }
    }

    public void executeLocked(Runnable code) {
        this.fReadLock.lock();
        try {
            code.run();
        }
        finally {
            this.fReadLock.unlock();
        }
    }

    public Collection<IScheduleItem> getAbsences() {
        this.fReadLock.lock();
        try {
            if (this.isDisposed()) {
                Set set = Collections.EMPTY_SET;
                return set;
            }
            Collection bookedTimes = this.fWorktimeScheduler.getBookedTime(Arrays.asList(BookedTimeType.OUT_OF_OFFICE));
            ArrayList<IScheduleItem> result = new ArrayList<IScheduleItem>(bookedTimes.size());
            for (IBookedTime bookedTime : bookedTimes) {
                result.add(this.getScheduledItem(bookedTime));
            }
            ArrayList<IScheduleItem> arrayList = result;
            return arrayList;
        }
        finally {
            this.fReadLock.unlock();
        }
    }

    /*
     * Unable to fully structure code
     */
    public IScheduleItem getCurrentItem() {
        this.fReadLock.lock();
        try {
            block12: {
                if (this.isDisposed()) lbl-1000:
                // 3 sources

                {
                    return null;
                }
                nextWorkDay = this.fWorktimeScheduler.calculateWorkStart(this.fPlan.getReferenceTime(), (Collection)Collections.EMPTY_SET);
                if (nextWorkDay.equals(this.fWorktimeScheduler.calculateWorkStart(this.fPlan.getReferenceTime()))) break block12;
                var3_2 = this.fWorktimeScheduler.getBookedTime().iterator();
                do {
                    if (!var3_2.hasNext()) ** GOTO lbl-1000
                } while (Dates.compareTo((Date)(bookedTime = (IBookedTime)var3_2.next()).getStart(), (Date)nextWorkDay) > 0 || Dates.compareTo((Date)bookedTime.getEnd(), (Date)nextWorkDay) <= 0 || (scheduledItem = this.getScheduledItem(bookedTime)) == null);
                var6_8 = scheduledItem;
                return var6_8;
            }
            if (!this.fScheduledItems.isEmpty()) {
                var6_9 = this.fScheduledItems.get(0);
                return var6_9;
            }
            var3_3 = this.fWorktimeScheduler.getBookedTime().iterator();
            do {
                if (var3_3.hasNext()) ** break;
                ** continue;
            } while ((scheduledItem = this.getScheduledItem(bookedTime = (IBookedTime)var3_3.next())) == null || scheduledItem.isResolved());
            var6_10 = scheduledItem;
            return var6_10;
        }
        finally {
            this.fReadLock.unlock();
        }
    }

    public List<IScheduleItem> getScheduleItems() {
        this.fReadLock.lock();
        try {
            if (this.isDisposed()) {
                List list = Collections.EMPTY_LIST;
                return list;
            }
            ArrayList<PlanItem> allItems = new ArrayList<PlanItem>(this.fResolvedItems.size() + this.fScheduledItems.size());
            allItems.addAll(this.fResolvedItems);
            allItems.addAll(this.fScheduledItems);
            List<IScheduleItem> list = Collections.unmodifiableList(allItems);
            return list;
        }
        finally {
            this.fReadLock.unlock();
        }
    }

    public int getInboxItemCount() {
        this.fReadLock.lock();
        try {
            if (this.isDisposed()) {
                return 0;
            }
            int n = this.fInboxItems.size();
            return n;
        }
        finally {
            this.fReadLock.unlock();
        }
    }

    public Collection<PlanItem> getInboxItems() {
        this.fReadLock.lock();
        try {
            if (this.isDisposed()) {
                Set set = Collections.EMPTY_SET;
                return set;
            }
            Collection<PlanItem> collection = Collections.unmodifiableCollection(this.fInboxItems);
            return collection;
        }
        finally {
            this.fReadLock.unlock();
        }
    }

    public int getResolvedItemCount() {
        this.fReadLock.lock();
        try {
            if (this.isDisposed()) {
                return 0;
            }
            int n = this.fResolvedItems.size();
            return n;
        }
        finally {
            this.fReadLock.unlock();
        }
    }

    public List<PlanItem> getResolvedItems() {
        this.fReadLock.lock();
        try {
            if (this.isDisposed()) {
                List list = Collections.EMPTY_LIST;
                return list;
            }
            ArrayList<PlanItem> resolvedItems = new ArrayList<PlanItem>(this.fResolvedItems);
            Collections.reverse(resolvedItems);
            List<PlanItem> list = Collections.unmodifiableList(resolvedItems);
            return list;
        }
        finally {
            this.fReadLock.unlock();
        }
    }

    public List<PlanItem> getScheduledItems() {
        this.fReadLock.lock();
        try {
            if (this.isDisposed()) {
                List list = Collections.EMPTY_LIST;
                return list;
            }
            List<PlanItem> list = Collections.unmodifiableList(this.fScheduledItems);
            return list;
        }
        finally {
            this.fReadLock.unlock();
        }
    }

    public int getScheduledItemCount() {
        this.fReadLock.lock();
        try {
            if (this.isDisposed()) {
                return 0;
            }
            int n = this.fScheduledItems.size();
            return n;
        }
        finally {
            this.fReadLock.unlock();
        }
    }

    public int getIndexOf(PlanItem item) {
        this.fReadLock.lock();
        try {
            if (this.isDisposed()) {
                throw new NoSuchElementException();
            }
            boolean resolved = item.isResolved();
            List<PlanItem> list = resolved ? this.fResolvedItems : this.fScheduledItems;
            int result = list.indexOf(item);
            if (result == -1) {
                throw new NoSuchElementException();
            }
            int n = resolved ? -result - 1 : result;
            return n;
        }
        finally {
            this.fReadLock.unlock();
        }
    }

    public PlanItem getAt(int chronologicalIndex) {
        this.fReadLock.lock();
        try {
            if (this.isDisposed()) {
                return null;
            }
            if (chronologicalIndex >= 0) {
                PlanItem planItem = this.fScheduledItems.get(chronologicalIndex);
                return planItem;
            }
            PlanItem planItem = this.fResolvedItems.get(-chronologicalIndex - 1);
            return planItem;
        }
        finally {
            this.fReadLock.unlock();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PlanItem findAt(Date when) {
        this.fReadLock.lock();
        try {
            if (this.isDisposed()) {
                return null;
            }
            if (this.fScheduledItems.size() > 0) {
                PlanItem firstItem = this.fScheduledItems.get(0);
                if (this.fSchedulingCache.get(firstItem).getStart().after(when)) {
                    PlanItem planItem = firstItem;
                    return planItem;
                }
                PlanItem lastItem = this.fScheduledItems.get(this.fScheduledItems.size() - 1);
                if (this.fSchedulingCache.get(lastItem).getEnd().before(when)) {
                    PlanItem planItem = lastItem;
                    return planItem;
                }
            }
            int low = 0;
            int high = this.fScheduledItems.size() - 1;
            while (low <= high) {
                int mid = low + high >> 1;
                PlanItem value = this.fScheduledItems.get(mid);
                Timespan scheduledTime = this.fSchedulingCache.get(value);
                if (scheduledTime.contains(when)) {
                    PlanItem planItem = value;
                    return planItem;
                }
                if (scheduledTime.getStart().after(when)) {
                    high = mid - 1;
                    continue;
                }
                Assert.isTrue((scheduledTime.getEnd().equals(when) || scheduledTime.getEnd().before(when) ? 1 : 0) != 0);
                low = mid + 1;
            }
            return null;
        }
        finally {
            this.fReadLock.unlock();
        }
    }

    public void unschedule(final PlanItem item, final boolean setAccepted) {
        this.runWriteLocked(item, new ModificationRequestRunnable(){

            @Override
            public List<Runnable> run() {
                if (ItemSequenceManager.this.isDisposed() || !ItemSequenceManager.this.getOwner().sameItemId((IItemHandle)item.getOwner())) {
                    return null;
                }
                Assert.isLegal((ItemSequenceManager.this.getPlan() == item.getPlan() ? 1 : 0) != 0);
                ItemSequenceManager.this.doUnschedule(item, setAccepted, true);
                return null;
            }
        });
    }

    public void schedule(final PlanItem item) {
        this.runWriteLocked(item, new ModificationRequestRunnable(){

            @Override
            public List<Runnable> run() {
                if (ItemSequenceManager.this.isDisposed() || !ItemSequenceManager.this.getOwner().sameItemId((IItemHandle)item.getOwner())) {
                    return null;
                }
                Assert.isLegal((ItemSequenceManager.this.getPlan() == item.getPlan() ? 1 : 0) != 0);
                if (!ItemSequenceManager.this.isItemIncluded(item)) {
                    return null;
                }
                return ItemSequenceManager.this.doSchedule(item, true);
            }
        });
    }

    public void schedule(final PlanItem item, final PlanItem before, final PlanItem after) {
        this.runWriteLocked(item, new ModificationRequestRunnable(){

            @Override
            public List<Runnable> run() {
                if (ItemSequenceManager.this.isDisposed() || !ItemSequenceManager.this.getOwner().sameItemId((IItemHandle)item.getOwner())) {
                    return null;
                }
                Assert.isLegal((ItemSequenceManager.this.getPlan() == item.getPlan() ? 1 : 0) != 0);
                Assert.isLegal((item != before && item != after && before != after ? 1 : 0) != 0);
                if (!ItemSequenceManager.this.isItemIncluded(item)) {
                    return null;
                }
                return ItemSequenceManager.this.doScheduleSpecific(item, before, after, true);
            }
        });
    }

    public void schedule(final PlanItem item, final Date when) {
        this.runWriteLocked(item, new ModificationRequestRunnable(){

            @Override
            public List<Runnable> run() {
                if (ItemSequenceManager.this.isDisposed() || !ItemSequenceManager.this.getOwner().sameItemId((IItemHandle)item.getOwner())) {
                    return null;
                }
                Assert.isLegal((ItemSequenceManager.this.getPlan() == item.getPlan() ? 1 : 0) != 0);
                Assert.isLegal((!when.before(ItemSequenceManager.this.fPlan.getReferenceTime()) ? 1 : 0) != 0);
                if (!ItemSequenceManager.this.isItemIncluded(item)) {
                    return null;
                }
                ItemSequenceManager.this.removeOldScheduling(item);
                PlanItem candidate = ItemSequenceManager.this.findAt(when);
                PlanItem before = null;
                PlanItem after = null;
                if (candidate == null && ItemSequenceManager.this.fScheduledItems.size() > 0) {
                    before = (PlanItem)ItemSequenceManager.this.fScheduledItems.get(ItemSequenceManager.this.fScheduledItems.size() - 1);
                } else if (candidate != null) {
                    Timespan timespan = (Timespan)ItemSequenceManager.this.fSchedulingCache.get(candidate);
                    if (when.getTime() - timespan.getStart().getTime() < timespan.getEnd().getTime() - when.getTime()) {
                        after = candidate;
                    } else {
                        before = candidate;
                    }
                }
                if (after != null || before != null) {
                    return ItemSequenceManager.this.doScheduleSpecific(item, before, after, true);
                }
                return ItemSequenceManager.this.doSchedule(item, true);
            }
        });
    }

    protected void updateReferenceTime() {
        this.runWriteLocked(null, new ModificationRequestRunnable(){

            @Override
            public List<Runnable> run() {
                if (!ItemSequenceManager.this.isDisposed()) {
                    ItemSequenceManager.this.updateSchedulingCache(null);
                    ItemSequenceManager.this.updateResolvedCache();
                }
                return null;
            }
        });
    }

    protected void updateWorkTime(final IWorkLocationDefinition workLocation, final int workAssignment) {
        Assert.isNotNull((Object)workLocation);
        this.runWriteLocked(null, new ModificationRequestRunnable(){

            @Override
            public List<Runnable> run() {
                if (!ItemSequenceManager.this.isDisposed()) {
                    ItemSequenceManager.this.fWorktimeScheduler = new WorktimeScheduler(workLocation);
                    ItemSequenceManager.this.fWorkAssignment = (double)workAssignment / 100.0;
                    Timespan plannedTimespan = ItemSequenceManager.this.fPlan.getPlannedTimespan();
                    if (plannedTimespan != null) {
                        if (plannedTimespan.getEnd() != null) {
                            Calendar calendar = Calendar.getInstance();
                            calendar.setTimeInMillis(plannedTimespan.getEnd().getTime());
                            calendar.add(2, 2);
                            plannedTimespan = new Timespan(plannedTimespan.getStart(), new Date(calendar.getTimeInMillis()));
                        }
                        for (OutOfOfficeItem absence : ItemSequenceManager.filterAbsences(ItemSequenceManager.this.fetchAbsences(), plannedTimespan)) {
                            ItemSequenceManager.this.fWorktimeScheduler.addBookedTime((IBookedTime)absence);
                        }
                    }
                    ItemSequenceManager.this.updateResolvedCache();
                    ItemSequenceManager.this.updateSchedulingCache(null);
                }
                return null;
            }
        });
    }

    protected Timespan getScheduledTime(IScheduleItem item) {
        if (item instanceof PlanItem) {
            PlanItem planItem = (PlanItem)item;
            if (!this.isItemIncluded(planItem)) {
                return null;
            }
            this.fReadLock.lock();
            try {
                Timespan timespan = this.isDisposed() ? null : this.fSchedulingCache.get(planItem);
                return timespan;
            }
            finally {
                this.fReadLock.unlock();
            }
        }
        if (item instanceof OutOfOfficeItem) {
            OutOfOfficeItem outOfOfficeItem = (OutOfOfficeItem)item;
            return new Timespan(outOfOfficeItem.getStart(), outOfOfficeItem.getEnd());
        }
        throw new IllegalArgumentException();
    }

    protected void itemAdded(final PlanItem item) {
        if (!this.isItemIncluded(item)) {
            return;
        }
        this.runWriteLocked(item, new ModificationRequestRunnable(){

            @Override
            public List<Runnable> run() {
                if (!ItemSequenceManager.this.isDisposed()) {
                    ItemSequenceManager.this.removeOldScheduling(item);
                    if (item.isResolved()) {
                        ItemSequenceManager.this.fResolvedItems.add(item);
                        ItemSequenceManager.this.updateResolvedCache();
                    } else {
                        ItemSequenceManager.this.doAddToScheduling(item);
                        ItemSequenceManager.this.updateSchedulingCache(item);
                    }
                }
                return null;
            }
        });
    }

    protected void itemRemoved(final PlanItem item) {
        this.runWriteLocked(item, new ModificationRequestRunnable(){

            @Override
            public List<Runnable> run() {
                if (!ItemSequenceManager.this.isDisposed()) {
                    ItemSequenceManager.this.removeOldScheduling(item);
                }
                return null;
            }
        });
    }

    protected void processWorkItemChangeEvent(final PlanItem planItem, final WorkItemChangeEvent event) {
        this.runWriteLocked(planItem, new ModificationRequestRunnable(){

            @Override
            public List<Runnable> run() {
                if (!ItemSequenceManager.this.isDisposed()) {
                    IWorkflowInfo wfInfo;
                    ChangeDetails targetChange = (ChangeDetails)event.getAttributeChangeDetails(IWorkItem.TARGET_PROPERTY, ChangeDetails.class);
                    if (targetChange != null) {
                        boolean isOldTargetIncluded = ItemSequenceManager.this.isTargetIncluded((IIterationHandle)targetChange.getOldValue());
                        boolean isNewTargetIncluded = ItemSequenceManager.this.isTargetIncluded((IIterationHandle)targetChange.getNewValue());
                        if (isOldTargetIncluded && !isNewTargetIncluded) {
                            ItemSequenceManager.this.itemRemoved(planItem);
                            return null;
                        }
                        if (!isOldTargetIncluded && isNewTargetIncluded) {
                            ItemSequenceManager.this.itemAdded(planItem);
                            return null;
                        }
                    }
                    if (!ItemSequenceManager.this.isItemIncluded(planItem)) {
                        return null;
                    }
                    boolean schedulingChanged = false;
                    PlanItem firstItemToRefresh = planItem;
                    Assert.isLegal((boolean)planItem.getWorkItemHandle().sameItemId((IItemHandle)event.getWorkItem()));
                    IWorkItem workItem = event.getWorkItem();
                    if (event.affects(IWorkItem.STATE_PROPERTY) && (wfInfo = WorkflowUtilities.findCachedWorkflowInfo((IWorkItem)workItem)) != null) {
                        ChangeDetails stateChange = (ChangeDetails)event.getAttributeChangeDetails(IWorkItem.STATE_PROPERTY);
                        Identifier<IState> oldState = WorkItems.createState((String)stateChange.getOldValue());
                        Identifier<IState> newState = WorkItems.createState((String)stateChange.getNewValue());
                        if (oldState == null) {
                            schedulingChanged = true;
                        } else if (ItemSequenceManager.this.changedToState(wfInfo, 5, (Identifier<IState>)oldState, (Identifier<IState>)newState)) {
                            ItemSequenceManager.this.fResolvedItems.remove(planItem);
                            ItemSequenceManager.this.doUnschedule(planItem, false, true);
                            schedulingChanged = true;
                        } else if (ItemSequenceManager.this.changedToState(wfInfo, 4, (Identifier<IState>)oldState, (Identifier<IState>)newState)) {
                            schedulingChanged = true;
                        } else if (ItemSequenceManager.this.changedToState(wfInfo, 2, (Identifier<IState>)oldState, (Identifier<IState>)newState)) {
                            ItemSequenceManager.this.removeOldScheduling(planItem);
                            ItemSequenceManager.this.fResolvedItems.add(planItem);
                            schedulingChanged = true;
                        }
                    }
                    if (event.affects(WorkItem.DURATION_PROPERTY) || event.affects(WorkItem.CORRECTED_ESTIMATE_PROPERTY) || event.affects(WorkItem.TIME_SPENT_PROPERTY) || event.affects(IWorkItem.DUE_DATE_PROPERTY)) {
                        schedulingChanged = true;
                    }
                    if (event.affects(WorkItem.START_DATE_PROPERTY)) {
                        schedulingChanged = true;
                        ItemSequenceManager.this.removeOldScheduling(planItem);
                        ItemSequenceManager.this.doAddToScheduling(planItem);
                        firstItemToRefresh = null;
                    }
                    if (event.affects(WorkItem.SEQUENCE_VALUE_PROPERTY)) {
                        int insertionIndex;
                        int oldIndex = ItemSequenceManager.this.fScheduledItems.indexOf(planItem);
                        if (oldIndex != -1) {
                            ItemSequenceManager.this.fScheduledItems.remove(planItem);
                            schedulingChanged = true;
                        }
                        if (ItemSequenceManager.this.fInboxItems.remove(planItem)) {
                            Assert.isTrue((oldIndex == -1 ? 1 : 0) != 0);
                            schedulingChanged = true;
                        }
                        schedulingChanged |= (insertionIndex = ItemSequenceManager.this.doAddToScheduling(planItem)) != -1;
                        if (firstItemToRefresh != null && oldIndex != -1 && (insertionIndex == -1 || oldIndex < insertionIndex)) {
                            PlanItem planItem2 = firstItemToRefresh = oldIndex < ItemSequenceManager.this.fScheduledItems.size() ? (PlanItem)ItemSequenceManager.this.fScheduledItems.get(oldIndex) : null;
                        }
                    }
                    if (schedulingChanged) {
                        ItemSequenceManager.this.updateSchedulingCache(firstItemToRefresh);
                        ItemSequenceManager.this.updateResolvedCache();
                    }
                }
                return null;
            }
        });
    }

    protected SequenceValue getLastSequenceValue() {
        this.fReadLock.lock();
        try {
            if (this.isDisposed() || this.fScheduledItems.isEmpty()) {
                SequenceValue sequenceValue = SequenceValue.INITIAL;
                return sequenceValue;
            }
            SequenceValue sequenceValue = this.fScheduledItems.get(this.fScheduledItems.size() - 1).getSequenceValue();
            return sequenceValue;
        }
        finally {
            this.fReadLock.unlock();
        }
    }

    protected abstract Collection<PlanItem> fetchPlanItems();

    protected abstract Collection<OutOfOfficeItem> fetchAbsences();

    protected ResolvedPlan getPlan() {
        return this.fPlan;
    }

    private IScheduleItem getScheduledItem(IBookedTime bookedTime) {
        if (bookedTime instanceof IScheduleItem) {
            return (IScheduleItem)bookedTime;
        }
        return null;
    }

    private void doUnschedule(PlanItem subject, boolean setAccepted, boolean saveSequenceValue) {
        SequenceValue sequenceValue;
        SequenceValue sequenceValue2 = sequenceValue = setAccepted ? SequenceValue.FACTORY.successor(this.getLastSequenceValue()) : SequenceValue.NEW;
        if (this.isItemIncluded(subject)) {
            this.removeOldScheduling(subject);
            this.fInboxItems.add(subject);
        }
        subject.setSequenceValue(sequenceValue, saveSequenceValue);
        this.updateSchedulingCache(null);
    }

    private List<Runnable> doSchedule(PlanItem planItem, boolean saveSequenceValue) {
        this.removeOldScheduling(planItem);
        PlanItem before = null;
        PlanItem after = null;
        int searchPos = this.fScheduledItems.size();
        if (planItem.getDueDate() != null) {
            while (searchPos > 0) {
                Timespan scheduledTime = this.fSchedulingCache.get(this.fScheduledItems.get(searchPos - 1));
                if (scheduledTime.getEnd().after(planItem.getDueDate())) break;
                --searchPos;
            }
        }
        if (searchPos > 0) {
            before = this.fScheduledItems.get(searchPos - 1);
        }
        if (searchPos < this.fScheduledItems.size()) {
            after = this.fScheduledItems.get(searchPos);
        }
        return this.doScheduleSpecific(planItem, before, after, saveSequenceValue);
    }

    List<Runnable> doScheduleSpecific(PlanItem subject, PlanItem predecessor, PlanItem successor, boolean saveSequenceValue) {
        SequenceValue successorValue;
        int predecessorIndex;
        this.removeOldScheduling(subject);
        Assert.isLegal((predecessor == null || predecessor.getPlan() == subject.getPlan() ? 1 : 0) != 0);
        Assert.isLegal((successor == null || successor.getPlan() == subject.getPlan() ? 1 : 0) != 0);
        if (successor != null && predecessor == null) {
            int successorIndex = this.fScheduledItems.indexOf(successor);
            if (successorIndex > 0) {
                predecessor = this.fScheduledItems.get(successorIndex - 1);
            }
        } else if (predecessor != null && successor == null && (predecessorIndex = this.fScheduledItems.indexOf(predecessor)) != -1 && predecessorIndex < this.fScheduledItems.size() - 1) {
            successor = this.fScheduledItems.get(predecessorIndex + 1);
        }
        List<PlanItem> toSchedule = null;
        SequenceValue predecessorValue = predecessor != null ? predecessor.getSequenceValue() : null;
        SequenceValue sequenceValue = successorValue = successor != null ? successor.getSequenceValue() : null;
        if (predecessorValue != null && successorValue != null && predecessorValue.compareTo(successorValue) == 0) {
            SequenceValue previousValue;
            toSchedule = new ArrayList<PlanItem>();
            int i = this.fScheduledItems.indexOf(predecessor);
            while (i >= 0) {
                previousValue = predecessorValue;
                predecessor = this.fScheduledItems.get(i);
                if (previousValue.compareTo(predecessorValue = predecessor.getSequenceValue()) != 0) break;
                toSchedule.add(predecessor);
                --i;
            }
            Collections.reverse(toSchedule);
            toSchedule.add(subject);
            i = this.fScheduledItems.indexOf(successor);
            while (i >= 0 && i < this.fScheduledItems.size()) {
                previousValue = successorValue;
                successor = this.fScheduledItems.get(i);
                if (previousValue.compareTo(successorValue = successor.getSequenceValue()) != 0) break;
                toSchedule.add(successor);
                ++i;
            }
            Assert.isTrue((predecessorValue == null || successorValue == null || predecessorValue.compareTo(successorValue) != 0 ? 1 : 0) != 0);
        } else {
            toSchedule = Collections.singletonList(subject);
        }
        for (PlanItem planItem : toSchedule) {
            this.removeOldScheduling(planItem);
        }
        ArrayList<Runnable> modificationRequests = new ArrayList<Runnable>();
        this.doSetSequenceValues(toSchedule, predecessorValue, successorValue, 0, toSchedule.size() - 1, saveSequenceValue, modificationRequests);
        int insertAfter = predecessorValue != null ? this.fScheduledItems.indexOf(predecessor) + 1 : 0;
        this.fScheduledItems.addAll(insertAfter, toSchedule);
        this.updateSchedulingCache(toSchedule.get(0));
        return modificationRequests;
    }

    private void doSetSequenceValues(List<PlanItem> toSchedule, SequenceValue predecessorValue, SequenceValue successorValue, int lowIndex, int highIndex, final boolean saveSequenceValue, List<Runnable> modificationRequests) {
        int midIndex = lowIndex + highIndex >> 1;
        final PlanItem midItem = toSchedule.get(midIndex);
        SequenceValue midValue = SequenceValue.INITIAL;
        if (predecessorValue != null && !predecessorValue.isNew() && successorValue != null && !successorValue.isNew()) {
            midValue = SequenceValue.FACTORY.between(predecessorValue, successorValue);
        } else if (predecessorValue == null && successorValue != null && !successorValue.isNew()) {
            midValue = SequenceValue.FACTORY.predecessor(successorValue);
        } else if (predecessorValue != null && !predecessorValue.isNew() && successorValue == null) {
            midValue = SequenceValue.FACTORY.successor(predecessorValue);
        }
        final SequenceValue finalMidValue = midValue;
        modificationRequests.add(new Runnable(){

            public void run() {
                midItem.setSequenceValue(finalMidValue, saveSequenceValue);
            }
        });
        if (lowIndex < midIndex) {
            this.doSetSequenceValues(toSchedule, predecessorValue, midValue, lowIndex, midIndex - 1, saveSequenceValue, modificationRequests);
        }
        if (midIndex < highIndex) {
            this.doSetSequenceValues(toSchedule, midValue, successorValue, midIndex + 1, highIndex, saveSequenceValue, modificationRequests);
        }
    }

    private void updateSchedulingCache(PlanItem firstItem) {
        PlanDeltaBuilder builder = this.fPlan.connectDeltaBuilder();
        try {
            Timespan oldValue;
            int i;
            int n = i = firstItem != null ? this.fScheduledItems.indexOf(firstItem) : 0;
            if (i == -1) {
                i = 0;
            }
            Timespan predecessor = i > 0 ? this.fSchedulingCache.get(this.fScheduledItems.get(i - 1)) : null;
            Date nextStart = predecessor != null ? predecessor.getEnd() : this.getSchedulingReferenceTime();
            while (i < this.fScheduledItems.size()) {
                Timespan newValue;
                PlanItem planItem = this.fScheduledItems.get(i);
                oldValue = this.fSchedulingCache.put(planItem, newValue = this.fWorktimeScheduler.calculateTimeSpan(nextStart, planItem.getDuration().getDuration(), true));
                if (oldValue == null || !oldValue.equals((Object)newValue)) {
                    builder.changed(planItem, PlanItem.SCHEDULED_TIME, oldValue, newValue);
                }
                nextStart = newValue.getEnd();
                ++i;
            }
            for (PlanItem planItem : this.fInboxItems) {
                oldValue = this.fSchedulingCache.put(planItem, null);
                if (oldValue == null) continue;
                builder.changed(planItem, PlanItem.SCHEDULED_TIME, oldValue, null);
            }
        }
        finally {
            this.fPlan.disconnectDeltaBuilder();
        }
    }

    private void updateResolvedCache() {
        PlanDeltaBuilder builder = this.fPlan.connectDeltaBuilder();
        try {
            Collections.sort(this.fResolvedItems, new Comparator<PlanItem>(){

                @Override
                public int compare(PlanItem o1, PlanItem o2) {
                    Timestamp t1 = o1.getResolutionDate();
                    Timestamp t2 = o2.getResolutionDate();
                    if (t1 != null && t2 != null) {
                        return Dates.compareTo((Date)t1, (Date)t2);
                    }
                    if (t1 == null && t2 == null) {
                        return o1.getSequenceValue().compareTo(o2.getSequenceValue());
                    }
                    return (t1 == null ? 1 : 0) - (t2 == null ? 1 : 0);
                }
            });
            Date thisItemEndTime = this.fPlan.getReferenceTime();
            int i = this.fResolvedItems.size() - 1;
            while (i >= 0) {
                PlanItem previousItem;
                Timestamp previousItemResolutionDate;
                PlanItem planItem = this.fResolvedItems.get(i);
                Timestamp resolutionDate = planItem.getResolutionDate();
                if (resolutionDate != null) {
                    thisItemEndTime = resolutionDate;
                }
                Timespan newValue = this.fWorktimeScheduler.calculateTimeSpan(thisItemEndTime, planItem.getDuration().getDuration(), false);
                if (i > 0 && (previousItemResolutionDate = (previousItem = this.fResolvedItems.get(i - 1)).getResolutionDate()) != null && newValue.getStart().before(previousItemResolutionDate)) {
                    newValue = new Timespan((Date)previousItemResolutionDate, thisItemEndTime);
                }
                Assert.isNotNull((Object)newValue);
                Timespan oldValue = this.fSchedulingCache.put(planItem, newValue);
                if (oldValue == null || !oldValue.equals((Object)newValue)) {
                    builder.changed(planItem, PlanItem.SCHEDULED_TIME, oldValue, newValue);
                }
                thisItemEndTime = newValue.getEnd();
                --i;
            }
        }
        finally {
            this.fPlan.disconnectDeltaBuilder();
        }
    }

    private void removeOldScheduling(PlanItem planItem) {
        PlanDeltaBuilder builder = this.fPlan.connectDeltaBuilder();
        try {
            int scheduledIndex = this.fScheduledItems.indexOf(planItem);
            if (scheduledIndex != -1) {
                Assert.isTrue((!this.fInboxItems.contains(planItem) ? 1 : 0) != 0);
                this.fScheduledItems.remove(planItem);
                Timespan oldValue = this.fSchedulingCache.remove(planItem);
                if (oldValue != null) {
                    builder.changed(planItem, PlanItem.SCHEDULED_TIME, oldValue, null);
                }
                if (scheduledIndex < this.fScheduledItems.size()) {
                    this.updateSchedulingCache(this.fScheduledItems.get(scheduledIndex));
                }
            } else {
                this.fInboxItems.remove(planItem);
            }
        }
        finally {
            this.fPlan.disconnectDeltaBuilder();
        }
    }

    private int doAddToScheduling(PlanItem planItem) {
        int result = -1;
        if (!planItem.getSequenceValue().isNew()) {
            result = Collections.binarySearch(this.fScheduledItems, planItem, this.fUnresolvedSequenceComparator);
            if (result < 0) {
                result = -result - 1;
            }
            result = Math.min(this.fScheduledItems.size(), result);
            this.fScheduledItems.add(result, planItem);
        } else {
            this.fInboxItems.add(planItem);
        }
        return result;
    }

    private Date getSchedulingReferenceTime() {
        Date now = this.fPlan.getReferenceTime();
        if (this.fPlan.getStartDate() != null && now.before(this.fPlan.getStartDate())) {
            now = this.fPlan.getStartDate();
        }
        return now;
    }

    private boolean changedToState(IWorkflowInfo info, int stateGroups, Identifier<IState> oldState, Identifier<IState> newState) {
        return !info.stateGroupContains(stateGroups, oldState) && info.stateGroupContains(stateGroups, newState);
    }

    private boolean isItemIncluded(PlanItem item) {
        return this.isTargetIncluded((IIterationHandle)item.getTarget());
    }

    private boolean isTargetIncluded(IIterationHandle target) {
        return target != null && this.fPlannedIterations.contains((Object)target);
    }

    private boolean isDisposed() {
        return this.fPlan == null;
    }

    private void runWriteLocked(PlanItem planItem, final ModificationRequestRunnable code) {
        IWorkItemHandle workItemHandle;
        IWorkItemHandle iWorkItemHandle = workItemHandle = planItem != null ? planItem.getWorkItemHandle() : null;
        if (workItemHandle != null) {
            WorkItemWorkingCopyImpl workItemWorkingCopy = (WorkItemWorkingCopyImpl)planItem.getWorkItemWorkingCopy(false);
            workItemWorkingCopy.run(this.fWriteLock, (WorkingCopyRunnable)new WorkingCopyRunnable<Void>(){
                IWorkItemWorkingCopyManager workingCopyManager = null;
                boolean gotDeltaBuilder = false;
                boolean gotCompoundChange = false;
                ResolvedPlan plan = null;
                private List<Runnable> fModificationRequests;

                public Void run() {
                    if (!ItemSequenceManager.this.isDisposed()) {
                        this.plan = ItemSequenceManager.this.fPlan;
                        this.plan.connectDeltaBuilder();
                        this.gotDeltaBuilder = true;
                        this.workingCopyManager = ItemSequenceManager.this.fPlan.getWorkingCopyManager(true);
                        this.workingCopyManager.beginCompoundWorkItemChange(workItemHandle);
                        this.gotCompoundChange = true;
                        this.fModificationRequests = code.run();
                    }
                    return null;
                }

                public void runFinally() {
                    try {
                        if (this.fModificationRequests != null) {
                            for (Runnable modificationRequest : this.fModificationRequests) {
                                modificationRequest.run();
                            }
                        }
                    }
                    finally {
                        try {
                            if (this.gotCompoundChange) {
                                this.workingCopyManager.endCompoundWorkItemChange(workItemHandle);
                            }
                        }
                        finally {
                            if (this.gotDeltaBuilder) {
                                this.plan.disconnectDeltaBuilder();
                            }
                        }
                    }
                }
            });
        } else {
            boolean gotDeltaBuilder = false;
            ResolvedPlan plan = null;
            this.fWriteLock.lock();
            try {
                if (!this.isDisposed()) {
                    plan = this.fPlan;
                    plan.connectDeltaBuilder();
                    gotDeltaBuilder = true;
                    code.run();
                }
            }
            finally {
                this.fWriteLock.unlock();
                if (gotDeltaBuilder) {
                    plan.disconnectDeltaBuilder();
                }
            }
        }
    }

    public IItemSequenceManagerTestingAccessor getTestingAccessor() {
        return new IItemSequenceManagerTestingAccessor(){

            public WorktimeScheduler getWorktimeScheduler() {
                return ItemSequenceManager.this.fWorktimeScheduler;
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface ModificationRequestRunnable {
        public List<Runnable> run();
    }
}

