/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.connector.cq.teamapi71;

import com.ibm.rational.connector.cq.teamapi.common.ICqAction;
import com.ibm.rational.connector.cq.teamapi.common.ICqExportData;
import com.ibm.rational.connector.cq.teamapi.common.ICqFieldDefinition;
import com.ibm.rational.connector.cq.teamapi.common.ICqLocation;
import com.ibm.rational.connector.cq.teamapi.common.ICqObject;
import com.ibm.rational.connector.cq.teamapi.common.ICqProvider;
import com.ibm.rational.connector.cq.teamapi.common.ICqQuery;
import com.ibm.rational.connector.cq.teamapi.common.ICqRecordType;
import com.ibm.rational.connector.cq.teamapi.common.ICqRowData;
import com.ibm.rational.connector.cq.teamapi.common.PseudoCqFieldDefinition;
import com.ibm.rational.connector.cq.teamapi.common.internal.CqExportAttachmentData;
import com.ibm.rational.connector.cq.teamapi.common.internal.CqExportData;
import com.ibm.rational.connector.cq.teamapi.common.internal.CqGatewayConstants;
import com.ibm.rational.connector.cq.teamapi.common.internal.FormXMLParser;
import com.ibm.rational.connector.cq.teamapi.common.internal.InteropProperties;
import com.ibm.rational.connector.cq.teamapi.common.internal.LogFactory;
import com.ibm.rational.connector.cq.teamapi71.CqActionForInterop71;
import com.ibm.rational.connector.cq.teamapi71.CqFieldDefinitionForInterop71;
import com.ibm.rational.connector.cq.teamapi71.CqProviderForInterop71;
import com.ibm.rational.connector.cq.teamapi71.CqRowDataForInterop71;
import com.ibm.rational.connector.cq.teamapi71.InteropWvcmException71;
import com.ibm.rational.connector.cq.teamapi71.Messages;
import com.ibm.rational.wvcm.stp.StpLocation;
import com.ibm.rational.wvcm.stp.StpResource;
import com.ibm.rational.wvcm.stp.cq.CqAction;
import com.ibm.rational.wvcm.stp.cq.CqAttachment;
import com.ibm.rational.wvcm.stp.cq.CqAttachmentFolder;
import com.ibm.rational.wvcm.stp.cq.CqContextResource;
import com.ibm.rational.wvcm.stp.cq.CqFieldDefinition;
import com.ibm.rational.wvcm.stp.cq.CqFieldValue;
import com.ibm.rational.wvcm.stp.cq.CqProvider;
import com.ibm.rational.wvcm.stp.cq.CqQuery;
import com.ibm.rational.wvcm.stp.cq.CqRecord;
import com.ibm.rational.wvcm.stp.cq.CqRecordType;
import com.ibm.rational.wvcm.stp.cq.CqResource;
import com.ibm.rational.wvcm.stp.cq.CqResultSet;
import com.ibm.rational.wvcm.stp.cq.CqRowData;
import com.ibm.rational.wvcm.stp.cqex.CqExForm;
import com.ibm.rational.wvcm.stp.cqex.CqExRecordType;
import com.ibm.team.interop.service.managers.clearquest.common.CQInteropConstants;
import com.ibm.team.interop.service.managers.clearquest.common.InteropException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wvcm.Feedback;
import javax.wvcm.PropertyNameList;
import javax.wvcm.PropertyRequestItem;
import javax.wvcm.ResourceList;
import javax.wvcm.WvcmException;
import org.apache.commons.logging.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CqRecordTypeForInterop71
implements ICqRecordType {
    private List<ICqFieldDefinition> m_fieldDefinitions;
    private List<ICqFieldDefinition> m_properties;
    private CqExRecordType m_delegate = null;
    private String m_uri;
    private CqProviderForInterop71 m_provider;
    private List<String> m_fieldOrderSubmit = null;
    private List<String> m_fieldOrderModify = null;
    private List<String> m_fieldOrderFromProperties = null;
    private ICqAction m_defaultModifyAction = null;
    protected Log m_logDetail = LogFactory.getLog((int)2);
    private static List<String> defaultSyncableRecordTypes = Arrays.asList("attachments", "users");
    private static final PropertyRequestItem.PropertyRequest formProperties = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{StpResource.DISPLAY_NAME, CqExRecordType.MODIFY_FORM.nest(new PropertyRequestItem[]{new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{CqExForm.FORM_DATA_AS_XML})}), CqExRecordType.SUBMIT_FORM.nest(new PropertyRequestItem[]{new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{CqExForm.FORM_DATA_AS_XML})})});
    private static CqQuery.ListOptions COUNT_ROWS = new CqQuery.ListOptionsClass(){

        public Boolean getEnableRowCount() {
            return Boolean.TRUE;
        }
    };
    private static final PropertyRequestItem.PropertyRequest recordProperties = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{CqRecord.RECORD_TYPE.nest(new PropertyRequestItem[]{new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{StpResource.DISPLAY_NAME})})});
    private static final PropertyRequestItem.PropertyRequest originalRecordProperties = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{CqRecord.ORIGINAL_ID, CqRecord.DUPLICATES.nest(new PropertyRequestItem[]{new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{CqRecord.DISPLAY_NAME})})});
    private static final PropertyRequestItem.PropertyRequest attachmentProperties = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{CqRecord.ATTACHMENT_FOLDERS.nest(new PropertyRequestItem[]{new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{CqAttachmentFolder.ATTACHMENT_LIST.nest(new PropertyRequestItem[]{new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{CqAttachment.DISPLAY_NAME, CqAttachment.FILE_NAME, CqAttachment.FILE_SIZE, CqAttachment.DESCRIPTION, CqAttachment.FIELD})}), CqAttachmentFolder.FIELD})})});
    private static final PropertyRequestItem.PropertyRequest nestedPropertyNames = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{StpResource.DISPLAY_NAME, StpResource.USER_FRIENDLY_LOCATION, CqRecordType.IS_STATELESS, CqRecordType.STATE_NAME_LIST, CqRecordType.ACTION_LIST.nest(new PropertyRequestItem[]{new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{CqAction.DESTINATION_STATE, CqAction.SOURCE_STATE_LIST, CqAction.TYPE, StpResource.DISPLAY_NAME})}), CqRecordType.FIELD_DEFINITIONS.nest(new PropertyRequestItem[]{new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{StpResource.DISPLAY_NAME, CqFieldDefinition.IS_SYSTEM_OWNED, CqFieldDefinition.RECORD_TYPE.nest(new PropertyRequestItem[]{new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{CqRecordType.KEY_FIELDS.nest(new PropertyRequestItem[]{new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{StpResource.DISPLAY_NAME})}), CqRecordType.IS_STATELESS})}), CqFieldDefinition.REFERENCED_RECORD_TYPE.nest(new PropertyRequestItem[]{new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{StpResource.DISPLAY_NAME})}), CqFieldDefinition.VALUE_TYPE, CqFieldDefinition.FIELD_TYPE})})});
    private static final PropertyRequestItem.PropertyRequest fieldDefinitionPropertyNames = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{StpResource.DISPLAY_NAME, CqFieldDefinition.IS_SYSTEM_OWNED, CqFieldDefinition.RECORD_TYPE.nest(new PropertyRequestItem[]{new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{CqRecordType.KEY_FIELDS.nest(new PropertyRequestItem[]{new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{StpResource.DISPLAY_NAME})}), CqRecordType.IS_STATELESS})}), CqFieldDefinition.REFERENCED_RECORD_TYPE.nest(new PropertyRequestItem[]{new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{StpResource.DISPLAY_NAME})}), CqFieldDefinition.CHOICE_LIST, CqFieldDefinition.VALUE_TYPE, CqFieldDefinition.FIELD_TYPE});
    private static final String JAZZ_CONTRIBUTOR_CLASS_NAME = "com.ibm.team.repository.Contributor";
    private static final String JAZZ_ATTACHMENT_CLASS_NAME = "com.ibm.team.workitem.Attachment";
    private static final String JAZZ_WORK_ITEM_CLASS_NAME = "com.ibm.team.workitem.WorkItem";

    private void computeOrderInformation() throws InteropException {
        try {
            CqExForm submitForm;
            CqExRecordType rt = (CqExRecordType)this.m_provider.doReadProperties((CqResource)this.m_delegate, (Feedback)formProperties);
            String recordTypeName = rt.getDisplayName();
            CqExForm modifyForm = rt.getModifyForm();
            if (modifyForm != null) {
                this.m_fieldOrderModify = FormXMLParser.getFormXMLParser().determineFieldOrder(modifyForm.getFormDataAsXml(), recordTypeName);
                if (this.m_logDetail.isDebugEnabled()) {
                    this.m_logDetail.debug((Object)("modify order is: " + this.m_fieldOrderModify));
                }
            }
            if ((submitForm = rt.getSubmitForm()) != null) {
                this.m_fieldOrderSubmit = FormXMLParser.getFormXMLParser().determineFieldOrder(submitForm.getFormDataAsXml(), recordTypeName);
                if (this.m_logDetail.isDebugEnabled()) {
                    this.m_logDetail.debug((Object)("submit order is: " + this.m_fieldOrderSubmit));
                }
            }
        }
        catch (WvcmException e) {
            throw new InteropWvcmException71(e);
        }
    }

    public void init(Object delegate, String uri, ICqProvider provider) throws InteropException {
        try {
            this.m_delegate = (CqExRecordType)delegate;
            this.m_provider = (CqProviderForInterop71)provider;
            this.m_uri = uri;
            this.m_fieldDefinitions = new ArrayList<ICqFieldDefinition>();
            this.m_delegate = (CqExRecordType)this.m_provider.doReadProperties((CqResource)this.m_delegate, (Feedback)nestedPropertyNames);
            boolean lookUpChoices = false;
            if (this.determineIfSyncableRecordType() || this.syncableByDefault()) {
                lookUpChoices = true;
            }
            for (CqFieldDefinition field : this.m_delegate.getFieldDefinitions()) {
                CqFieldValue.ValueType type = field.getFieldType();
                if (lookUpChoices && (type.equals((Object)CqFieldValue.ValueType.SHORT_STRING) || type.equals((Object)CqFieldValue.ValueType.INTEGER))) {
                    field = (CqFieldDefinition)this.m_provider.doReadProperties((CqResource)field, (Feedback)fieldDefinitionPropertyNames);
                }
                this.m_fieldDefinitions.add(new CqFieldDefinitionForInterop71(field, this));
            }
        }
        catch (WvcmException e) {
            throw new InteropWvcmException71(e);
        }
    }

    public ICqFieldDefinition[] buildFieldPath(String fieldPath) throws InteropException {
        try {
            String[] pathSegments = fieldPath.split("\\.");
            ICqFieldDefinition[] fieldDefs = new ICqFieldDefinition[pathSegments.length];
            CqRecordTypeForInterop71 recordType = this;
            int i = 0;
            while (i < pathSegments.length) {
                ICqFieldDefinition fieldDef;
                fieldDefs[i] = fieldDef = recordType.getFieldDefinitionsForFieldName(pathSegments[i]);
                CqFieldDefinition cqFieldDef = (CqFieldDefinition)fieldDef.getDelegate();
                if (cqFieldDef.getFieldType() == CqFieldValue.ValueType.RESOURCE || cqFieldDef.getFieldType() == CqFieldValue.ValueType.RESOURCE_LIST) {
                    CqRecordType refRecordType = cqFieldDef.getReferencedRecordType();
                    recordType = this.m_provider.getRecordTypeInfo(refRecordType.getDisplayName());
                }
                ++i;
            }
            return fieldDefs;
        }
        catch (WvcmException e) {
            throw new InteropWvcmException71(e);
        }
    }

    public ICqFieldDefinition getFieldDefinitionsForFieldName(String fieldName) throws InteropException {
        try {
            ResourceList fieldDefs = this.m_delegate.getFieldDefinitions();
            for (CqFieldDefinition prop : fieldDefs) {
                if (!fieldName.equals(prop.getDisplayName())) continue;
                return new CqFieldDefinitionForInterop71(prop, this);
            }
            throw new InteropException(MessageFormat.format(Messages.getString("CqRecordTypeForInterop71.ERROR_NO_CQ_FIELD_WITH_NAME"), fieldName, this.m_delegate.getDisplayName()));
        }
        catch (WvcmException e) {
            throw new InteropWvcmException71(e);
        }
    }

    public List<ICqFieldDefinition> getFieldDefinitionsForFieldNames(Collection<String> fieldNames) throws InteropException {
        try {
            ResourceList fieldDefs = this.m_delegate.getFieldDefinitions();
            ArrayList<ICqFieldDefinition> returnList = new ArrayList<ICqFieldDefinition>();
            if (fieldNames != null) {
                for (String fieldName : fieldNames) {
                    for (CqFieldDefinition prop : fieldDefs) {
                        if (!fieldName.equals(prop.getDisplayName())) continue;
                        returnList.add(new CqFieldDefinitionForInterop71(prop, this));
                    }
                }
            }
            return returnList;
        }
        catch (WvcmException e) {
            throw new InteropWvcmException71(e);
        }
    }

    public CqAction getAction(CqAction.Type aType) throws InteropException, WvcmException {
        ResourceList actions = this.m_delegate.getActionList();
        for (CqAction action : actions) {
            if (!action.getType().equals((Object)aType)) continue;
            return action;
        }
        throw new InteropException(MessageFormat.format(Messages.getString("CqRecordTypeForInterop71.ERROR_NO_ACTION_FOR_RECORD_TYPE"), aType, this.getName()));
    }

    public ResourceList getKeyFields() throws InteropException {
        try {
            return this.m_delegate.getKeyFields();
        }
        catch (WvcmException e) {
            throw new InteropWvcmException71(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean determineIfSyncableRecordType() throws InteropException {
        try {
            CqAction action;
            Iterator<ICqAction> i = this.getActionList().iterator();
            do {
                if (i.hasNext()) continue;
                return false;
            } while (!(action = (CqAction)i.next().getDelegate()).getDisplayName().equals("Change_History"));
            return true;
        }
        catch (WvcmException e) {
            throw new InteropWvcmException71(e);
        }
    }

    public boolean typeHasDuplicates() throws InteropException {
        for (ICqFieldDefinition field : this.m_fieldDefinitions) {
            if (!field.getName().equals("is_duplicate")) continue;
            return true;
        }
        return false;
    }

    public List<ICqFieldDefinition> getFieldDefinitions() throws InteropException {
        if (this.m_fieldDefinitions == null) {
            this.m_fieldDefinitions = new ArrayList<ICqFieldDefinition>();
            for (ICqFieldDefinition f : this.m_fieldDefinitions) {
                CqFieldDefinitionForInterop71 field = (CqFieldDefinitionForInterop71)f;
                this.m_fieldDefinitions.add(field);
            }
        }
        return this.m_fieldDefinitions;
    }

    public void handleFileNamePropertyNameBug() throws InteropException {
        ICqFieldDefinition fileNameFieldDef = null;
        for (ICqFieldDefinition f : this.m_properties) {
            if (!f.getName().equals("filename")) continue;
            fileNameFieldDef = f;
            break;
        }
        if (fileNameFieldDef != null) {
            this.m_properties.remove(fileNameFieldDef);
            this.m_properties.add((ICqFieldDefinition)new PseudoCqFieldDefinition("file-name", false, false));
        }
    }

    public List<ICqFieldDefinition> getAllProperties() throws InteropException {
        if (this.m_properties == null) {
            this.m_properties = new ArrayList<ICqFieldDefinition>();
            for (ICqFieldDefinition f : this.m_fieldDefinitions) {
                CqFieldDefinitionForInterop71 field = (CqFieldDefinitionForInterop71)f;
                if (!field.syncable()) continue;
                this.m_properties.add(field);
            }
            if (this.typeHasDuplicates()) {
                this.m_properties.add((ICqFieldDefinition)new PseudoCqFieldDefinition("original", false, false));
            }
            if (this.getName().equals("attachments")) {
                this.m_properties.add((ICqFieldDefinition)new PseudoCqFieldDefinition("Content", false, false));
                this.handleFileNamePropertyNameBug();
            } else {
                this.m_properties.add((ICqFieldDefinition)new PseudoCqFieldDefinition("modifiedBy", false, true));
            }
        }
        return this.m_properties;
    }

    public boolean getIsStateless() throws InteropException {
        try {
            return this.m_delegate.getIsStateless();
        }
        catch (WvcmException e) {
            throw new InteropWvcmException71(e);
        }
    }

    public List<ICqAction> getActionList() throws InteropException {
        try {
            ArrayList<ICqAction> actions = new ArrayList<ICqAction>();
            for (Object a : this.m_delegate.getActionList()) {
                actions.add(new CqActionForInterop71(a));
            }
            return actions;
        }
        catch (WvcmException e) {
            throw new InteropWvcmException71(e);
        }
    }

    public ICqLocation getUserFriendlyLocation() throws InteropException {
        try {
            return (ICqLocation)CqGatewayConstants.objectFactory.createLocator((Object)this.m_delegate.getUserFriendlyLocation());
        }
        catch (WvcmException e) {
            throw new InteropWvcmException71(e);
        }
    }

    public String getName() throws InteropException {
        try {
            return this.m_delegate.getDisplayName();
        }
        catch (WvcmException e) {
            throw new InteropWvcmException71(e);
        }
    }

    public String getQualifiedName() throws InteropException {
        return CqGatewayConstants.objectFactory.createUniqueTypeName(this.getName());
    }

    public Iterator doQuery(CqQuery.DisplayField[] displayFields, CqQuery.Filter filtering, long targetRow, long maxRows, boolean countRows) throws InteropException {
        return this.m_provider.doQuery(this.m_delegate, displayFields, filtering, targetRow, maxRows, COUNT_ROWS);
    }

    private ICqQuery getQuery(String propertyName) throws InteropException {
        ArrayList<String> wantedProperties = new ArrayList<String>();
        wantedProperties.add("dbid");
        if (propertyName != null) {
            wantedProperties.add(propertyName);
        }
        ICqQuery query = CqGatewayConstants.objectFactory.createCqQuery(this.getName(), "DUMMY", this.m_uri, (ICqProvider)this.m_provider);
        query.setDisplayFields(wantedProperties, null);
        return query;
    }

    public void dropExistingRecords(String propertyName, String propertyValue) throws InteropException {
        ICqQuery allQuery = this.getQuery(propertyName);
        Iterator resultSet = this.doQuery(allQuery, 1L, Long.MAX_VALUE, false);
        while (resultSet.hasNext()) {
            try {
                CqRecord record = (CqRecord)((CqRowData)resultSet.next()).getRecord();
                if (!propertyValue.equals(record.getProperty((PropertyNameList.PropertyName)new CqRecord.FieldName(propertyName)))) continue;
                record.setAction(this.getAction(CqAction.Type.DELETE));
                this.m_provider.doDelete((CqContextResource)record);
            }
            catch (WvcmException e) {
                throw new InteropWvcmException71(e);
            }
        }
    }

    public void dropExistingRecords() throws InteropException {
        ICqQuery allQuery = this.getQuery(null);
        Iterator resultSet = this.doQuery(allQuery, 1L, Long.MAX_VALUE, false);
        while (resultSet.hasNext()) {
            try {
                CqRecord record = (CqRecord)((CqRowData)resultSet.next()).getRecord();
                record.setAction(this.getAction(CqAction.Type.DELETE));
                this.m_provider.doDelete((CqContextResource)record);
            }
            catch (WvcmException e) {
                throw new InteropWvcmException71(e);
            }
        }
    }

    public boolean syncableByDefault() throws InteropException {
        return defaultSyncableRecordTypes.contains(this.getName());
    }

    public Iterator doQuery(ICqQuery query, long targetRow, long maxRows, boolean countRows) throws InteropException {
        try {
            CqQuery cqQuery = (CqQuery)query.getDelegate();
            CqQuery.Filter queryFilter = null;
            try {
                queryFilter = cqQuery.getFiltering();
            }
            catch (WvcmException wvcmException) {}
            return this.m_provider.doQuery(this.m_delegate, cqQuery.getDisplayFields(), queryFilter, targetRow, maxRows, COUNT_ROWS);
        }
        catch (WvcmException e) {
            throw new InteropWvcmException71(e);
        }
    }

    public ICqObject createObjectFromResultSet(Iterator queryResults, ICqQuery query) throws InteropException {
        List fieldNamesList = query.getFieldNameList();
        Iterator resultSet = queryResults;
        CqProvider cqProvider = (CqProvider)this.m_provider.getDelegate();
        boolean isStateless = this.getIsStateless();
        CqRecord record = null;
        if (resultSet.hasNext()) {
            CqRowData row = (CqRowData)resultSet.next();
            if (!isStateless) {
                try {
                    record = (CqRecord)row.getRecord();
                }
                catch (WvcmException e) {
                    throw new InteropWvcmException71(e);
                }
            } else {
                Object[] rowData = row.getValues();
                int columnCount = rowData.length;
                String dbid = null;
                int i = 0;
                while (i < columnCount) {
                    String fieldName = (String)fieldNamesList.get(i);
                    if (fieldName.equals("dbid")) {
                        dbid = Long.toString((Long)rowData[i]);
                    }
                    ++i;
                }
                ICqLocation location = (ICqLocation)CqGatewayConstants.objectFactory.createLocator(dbid, this.getName(), this.m_uri);
                location.generateLocator((ICqProvider)this.m_provider);
                record = cqProvider.cqRecord((StpLocation)location.getDelegate());
            }
        }
        return CqGatewayConstants.objectFactory.createCqRecord(record, this.getName(), (ICqProvider)this.m_provider);
    }

    public List<Map<String, Object>> createMapsFromResultSet(Iterator queryResults, List<String> fieldNamesList) throws InteropException {
        Iterator resultSet = queryResults;
        ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>();
        long dbid = -1L;
        while (resultSet.hasNext()) {
            CqRowData row = (CqRowData)resultSet.next();
            Object[] rowData = row.getValues();
            int columnCount = rowData.length;
            HashMap<String, Object> rowMap = new HashMap<String, Object>();
            int i = 0;
            while (i < columnCount) {
                String fieldName = fieldNamesList.get(i);
                if (fieldName.equals("dbid")) {
                    dbid = (Long)rowData[i];
                }
                rowMap.put(fieldName, rowData[i]);
                ++i;
            }
            rowMap.put("@@uniqueId@@", CqGatewayConstants.objectFactory.createLocator(Long.toString(dbid), this.getName(), this.m_uri).getExternalLocationString());
            mapList.add(rowMap);
        }
        return mapList;
    }

    public ICqRowData getNextRowData(Iterator queryResults) {
        CqResultSet resultSet = (CqResultSet)queryResults;
        CqRowDataForInterop71 rowData = null;
        String recordId = null;
        if (resultSet.hasNext()) {
            CqRowData cqRowData = (CqRowData)resultSet.next();
            String[] rowStringData = cqRowData.getStrings();
            String[] columnLabels = resultSet.getColumnLabels();
            int i = 0;
            while (i < columnLabels.length) {
                if (columnLabels[i].equals("id")) {
                    recordId = rowStringData[i];
                    break;
                }
                ++i;
            }
            rowData = new CqRowDataForInterop71(cqRowData, recordId);
        }
        return rowData;
    }

    public List<ICqExportData> createExportDataFromRowData(ICqRowData rowData, ICqQuery query) throws InteropException {
        ArrayList<ICqExportData> cqExportData = new ArrayList<ICqExportData>();
        CqRowData row = (CqRowData)rowData.getDelegate();
        try {
            CqQuery cqQuery = (CqQuery)query.getDelegate();
            CqQuery.DisplayField[] displayFields = cqQuery.getDisplayFields();
            CqFieldValue.ValueType fieldType = null;
            String[] rowStringData = row.getStrings();
            int columnCount = rowStringData.length;
            int i = 0;
            while (i < columnCount) {
                CqFieldDefinition[] pathFieldDef = displayFields[i].getPath();
                CqFieldDefinition fieldDef = pathFieldDef[pathFieldDef.length - 1];
                try {
                    fieldType = fieldDef.getFieldType();
                }
                catch (WvcmException wvcmException) {
                    fieldDef = (CqFieldDefinition)this.m_provider.doReadProperties((CqResource)fieldDef, (Feedback)fieldDefinitionPropertyNames);
                    fieldType = fieldDef.getFieldType();
                }
                CqExportData columnData = new CqExportData();
                columnData.setName(displayFields[i].getPathName());
                columnData.setValue((Object)rowStringData[i]);
                if (fieldType == CqFieldValue.ValueType.DATE_TIME) {
                    columnData.setType(CqExportData.Type.TIMESTAMP);
                } else if (columnData.getName().endsWith("Notes_Log")) {
                    columnData.setType(CqExportData.Type.COMMENTS);
                } else if (columnData.getName().equals("is_duplicate")) {
                    CqRecord cqRecord = (CqRecord)row.getRecord();
                    cqRecord = (CqRecord)this.m_provider.doReadProperties((CqResource)cqRecord, (Feedback)originalRecordProperties);
                    columnData.setValue((Object)cqRecord.getOriginalId());
                    columnData.setName("Duplicate_Of");
                    ResourceList dups = cqRecord.getDuplicates();
                    for (CqRecord dup : dups) {
                        CqExportData dupColumnData = new CqExportData();
                        dupColumnData.setName("Duplicated_By");
                        dupColumnData.setValue((Object)dup.getDisplayName());
                        cqExportData.add((ICqExportData)dupColumnData);
                        dup = null;
                    }
                    dups = null;
                    cqRecord = null;
                } else if (fieldType == CqFieldValue.ValueType.RESOURCE) {
                    String refRecordTypeName = fieldDef.getReferencedRecordType().getDisplayName();
                    if (refRecordTypeName.equals("users")) {
                        columnData.setType(CqExportData.Type.USER);
                    } else {
                        columnData.setType(CqExportData.Type.SIMPLE_STRING);
                    }
                } else if (fieldType == CqFieldValue.ValueType.ATTACHMENT_LIST) {
                    ArrayList<CqExportAttachmentData> attachments = new ArrayList<CqExportAttachmentData>();
                    columnData.setType(CqExportData.Type.ATTACHMENTS);
                    String attachmentValue = (String)columnData.getValue();
                    if (attachmentValue.trim().length() > 0) {
                        CqRecord cqRecord = (CqRecord)row.getRecord();
                        cqRecord = (CqRecord)this.m_provider.doReadProperties((CqResource)cqRecord, (Feedback)attachmentProperties);
                        ResourceList resourceList = cqRecord.getAttachmentFolders();
                        for (CqAttachmentFolder cqAttachmentFolder : resourceList) {
                            ResourceList attachmentList = cqAttachmentFolder.getAttachmentList();
                            for (CqAttachment cqAttachment : attachmentList) {
                                CqExportAttachmentData attachment = new CqExportAttachmentData();
                                attachment.setFileName(cqAttachment.getFileName());
                                attachment.setSize(cqAttachment.getFileSize());
                                attachment.setDescription(cqAttachment.getDescription());
                                attachments.add(attachment);
                                cqAttachment = null;
                            }
                            attachmentList = null;
                            cqAttachmentFolder = null;
                        }
                        columnData.setValue(attachments);
                        resourceList = null;
                        cqRecord = null;
                    } else {
                        columnData.setValue(attachments);
                    }
                }
                cqExportData.add((ICqExportData)columnData);
                fieldType = null;
                fieldDef = null;
                pathFieldDef = null;
                ++i;
            }
            row = null;
            rowStringData = null;
            displayFields = null;
            cqQuery = null;
        }
        catch (WvcmException e) {
            throw new InteropException((Throwable)e);
        }
        return cqExportData;
    }

    public List<ICqExportData> createExportDataFromResultSet(Iterator queryResults, ICqQuery query) throws InteropException {
        Iterator resultSet = queryResults;
        ArrayList<ICqExportData> cqExportData = new ArrayList<ICqExportData>();
        try {
            CqQuery cqQuery = (CqQuery)query.getDelegate();
            CqQuery.DisplayField[] displayFields = cqQuery.getDisplayFields();
            CqFieldValue.ValueType fieldType = null;
            if (resultSet.hasNext()) {
                CqRowData row = (CqRowData)resultSet.next();
                String[] rowStringData = row.getStrings();
                int columnCount = rowStringData.length;
                int i = 0;
                while (i < columnCount) {
                    CqFieldDefinition[] pathFieldDef = displayFields[i].getPath();
                    CqFieldDefinition fieldDef = pathFieldDef[pathFieldDef.length - 1];
                    try {
                        fieldType = fieldDef.getFieldType();
                    }
                    catch (WvcmException wvcmException) {
                        fieldDef = (CqFieldDefinition)this.m_provider.doReadProperties((CqResource)fieldDef, (Feedback)fieldDefinitionPropertyNames);
                        fieldType = fieldDef.getFieldType();
                    }
                    CqExportData columnData = new CqExportData();
                    columnData.setName(displayFields[i].getPathName());
                    columnData.setValue((Object)rowStringData[i]);
                    if (fieldType == CqFieldValue.ValueType.DATE_TIME) {
                        columnData.setType(CqExportData.Type.TIMESTAMP);
                    } else if (columnData.getName().endsWith("Notes_Log")) {
                        columnData.setType(CqExportData.Type.COMMENTS);
                    } else if (columnData.getName().equals("is_duplicate")) {
                        CqRecord cqRecord = (CqRecord)row.getRecord();
                        cqRecord = (CqRecord)this.m_provider.doReadProperties((CqResource)cqRecord, (Feedback)originalRecordProperties);
                        columnData.setValue((Object)cqRecord.getOriginalId());
                        columnData.setName("Duplicate_Of");
                        ResourceList dups = cqRecord.getDuplicates();
                        for (CqRecord dup : dups) {
                            CqExportData dupColumnData = new CqExportData();
                            dupColumnData.setName("Duplicated_By");
                            dupColumnData.setValue((Object)dup.getDisplayName());
                            cqExportData.add((ICqExportData)dupColumnData);
                            dup = null;
                        }
                        dups = null;
                        cqRecord = null;
                    } else if (fieldType == CqFieldValue.ValueType.RESOURCE) {
                        String refRecordTypeName = fieldDef.getReferencedRecordType().getDisplayName();
                        if (refRecordTypeName.equals("users")) {
                            columnData.setType(CqExportData.Type.USER);
                        } else {
                            columnData.setType(CqExportData.Type.SIMPLE_STRING);
                        }
                    } else if (fieldType == CqFieldValue.ValueType.ATTACHMENT_LIST) {
                        ArrayList<CqExportAttachmentData> attachments = new ArrayList<CqExportAttachmentData>();
                        columnData.setType(CqExportData.Type.ATTACHMENTS);
                        String attachmentValue = (String)columnData.getValue();
                        if (attachmentValue.trim().length() > 0) {
                            CqRecord cqRecord = (CqRecord)row.getRecord();
                            cqRecord = (CqRecord)this.m_provider.doReadProperties((CqResource)cqRecord, (Feedback)attachmentProperties);
                            ResourceList resourceList = cqRecord.getAttachmentFolders();
                            for (CqAttachmentFolder cqAttachmentFolder : resourceList) {
                                ResourceList attachmentList = cqAttachmentFolder.getAttachmentList();
                                for (CqAttachment cqAttachment : attachmentList) {
                                    CqExportAttachmentData attachment = new CqExportAttachmentData();
                                    attachment.setFileName(cqAttachment.getFileName());
                                    attachment.setSize(cqAttachment.getFileSize());
                                    attachment.setDescription(cqAttachment.getDescription());
                                    attachments.add(attachment);
                                    cqAttachment = null;
                                }
                                attachmentList = null;
                                cqAttachmentFolder = null;
                            }
                            columnData.setValue(attachments);
                            resourceList = null;
                            cqRecord = null;
                        } else {
                            columnData.setValue(attachments);
                        }
                    }
                    cqExportData.add((ICqExportData)columnData);
                    fieldType = null;
                    fieldDef = null;
                    pathFieldDef = null;
                    ++i;
                }
                row = null;
                rowStringData = null;
            }
            displayFields = null;
            cqQuery = null;
        }
        catch (WvcmException e) {
            throw new InteropException((Throwable)e);
        }
        return cqExportData;
    }

    public List<String> getFieldOrderFromProperties() throws InteropException {
        if (this.m_fieldOrderFromProperties == null) {
            String typeName = this.getName();
            ArrayList<String> orderedPropertiesList = new ArrayList<String>();
            String propertyName = "cq.orderedProperties." + typeName;
            String propertyValue = (String)InteropProperties.getCurrentInteropProperties().getConfigValue(propertyName);
            if (propertyValue == null) {
                return null;
            }
            if (!propertyValue.equals(CQInteropConstants.EMPTY_STRING)) {
                if (this.m_logDetail.isDebugEnabled()) {
                    this.m_logDetail.debug((Object)("Using property " + propertyName + ":" + propertyValue));
                }
                String[] orderedProps = propertyValue.split(",");
                int i = 0;
                while (i < orderedProps.length) {
                    String prop = orderedProps[i].trim();
                    orderedPropertiesList.add(prop);
                    ++i;
                }
            }
            this.m_fieldOrderFromProperties = orderedPropertiesList;
        }
        return this.m_fieldOrderFromProperties;
    }

    public List<String> getFieldOrderSubmit() throws InteropException {
        if (this.determineIfSyncableRecordType() && this.m_fieldOrderSubmit == null) {
            this.computeOrderInformation();
        }
        return this.m_fieldOrderSubmit;
    }

    public List<String> getFieldOrderModify() throws InteropException {
        if (this.determineIfSyncableRecordType() && this.m_fieldOrderModify == null) {
            this.computeOrderInformation();
        }
        return this.m_fieldOrderModify;
    }

    public List<String> getStateNameList() throws InteropException {
        try {
            return this.m_delegate.getStateNameList();
        }
        catch (WvcmException e) {
            throw new InteropWvcmException71(e);
        }
    }

    public ICqAction getDefaultModifyAction() throws InteropException {
        try {
            if (this.m_defaultModifyAction == null) {
                ResourceList actions = this.m_delegate.getActionList();
                CqAction selectedOne = null;
                for (CqAction action : actions) {
                    if (!action.getType().equals((Object)CqAction.Type.MODIFY)) continue;
                    selectedOne = action;
                    if (action.getDisplayName().equals("Modify")) break;
                }
                if (selectedOne == null) {
                    throw new InteropException(MessageFormat.format(Messages.getString("CqRecordTypeForInterop71.ERROR_NO_ACTION_FOR_RECORD_TYPE"), CqAction.Type.MODIFY, this.getName()));
                }
                this.m_defaultModifyAction = new CqActionForInterop71(selectedOne);
            }
            return this.m_defaultModifyAction;
        }
        catch (WvcmException e) {
            throw new InteropWvcmException71(e);
        }
    }

    public String getJazzType() throws InteropException {
        String name = this.getName();
        if (name.equals("users")) {
            return JAZZ_CONTRIBUTOR_CLASS_NAME;
        }
        if (name.equals("attachments")) {
            return JAZZ_ATTACHMENT_CLASS_NAME;
        }
        return JAZZ_WORK_ITEM_CLASS_NAME;
    }

    public Object getDelegate() {
        return this.m_delegate;
    }
}

