/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.connector.cq.teamapi71;

import com.ibm.rational.connector.cq.teamapi.common.ICQInteropEventHandler;
import com.ibm.rational.connector.cq.teamapi.common.ICqObject;
import com.ibm.rational.connector.cq.teamapi.common.ICqProvider;
import com.ibm.rational.connector.cq.teamapi.common.ICqQuery;
import com.ibm.rational.connector.cq.teamapi.common.ICqQueryInfoTable;
import com.ibm.rational.connector.cq.teamapi.common.ICqRecordType;
import com.ibm.rational.connector.cq.teamapi.common.InteropLocation;
import com.ibm.rational.connector.cq.teamapi.common.internal.CqGatewayConstants;
import com.ibm.rational.connector.cq.teamapi71.InteropWvcmException71;
import com.ibm.rational.connector.cq.teamapi71.Messages;
import com.ibm.rational.wvcm.stp.cq.CqQuery;
import com.ibm.rational.wvcm.stp.cq.CqRecord;
import com.ibm.rational.wvcm.stp.cq.CqRowData;
import com.ibm.team.interop.service.managers.clearquest.common.CQInteropConstants;
import com.ibm.team.interop.service.managers.clearquest.common.InteropException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.wvcm.WvcmException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CqQueryInfoTableForInterop71
implements ICqQueryInfoTable {
    private static final String RECORD_TYPE_NAME_PROPERTY = "entityRecordType";
    private static final String QUERY_DBID_PROPERTY = "query_dbid";
    private static final String DBID_PROPERTY = "dbid";
    private static final String PROJECT_AREA_ID_PROPERTY = "jazz_ProjectArea_id";
    private static ArrayList<String> queryInfoPropertyNames = new ArrayList();
    private static ICqQuery queryInfoQuery;

    static {
        queryInfoPropertyNames.add(RECORD_TYPE_NAME_PROPERTY);
        queryInfoPropertyNames.add(QUERY_DBID_PROPERTY);
        queryInfoPropertyNames.add(PROJECT_AREA_ID_PROPERTY);
        queryInfoQuery = null;
    }

    private String getQueryDbId(String queryPath, String dbName, ICQInteropEventHandler handler) throws InteropException {
        try {
            ICqQuery query = CqGatewayConstants.objectFactory.lookupCqQuery(queryPath, dbName, handler.getImplementation());
            return ((CqQuery)query.getDelegate()).getStableLocation().getName();
        }
        catch (WvcmException e) {
            throw new InteropWvcmException71(e);
        }
    }

    public ICqQuery getQueryInfoQuery(String dbName, ICqProvider provider, ICqRecordType cqRecordType) throws InteropException {
        if (queryInfoQuery == null) {
            ArrayList<String> wantedFields = new ArrayList<String>();
            wantedFields.add(RECORD_TYPE_NAME_PROPERTY);
            wantedFields.add(QUERY_DBID_PROPERTY);
            wantedFields.add(PROJECT_AREA_ID_PROPERTY);
            wantedFields.add(DBID_PROPERTY);
            queryInfoQuery = CqGatewayConstants.objectFactory.createCqQuery(cqRecordType.getName(), "DUMMY", dbName, provider);
            queryInfoQuery.setDisplayFields(wantedFields, null);
        }
        return queryInfoQuery;
    }

    public void insertQueryInfo(Map.Entry<Object, Object> entry, String dbName, ICQInteropEventHandler handler, String projectAreaId, Set<String> typeNames) throws InteropException {
        String newValue = (String)entry.getValue();
        InteropLocation location = null;
        ICqObject record = null;
        ICqProvider provider = handler.getImplementation();
        String recordTypeName = ((String)entry.getKey()).substring("cq.query.".length());
        if (!typeNames.contains(recordTypeName)) {
            throw new InteropException(MessageFormat.format(Messages.getString("CqQueryInfoTableForInterop71.ERROR_SPECIFYING_CQ_QUERIES_NO_SYNC_RULE"), recordTypeName));
        }
        String queryDbId = null;
        queryDbId = newValue.equals(CQInteropConstants.EMPTY_STRING) ? CQInteropConstants.EMPTY_STRING : this.getQueryDbId(newValue, dbName, handler);
        ICqRecordType cqRecordType = handler.getRecordTypeInfo("JazzConnectorQueryInfo");
        ICqQuery query = this.getQueryInfoQuery(dbName, provider, cqRecordType);
        Iterator resultSet = cqRecordType.doQuery(query, 1L, Long.MAX_VALUE, false);
        while (resultSet.hasNext()) {
            try {
                ICqObject cqRecord = CqGatewayConstants.objectFactory.createCqRecord((Object)((CqRecord)((CqRowData)resultSet.next()).getRecord()), "JazzConnectorQueryInfo", provider);
                cqRecord.doReadProperties(null);
                if (!recordTypeName.equals(cqRecord.getProperty(RECORD_TYPE_NAME_PROPERTY))) continue;
                if (record != null) {
                    throw new InteropException(MessageFormat.format(Messages.getString("CqQueryInfoTableForInterop71.ERROR_SPECIFYING_CQ_QUERIES"), recordTypeName));
                }
                record = cqRecord;
            }
            catch (WvcmException e) {
                throw new InteropWvcmException71(e);
            }
        }
        if (record != null) {
            if (!queryDbId.equals(record.getProperty(QUERY_DBID_PROPERTY))) {
                record.setProperty(QUERY_DBID_PROPERTY, (Object)queryDbId);
                record.doWriteProperties(null);
            }
            if (!projectAreaId.equals(record.getProperty(PROJECT_AREA_ID_PROPERTY))) {
                record.setProperty(PROJECT_AREA_ID_PROPERTY, (Object)projectAreaId);
                record.doWriteProperties(null);
            }
        } else {
            location = CqGatewayConstants.objectFactory.createNewUserFriendlyLocation(handler.getImplementation().getRecordTypeInfo("JazzConnectorQueryInfo"), "new");
            record = CqGatewayConstants.objectFactory.createNewCQObject(location, "JazzConnectorQueryInfo", provider);
            record.doInitialize(queryInfoPropertyNames, null);
            record.setProperty(RECORD_TYPE_NAME_PROPERTY, (Object)recordTypeName);
            record.setProperty(QUERY_DBID_PROPERTY, (Object)queryDbId);
            record.setProperty(PROJECT_AREA_ID_PROPERTY, (Object)projectAreaId);
            record.doWriteProperties(queryInfoPropertyNames);
        }
    }
}

