/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.connector.cq.teamapi71;

import com.ibm.rational.connector.cq.teamapi.common.ICqFieldDefinition;
import com.ibm.rational.connector.cq.teamapi.common.ICqFilterCriteria;
import com.ibm.rational.connector.cq.teamapi.common.ICqProvider;
import com.ibm.rational.connector.cq.teamapi.common.ICqQuery;
import com.ibm.rational.connector.cq.teamapi.common.ICqRecordType;
import com.ibm.rational.connector.cq.teamapi.common.impl.CqFolderItemForInterop;
import com.ibm.rational.connector.cq.teamapi71.CqProviderForInterop71;
import com.ibm.rational.connector.cq.teamapi71.CqRecordTypeForInterop71;
import com.ibm.rational.connector.cq.teamapi71.InteropWvcmException71;
import com.ibm.rational.wvcm.stp.StpLocation;
import com.ibm.rational.wvcm.stp.StpProvider;
import com.ibm.rational.wvcm.stp.StpResource;
import com.ibm.rational.wvcm.stp.cq.CqFieldDefinition;
import com.ibm.rational.wvcm.stp.cq.CqProvider;
import com.ibm.rational.wvcm.stp.cq.CqQuery;
import com.ibm.rational.wvcm.stp.cq.CqRecordType;
import com.ibm.rational.wvcm.stp.cq.CqResource;
import com.ibm.rational.wvcm.stp.cqex.CqExRecordType;
import com.ibm.team.interop.service.managers.clearquest.common.InteropException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.wvcm.Feedback;
import javax.wvcm.Folder;
import javax.wvcm.PropertyRequestItem;
import javax.wvcm.ResourceList;
import javax.wvcm.WvcmException;
import org.apache.commons.logging.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CqQueryForInterop71
extends CqFolderItemForInterop
implements ICqQuery {
    private CqQuery m_delegate;
    private ICqRecordType m_recordType;
    protected Log m_log;
    private static final PropertyRequestItem.PropertyRequest queryProperties = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{CqQuery.DISPLAY_NAME, CqQuery.STABLE_LOCATION, CqQuery.USER_FRIENDLY_LOCATION, CqQuery.DISPLAY_FIELDS, CqQuery.FILTERING, CqQuery.PARENT_LIST.nest(new PropertyRequestItem[]{new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{StpResource.DISPLAY_NAME})}), CqQuery.PRIMARY_RECORD_TYPE.nest(new PropertyRequestItem[]{new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{CqRecordType.DISPLAY_NAME})})});

    private int getOrderInCollection(Collection<String> itemsInCollection, String itemToSearch) {
        if (itemsInCollection == null) {
            return 0;
        }
        if (itemToSearch == null) {
            return 0;
        }
        Iterator<String> iter = itemsInCollection.iterator();
        int pos = 1;
        while (iter.hasNext()) {
            String itemInCollection = iter.next();
            if (itemToSearch.equals(itemInCollection)) {
                return pos;
            }
            ++pos;
        }
        return 0;
    }

    public void setDisplayFields(List<String> fieldNameList, List<String> fieldNamesSortOrder) throws InteropException {
        if (fieldNameList == null) {
            return;
        }
        if (this.m_recordType.getIsStateless()) {
            if (!fieldNameList.contains("dbid")) {
                fieldNameList.add("dbid");
            }
        } else if (!fieldNameList.contains("id")) {
            fieldNameList.add("id");
        }
        CqProvider cqProvider = (CqProvider)this.m_provider.getDelegate();
        ArrayList<CqQuery.DisplayField> displayFields = new ArrayList<CqQuery.DisplayField>();
        for (String fieldName : fieldNameList) {
            ICqFieldDefinition[] pathFieldDefs = null;
            try {
                pathFieldDefs = this.m_recordType.buildFieldPath(fieldName);
            }
            catch (InteropException interopException) {
                continue;
            }
            CqFieldDefinition[] cqPathFieldDefs = new CqFieldDefinition[pathFieldDefs.length];
            int j = 0;
            while (j < cqPathFieldDefs.length) {
                cqPathFieldDefs[j] = (CqFieldDefinition)pathFieldDefs[j].getDelegate();
                ++j;
            }
            CqQuery.DisplayField displayField = cqProvider.buildDisplayField(new CqFieldDefinition[0]);
            displayField.setPath(cqPathFieldDefs);
            displayField.setIsVisible(true);
            int sortOrderPos = this.getOrderInCollection(fieldNamesSortOrder, fieldName);
            if (sortOrderPos > 0) {
                displayField.setSortOrder((long)sortOrderPos);
                displayField.setSortType(CqQuery.DisplayField.SortType.ASCENDING);
            }
            displayFields.add(displayField);
        }
        this.m_delegate.setDisplayFields(displayFields.toArray(new CqQuery.DisplayField[displayFields.size()]));
    }

    public void addDisplayField(String fieldName) throws InteropException {
        if (fieldName == null || fieldName.length() == 0) {
            return;
        }
        CqQuery.DisplayField[] displayFields = null;
        try {
            displayFields = this.m_delegate.getDisplayFields();
        }
        catch (WvcmException e) {
            throw new InteropWvcmException71(e);
        }
        CqQuery.DisplayField[] displayFieldArray = displayFields;
        int n = displayFields.length;
        int n2 = 0;
        while (n2 < n) {
            CqQuery.DisplayField displayField = displayFieldArray[n2];
            if (displayField.getPathName().equals(fieldName)) {
                return;
            }
            ++n2;
        }
        CqProvider cqProvider = (CqProvider)this.m_provider.getDelegate();
        ICqFieldDefinition[] pathFieldDefs = null;
        pathFieldDefs = this.m_recordType.buildFieldPath(fieldName);
        CqFieldDefinition[] cqPathFieldDefs = new CqFieldDefinition[pathFieldDefs.length];
        int j = 0;
        while (j < cqPathFieldDefs.length) {
            cqPathFieldDefs[j] = (CqFieldDefinition)pathFieldDefs[j].getDelegate();
            ++j;
        }
        CqQuery.DisplayField displayField = cqProvider.buildDisplayField(new CqFieldDefinition[0]);
        displayField.setPath(cqPathFieldDefs);
        displayField.setIsVisible(true);
        CqQuery.DisplayField[] modDisplayFields = new CqQuery.DisplayField[displayFields.length + 1];
        int i = 0;
        while (i < modDisplayFields.length - 1) {
            modDisplayFields[i] = displayFields[i];
            ++i;
        }
        modDisplayFields[modDisplayFields.length - 1] = displayField;
        this.m_delegate.setDisplayFields(modDisplayFields);
    }

    public void setSortOrder(List<String> fieldNamesSortOrder) throws InteropException {
        CqQuery.DisplayField[] displayFields = null;
        if (fieldNamesSortOrder == null) {
            return;
        }
        try {
            displayFields = this.m_delegate.getDisplayFields();
        }
        catch (WvcmException e) {
            throw new InteropWvcmException71(e);
        }
        CqQuery.DisplayField[] displayFieldArray = displayFields;
        int n = displayFields.length;
        int n2 = 0;
        while (n2 < n) {
            CqQuery.DisplayField displayField = displayFieldArray[n2];
            int sortOrder = this.getOrderInCollection(fieldNamesSortOrder, displayField.getPathName());
            if (sortOrder == 0) {
                if (displayField.getSortType() != CqQuery.DisplayField.SortType.NO_SORT) {
                    displayField.setSortType(CqQuery.DisplayField.SortType.NO_SORT);
                }
            } else {
                displayField.setSortOrder((long)sortOrder);
                displayField.setSortType(CqQuery.DisplayField.SortType.ASCENDING);
            }
            ++n2;
        }
    }

    public void setFilter(List<ICqFilterCriteria> filterCriteriaList) throws InteropException {
        CqProvider cqProvider = (CqProvider)this.m_provider.getDelegate();
        CqQuery.FilterNode filterNode = null;
        if (filterCriteriaList != null && filterCriteriaList.size() > 0) {
            ArrayList<CqQuery.FilterLeaf> filterLeaves = new ArrayList<CqQuery.FilterLeaf>();
            for (ICqFilterCriteria filterCriteria : filterCriteriaList) {
                ICqFieldDefinition fieldDef = this.m_recordType.getFieldDefinitionsForFieldName(filterCriteria.getFieldName());
                CqFieldDefinition[] cqFieldDef = new CqFieldDefinition[]{(CqFieldDefinition)fieldDef.getDelegate()};
                CqQuery.FilterLeaf leaf = cqProvider.buildFilterLeaf(cqFieldDef, CqQuery.Filter.Operation.IS_EQUAL, null);
                leaf.setTarget(CqQuery.FilterLeaf.TargetType.CONSTANT, (Object)filterCriteria.getFieldValue());
                filterLeaves.add(leaf);
            }
            if (filterCriteriaList.size() == 2) {
                filterNode = cqProvider.buildFilterNode(CqQuery.Filter.Operation.CONJUNCTION, new CqQuery.FilterLeaf[]{(CqQuery.FilterLeaf)filterLeaves.get(0), (CqQuery.FilterLeaf)filterLeaves.get(1)});
            } else if (filterCriteriaList.size() == 1) {
                filterNode = cqProvider.buildFilterNode(CqQuery.Filter.Operation.CONJUNCTION, new CqQuery.FilterLeaf[]{(CqQuery.FilterLeaf)filterLeaves.get(0)});
            }
            this.m_delegate.setFiltering(filterNode);
        }
    }

    protected List<Object> getParentList() throws InteropException {
        try {
            ArrayList<Object> result = new ArrayList<Object>();
            ResourceList cqObjectList = this.m_delegate.getParentList();
            int i = 0;
            while (i < cqObjectList.size()) {
                Folder f = (Folder)cqObjectList.get(i);
                result.add(((CqProviderForInterop71)this.m_provider).doReadProperties((CqResource)f, (Feedback)queryProperties));
                ++i;
            }
            return result;
        }
        catch (WvcmException e) {
            throw new InteropWvcmException71(e);
        }
    }

    public void init(Object cqQuery, ICqProvider provider) {
        this.m_delegate = (CqQuery)cqQuery;
        this.m_provider = (CqProviderForInterop71)provider;
    }

    public void init(String typeName, String queryPath, String connectionURI, boolean existingQuery, ICqProvider provider) throws InteropException {
        try {
            this.m_provider = (CqProviderForInterop71)provider;
            CqProvider cqProvider = (CqProvider)this.m_provider.getDelegate();
            StpLocation stpLocation = this.getQueryStpLocation(queryPath, connectionURI, cqProvider);
            CqQuery query = cqProvider.cqQuery(stpLocation);
            if (existingQuery) {
                this.m_delegate = (CqQuery)query.doReadProperties((Feedback)queryProperties);
                this.m_recordType = provider.getRecordTypeInfo(this.getPrimaryResourceTypeName());
            } else {
                CqRecordTypeForInterop71 recordType = (CqRecordTypeForInterop71)provider.getRecordTypeInfo(typeName);
                CqExRecordType cqExRecordType = (CqExRecordType)recordType.getDelegate();
                query.setPrimaryRecordType((CqRecordType)cqExRecordType);
                this.m_delegate = query;
                this.m_recordType = recordType;
            }
        }
        catch (WvcmException e) {
            throw new InteropWvcmException71(e);
        }
    }

    private StpLocation getQueryStpLocation(String queryId, String connectionURI, CqProvider cqProvider) throws InteropException {
        try {
            StpLocation stpLocation = null;
            try {
                Integer.parseInt(queryId);
                stpLocation = cqProvider.stableSelector(StpProvider.Domain.CLEAR_QUEST, "cq-query", queryId, connectionURI);
            }
            catch (NumberFormatException numberFormatException) {
                stpLocation = cqProvider.userFriendlySelector(StpProvider.Domain.CLEAR_QUEST, StpLocation.Namespace.QUERY, queryId, connectionURI);
            }
            return stpLocation;
        }
        catch (WvcmException e) {
            throw new InteropWvcmException71(e);
        }
    }

    public List<String> getFieldNameList() throws InteropException {
        try {
            ArrayList<String> returnList = new ArrayList<String>();
            CqQuery.DisplayField[] displayFieldArray = this.m_delegate.getDisplayFields();
            int n = displayFieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                CqQuery.DisplayField df = displayFieldArray[n2];
                returnList.add(df.getPathName());
                ++n2;
            }
            return returnList;
        }
        catch (WvcmException e) {
            throw new InteropWvcmException71(e);
        }
    }

    public void doReadProperties() throws InteropException {
        this.m_delegate = (CqQuery)((CqProviderForInterop71)this.m_provider).doReadProperties((CqResource)this.m_delegate, (Feedback)queryProperties);
    }

    public void doWriteProperties() throws InteropException {
        try {
            this.m_delegate = (CqQuery)this.m_delegate.doWriteProperties(null);
        }
        catch (WvcmException e) {
            throw new InteropWvcmException71(e);
        }
    }

    public void doCreateQuery() throws InteropException {
        try {
            this.m_delegate = this.m_delegate.doCreateQuery(null);
        }
        catch (WvcmException e) {
            throw new InteropWvcmException71(e);
        }
    }

    public String getPrimaryResourceTypeName() throws InteropException {
        try {
            return this.m_delegate.getPrimaryRecordType().getDisplayName();
        }
        catch (WvcmException e) {
            throw new InteropWvcmException71(e);
        }
    }

    public Object getDelegate() {
        return this.m_delegate;
    }

    public String getName() throws InteropException {
        try {
            return this.m_delegate.getDisplayName();
        }
        catch (WvcmException e) {
            throw new InteropWvcmException71(e);
        }
    }

    public String getDbId() throws InteropException {
        try {
            String uniqueId = this.m_delegate.getStableLocation().toString();
            int indexOfAtSign = uniqueId.indexOf(64);
            int indexOfSlash = uniqueId.indexOf(58);
            if (indexOfAtSign == -1 || indexOfSlash == -1) {
                throw new InteropException("Malformed uniqueId: " + uniqueId);
            }
            return uniqueId.substring(indexOfSlash + 1, indexOfAtSign);
        }
        catch (WvcmException e) {
            throw new InteropWvcmException71(e);
        }
    }
}

