/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.connector.cq.teamapi71;

import com.ibm.rational.connector.cq.teamapi.common.ICQInteropEventHandler;
import com.ibm.rational.connector.cq.teamapi.common.ICqProvider;
import com.ibm.rational.connector.cq.teamapi.common.ICqRecordType;
import com.ibm.rational.connector.cq.teamapi.common.ICqResultSet;
import com.ibm.rational.connector.cq.teamapi.common.InteropWvcmException;
import com.ibm.rational.connector.cq.teamapi.common.impl.CqProviderForInterop;
import com.ibm.rational.connector.cq.teamapi.common.internal.LogFactory;
import com.ibm.rational.connector.cq.teamapi71.CqResultSetForInterop71;
import com.ibm.rational.connector.cq.teamapi71.InteropWvcmException71;
import com.ibm.rational.connector.cq.teamapi71.Messages;
import com.ibm.rational.wvcm.stp.StpLocation;
import com.ibm.rational.wvcm.stp.StpProvider;
import com.ibm.rational.wvcm.stp.cq.CqAttachment;
import com.ibm.rational.wvcm.stp.cq.CqContextResource;
import com.ibm.rational.wvcm.stp.cq.CqProvider;
import com.ibm.rational.wvcm.stp.cq.CqQuery;
import com.ibm.rational.wvcm.stp.cq.CqRecord;
import com.ibm.rational.wvcm.stp.cq.CqResource;
import com.ibm.rational.wvcm.stp.cq.CqResultSet;
import com.ibm.rational.wvcm.stp.cq.CqUserDb;
import com.ibm.rational.wvcm.stp.cqex.CqExRecordType;
import com.ibm.team.interop.service.managers.clearquest.common.InteropConnectionInfo;
import com.ibm.team.interop.service.managers.clearquest.common.InteropException;
import com.rational.clearquest.cqjni.CQAdminSession;
import com.rational.clearquest.cqjni.CQClearQuest;
import com.rational.clearquest.cqjni.CQDatabase;
import com.rational.clearquest.cqjni.CQPackageRev;
import com.rational.clearquest.cqjni.CQPackageRevs;
import com.rational.clearquest.cqjni.CQSchemaRev;
import com.rational.clearquest.cqjni.CQSession;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import javax.wvcm.Feedback;
import javax.wvcm.PropertyNameList;
import javax.wvcm.ProviderFactory;
import javax.wvcm.Resource;
import javax.wvcm.WvcmException;
import org.apache.commons.logging.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CqProviderForInterop71
extends CqProviderForInterop
implements ICqProvider {
    private InteropConnectionInfo m_info;
    private CqUserDb m_userDb = null;
    private ICQInteropEventHandler m_handler;
    private CqProvider m_delegate;
    private Log m_log = LogFactory.getLog();
    private Log m_logDetails = LogFactory.getLog((int)2);
    private Integer m_conflictErrors = 0;
    private static final int MAX_CONFLICTS = 3;
    private static final int NUMBER_OF_RETRIES = 3;
    private static final int RETRY_WAIT_TIME = 30;

    public List get_NO_DELIVERY() {
        return CqProvider.HOLD;
    }

    public List get_UNORDERED() {
        return CqProvider.DELIVER_ALL;
    }

    private void setCqUserDb() throws InteropException {
        if (this.m_userDb == null) {
            try {
                this.m_userDb = this.m_delegate.cqUserDb(this.m_delegate.pathLocation(StpProvider.Domain.CLEAR_QUEST, StpLocation.Namespace.USER_DB, this.getConnectionURI()));
                this.m_userDb = (CqUserDb)this.m_userDb.doReadProperties(null);
            }
            catch (WvcmException e) {
                if (e.getReasonCode() == WvcmException.ReasonCode.NOT_FOUND) {
                    this.m_log.error((Object)MessageFormat.format(Messages.getString("CqProviderForInterop71.ERROR_CONNECTING_TO_CQ_NOT_FOUND"), this.m_info.getConnectionURI()), (Throwable)e);
                }
                throw new InteropWvcmException71(e);
            }
        }
    }

    public void setSessionVariable(String name, String value) throws InteropException {
        try {
            CqUserDb.NamedValueName cqGatewayMarker = new CqUserDb.NamedValueName(name);
            this.m_userDb.setProperty((PropertyNameList.PropertyName)cqGatewayMarker, (Object)value);
            this.m_userDb.doWriteProperties(null);
        }
        catch (WvcmException e) {
            this.m_log.error((Object)MessageFormat.format(Messages.getString("CqProviderForInterop71.ERROR_SETTING_CQ_SESSION_VARIABLE"), name, value, this.getConnectionURI()), (Throwable)e);
            throw new InteropWvcmException71(e);
        }
    }

    public void init(InteropConnectionInfo info, ICQInteropEventHandler handler, boolean hasAdminSession, String name) throws InteropException {
        String stpProviderName = "com.ibm.rational.stp.client.internal.cq.CqJniOnlyProvider";
        try {
            this.m_info = info;
            this.m_handler = handler;
            String userId = info.getUserId();
            String password = info.getPassword();
            if (this.m_logDetails.isDebugEnabled()) {
                this.m_logDetails.debug((Object)("Getting Team Provider for " + info.getConnectionURI() + " login: " + userId));
            }
            StpProvider provider = (StpProvider)ProviderFactory.createProvider((String)stpProviderName, (ProviderFactory.Callback)new CQLogin(userId, password));
            this.m_delegate = provider.cqProvider();
            if (hasAdminSession) {
                this.setCqUserDb();
                this.setSessionVariable("_JAZZ_CQ_CONNECTOR_SESSION", "True");
                if (this.m_logDetails.isDebugEnabled()) {
                    this.m_logDetails.debug((Object)("Allocating an admin session for " + info.getConnectionURI() + " thread name: " + name));
                }
            }
        }
        catch (InteropException e) {
            throw e;
        }
        catch (Exception e) {
            if (this.m_log.isDebugEnabled()) {
                this.m_log.error((Object)MessageFormat.format(Messages.getString("CqProviderForInterop71.ERROR_CONNECTING_TO_CQ"), info.getConnectionURI()), (Throwable)e);
            }
            throw new InteropException((Throwable)e);
        }
    }

    public ICqRecordType getRecordTypeInfo(String typeName) throws InteropException {
        return this.m_handler.getRecordTypeInfo(typeName);
    }

    public void clearCache() throws InteropException {
        try {
            if (this.m_logDetails.isDebugEnabled()) {
                this.m_logDetails.debug((Object)("Clearing cache of handler " + this.m_handler + " using TeamAPI"));
            }
            this.m_userDb.doClearContext(null);
        }
        catch (WvcmException e) {
            throw new InteropException((Throwable)e);
        }
    }

    public String getConnectionURI() {
        return this.m_info.getConnectionURI();
    }

    public List<String> getPrivateDataProperties() {
        return this.m_handler.getPrivateDataProperties();
    }

    public ICQInteropEventHandler getHandler() {
        return this.m_handler;
    }

    public void terminate() throws InteropException {
        try {
            this.m_delegate.terminate();
        }
        catch (WvcmException e) {
            throw new InteropWvcmException71(e);
        }
    }

    public boolean isJNIProvider() {
        return this.m_delegate.getClass().getName().equals("com.ibm.rational.stp.client.internal.cq.CqJniOnlyProvider");
    }

    public int checkForCorrectPackageLevel() {
        CQPackageRev packRev;
        block6: {
            try {
                CQClearQuest cq = new CQClearQuest();
                CQSession session = cq.CreateUserSession();
                String[] dbSetDbName = this.m_info.getConnectionURI().split("/");
                session.UserLogon(this.m_info.getUserId(), this.m_info.getPassword(), dbSetDbName[1], dbSetDbName[0]);
                CQPackageRevs packRevs = session.GetEnabledPackageRevs();
                packRev = packRevs.ItemByName("JazzInterop");
                if (packRev != null) break block6;
                CQAdminSession adminSession = cq.CreateAdminSession();
                adminSession.Logon(this.m_info.getUserId(), this.m_info.getPassword(), dbSetDbName[0]);
                CQDatabase db = adminSession.GetDatabase(dbSetDbName[1]);
                CQSchemaRev schemaRev = db.GetSchemaRev();
                String schemaName = schemaRev.GetSchema().GetName();
                if (schemaName.equals("DefectTrackingInterop") || schemaName.equals("DefectTracking") && dbSetDbName[1].equalsIgnoreCase("cqjaz")) {
                    return 4;
                }
                return 2;
            }
            catch (Exception exception) {
                return 1;
            }
        }
        String revString = packRev.GetRevString();
        Float revFloat = Float.valueOf(revString);
        Float minFloat = Float.valueOf("1.06");
        boolean correctLevel = false;
        if (revFloat.floatValue() >= minFloat.floatValue()) {
            correctLevel = true;
        }
        if (!correctLevel) {
            return 0;
        }
        return 3;
    }

    public ICqRecordType getCqRecordTypeInfo(String typeName) throws InteropException {
        return this.m_handler.getRecordTypeInfo(typeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrementConflictCounter() {
        Integer n = this.m_conflictErrors;
        synchronized (n) {
            this.m_conflictErrors = this.m_conflictErrors + 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetConflictCounter() {
        Integer n = this.m_conflictErrors;
        synchronized (n) {
            this.m_conflictErrors = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean usable() {
        Integer n = this.m_conflictErrors;
        synchronized (n) {
            return this.m_conflictErrors <= 3;
        }
    }

    public Resource doReadProperties(CqResource resource, Feedback requestedPropertyNames) throws InteropException {
        int retriesLeft = 3;
        Object lastException = null;
        while (retriesLeft > 0) {
            try {
                Resource newResource = resource.doReadProperties(requestedPropertyNames);
                this.resetConflictCounter();
                return newResource;
            }
            catch (WvcmException e) {
                lastException = new InteropWvcmException71(e);
                if (!((InteropWvcmException)lastException).conflictException()) {
                    throw lastException;
                }
                this.incrementConflictCounter();
            }
            catch (Throwable e) {
                lastException = new InteropException(e);
            }
            try {
                Thread.sleep(30L);
            }
            catch (Throwable throwable) {}
            if (!this.m_logDetails.isDebugEnabled() || --retriesLeft <= 0) continue;
            this.m_logDetails.debug((Object)("Reading " + (Object)((Object)this) + " caused a conflict.  Retrying."));
        }
        if (this.m_logDetails.isDebugEnabled() && retriesLeft > 0) {
            this.m_logDetails.debug((Object)"Not Found after 3 retries");
        }
        throw lastException;
    }

    public void doDelete(CqContextResource resource) throws InteropException {
        int retriesLeft = 3;
        InteropWvcmException71 lastException = null;
        while (retriesLeft > 0) {
            try {
                resource.doUnbindAll(null, CqProvider.DELIVER_ALL);
                this.resetConflictCounter();
                return;
            }
            catch (WvcmException e) {
                lastException = new InteropWvcmException71(e);
                if (!((InteropWvcmException)lastException).conflictException()) {
                    throw lastException;
                }
                this.incrementConflictCounter();
            }
            catch (Throwable e) {
                lastException = new InteropWvcmException71(e);
            }
            try {
                Thread.sleep(30L);
            }
            catch (Throwable throwable) {}
            if (!this.m_logDetails.isDebugEnabled() || --retriesLeft <= 0) continue;
            this.m_logDetails.debug((Object)("Deleting " + resource + " caused a conflict.  Retrying."));
        }
        if (this.m_logDetails.isDebugEnabled() && retriesLeft > 0) {
            this.m_logDetails.debug((Object)"Not deleted after 3 retries");
        }
        throw lastException;
    }

    public CqAttachment doReadContent(CqAttachment attach, String tempFileName, Feedback feedback) throws InteropException {
        try {
            CqAttachment newAttach = attach.doReadContent(tempFileName, feedback);
            this.resetConflictCounter();
            return newAttach;
        }
        catch (WvcmException e) {
            InteropWvcmException71 newE = new InteropWvcmException71(e);
            if (newE.conflictException()) {
                this.incrementConflictCounter();
            }
            throw newE;
        }
    }

    public CqAttachment doCreateAttachment(CqAttachment attach, String tempFileName, Feedback feedback, List<CqContextResource> deliverParameter) throws InteropException {
        try {
            CqAttachment newAttach = attach.doCreateAttachment(tempFileName, feedback, deliverParameter);
            this.resetConflictCounter();
            return newAttach;
        }
        catch (WvcmException e) {
            InteropWvcmException71 newE = new InteropWvcmException71(e);
            if (newE.conflictException()) {
                this.incrementConflictCounter();
            }
            throw newE;
        }
    }

    public CqRecord doCreateRecord(CqRecord record, Feedback feedback, List<CqContextResource> deliverParameter) throws InteropException {
        try {
            CqRecord newRecord = record.doCreateRecord(feedback, deliverParameter);
            this.resetConflictCounter();
            return newRecord;
        }
        catch (WvcmException e) {
            InteropWvcmException71 newE = new InteropWvcmException71(e);
            if (newE.conflictException()) {
                this.incrementConflictCounter();
            }
            throw newE;
        }
    }

    public void doRevert(CqContextResource resource) throws InteropException {
        try {
            resource.doRevert(null);
            this.resetConflictCounter();
        }
        catch (WvcmException e) {
            InteropWvcmException71 newE = new InteropWvcmException71(e);
            if (newE.conflictException()) {
                this.incrementConflictCounter();
            }
            throw newE;
        }
    }

    public Iterator doQuery(CqExRecordType recordType, CqQuery.DisplayField[] displayFields, CqQuery.Filter filtering, long targetRow, long maxRows, CqQuery.ListOptions countRows) throws InteropException {
        try {
            CqResultSet i = recordType.doQuery(displayFields, filtering, targetRow, maxRows, countRows);
            this.resetConflictCounter();
            return i;
        }
        catch (WvcmException e) {
            InteropWvcmException71 newE = new InteropWvcmException71(e);
            if (newE.conflictException()) {
                this.incrementConflictCounter();
            }
            throw newE;
        }
    }

    public Object getDelegate() {
        return this.m_delegate;
    }

    public ICqResultSet getCqResultSet(Iterator resultSet) {
        return new CqResultSetForInterop71(resultSet);
    }

    private static class CQLogin
    implements ProviderFactory.Callback {
        private String userId;
        private String password;

        public CQLogin(String userId, String password) {
            this.userId = userId;
            this.password = password;
        }

        public ProviderFactory.Callback.Authentication getAuthentication(String realm, int retryCount) {
            if (retryCount > 0) {
                throw new UnsupportedOperationException(Messages.getString("CqProviderForInterop71.ERROR_BAD_CQ_CREDENTIALS"));
            }
            return new ProviderFactory.Callback.Authentication(){

                public String loginName() {
                    return CQLogin.this.getUserId();
                }

                public String password() {
                    return CQLogin.this.getPassword();
                }
            };
        }

        public String getPassword() {
            return this.password;
        }

        public String getUserId() {
            return this.userId;
        }
    }
}

